<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_SalesMailing
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\SalesMailing\Model;

class PdfReceivedObserver extends \Magento\Framework\Model\AbstractModel
{
    protected $_processLog = null;
    protected $salesMailingHelper;
    protected $fileResolver;
    protected $infoMailing;
    protected $mailingObserver;
    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Xtwo\SalesMailing\Helper\Data $salesMailingHelper,
        \Xtwo\SalesMailing\Model\Service\FileResolver $fileResolver,
        \Xtwo\SalesMailing\Model\Order\InfoMailing $infoMailing,
        \Xtwo\SalesMailing\Model\Observer $mailingObserver,
        \Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        
        array $data = []
    ) {
        $this->salesMailingHelper=$salesMailingHelper;
        $this->fileResolver =$fileResolver;
        parent::__construct(
            $context,
            $registry,
            $resource,
            $resourceCollection,
            $data
        );
    }
    
    /**
     * @param $observerData
     */
    public function infoMailingPdfDocuments($observerData) {
        /** @var \Xtwo\SalesMailing\Helper\Data $helper */
        //$helper = Mage::helper('xtwo_salesmailing');
        $helper= $this->salesMailingHelper;

        $file = null;
        $isMatch = false;
        $failure = '';
        $mailResult = null;

        try {
            /** @var \Magento\Sales\Model\Order $order */
            $order = null;
            $objectName = $objectFilePath = '';
            $order = $observerData['order'];
            /** @var Varien_Object $file */
            $file = $observerData['file'];

            try {
                /** @var \Xtwo\SalesMailing\Model\Service\FileResolver $fileResolver */
                //$fileResolver = Mage::getSingleton('xtwo_salesmailing/service_fileResolver');
                //$fileResolver =$this->fileResolver;
                if ($file->getType() == 'shipment') {
                    $objectName = 'Shipment for Order#' . $order->getIncrementId();
                    $objectFilePath = $this->fileResolver->getShippingDocumentPath($order, $file);
                } elseif ($file->getType() == 'invoice') {
                    $objectName = 'Invoice for Order#' . $order->getIncrementId();
                    $objectFilePath = $this->fileResolver->getInvoiceDocumentPath($order, $file);
                } elseif ($file->getType() == 'orderconfirmation') {
                    $objectName = 'OrderConfirmation for Order#' . $order->getIncrementId();
                    $objectFilePath = $this->fileResolver->getOrderConfirmationDocumentPath($order, $file);
                } elseif ($file->getType() == 'creditmemo') {
                    $objectName = 'CreditMemo for Order#' . $order->getIncrementId();
                    $objectFilePath = $this->fileResolver->getCreditMemoDocumentPath($order, $file);
                } else {
                    $helper->log(\Zend_Log::ALERT, sprintf('Unsupported type: %s => ignored', $file->getType()));
                }
            } catch (Exception $e) {
                $helper->log(\Zend_Log::ALERT, sprintf('Unexpected exception: %s ', $e->getMessage()));
                $objectFilePath = null;
            } catch (Throwable $e) {
                $helper->log(\Zend_Log::ALERT, sprintf('Unexpected throwable: %s ', $e->getMessage()));
                $objectFilePath = null;
            }


            if ($order && !empty($objectFilePath)) {

                $objectFilePath = reset($objectFilePath);

                /** @var \Xtwo\SalesMailing\Model\Order\InfoMailing $infoMailing */
                //$infoMailing = Mage::getModel('xtwo_salesmailing/order_infoMailing')->load($order->getId());
                $infoMailing = $this->infoMailing->load($order->getId());
                if (!$infoMailing || !$infoMailing->getId()) {
                    $helper->log(Zend_Log::WARN, sprintf('No infomailing item found for order %s => ignored',
                        $order->getIncrementId()));
                    $failure = 'InfoMailing item not found.';
                    return;
                }

                try {
                    $configurations = $helper->getActiveConfigurations();

                    /** @var \Xtwo\SalesMailing\Model\Configuration $configuration */
                    foreach ($configurations as $configuration) {
                        if ($configuration->matchesExternalTriggeredEvent($file, $order)) {
                            $now = new \Zend_Date();

                            $attachments = null;
                            if ($objectFilePath) {
                                $attachments = array($objectFilePath => 'application/pdf');
                            }

                            /** @var \Xtwo\SalesMailing\Model\Observer $mailingObserver */
                            //$mailingObserver = Mage::getSingleton('xtwo_salesmailing/observer');
                            $mailResult = $this->mailingObserver->queueInfoMail($infoMailing, $configuration, false, $attachments);
                            $infoMailing->setLastEmailSentAt($now);
                            $logData = sprintf('PDF, %s, %s', $objectName, $mailResult->getStatusInfoAsString());
                            $this->addProcessLog($infoMailing, $logData);
                            $helper->log(\Zend_Log::INFO, 'External triggered: ' . $logData);
                            $isMatch = true;
                            break;
                        }
                    }
                    if (!$isMatch) {
                        $msg = sprintf('No match on external triggered event. Order#%s status=%s Active on Store?',
                            $order->getIncrementId(), $order->getStatus());
                        $helper->log(\Zend_Log::WARN, $msg);
                        $failure = $msg;
                    }

                    // Mark as processed for each case
                    if ($this->_processLog && $infoMailing->hasProcessLog()) {
                        try {
                            $infoMailing->addProcessLog($this->_processLog);
                            $infoMailing->save();
                        } catch (Exception $e) {
                            $helper->log(\Zend_Log::ALERT,
                                'Problem on InfoMailing External Triggered: ' . $e->getTraceAsString());
                        }
                    }

                } catch (Exception $e) {
                    $helper->log(\Zend_Log::ALERT, 'Exception (in PDF sending):' . $e->getMessage());
                    $failure = $e->getMessage();

                } finally {
                    // Reset for next - we have a singleton
                    $this->_processLog = null;
                }

            } else {
                $helper->log(\Zend_Log::ERR, sprintf('Target document path invalid? %s', print_r($objectFilePath, true)));
            }

        } catch (Throwable $t) {
            $helper->log(\Zend_Log::ALERT, sprintf("Unexpected throwable: %s\n%s",
                $t->getMessage(), $t->getTraceAsString()));
            $failure = $t->getMessage();

        } finally {
            if ($file) {
                $finalResult = sprintf('%s [mail=%s]', $isMatch ? 'SUCCESS' : ('FAIL: '.$failure),
                    $mailResult ? $mailResult->getStatusInfoAsString() :'NO');
                $file->setData('result', $finalResult);
            }
        }

    }

    /**
     * @param \Xtwo\SalesMailing\Model\Order\InfoMailing $item
     * @param string $msg
     */
    private function addProcessLog($item, $msg) {
        if (is_null($this->_processLog)) {
            $this->_processLog = date('Y-m-d H:i:s');
        }
        $this->_processLog .= sprintf(' [status=%s] %s', $item->getStatus(), $msg);
    }
}