<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_SalesMailing
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 * @method int getVersionId()
 * @method setVersionId($value)
 * @method string getChangelogName()
 * @method setLastModified($value)
 * @method setStatus($value)
 * @method setEntityId($value)
 * @method string getStatus()
 * @method string getProcessLog()
 * @method setComment($value)
 * @method setLastDuration($v)
 * @method getStatusChangeProcessed()
 * @method setStatusChangeProcessed($v)
 * @method setStatusChangeAt($v)
 * @method string getBlockedUntil()
 * @method setBlockedUntil($blockUntil)
 * @method setLastEmailSentAt($date)
 * @method string getLastEmailSentAt()
 */

namespace Xtwo\SalesMailing\Model\Order;
use Xtwo\SalesMailing\Model\Resource\Order\InfoMailing as ResourceModel;


class InfoMailing extends \Magento\Framework\Model\AbstractModel

{
    CONST EMAIL_TEMPL_LOG_ENTRY = 'emailTempl';

    protected $_order = null;

    /**
     * @var \Magento\Sales\Model\OrderFactory
     */
    protected $salesOrderFactory;

    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Sales\Model\OrderFactory $salesOrderFactory,
        \Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        $this->salesOrderFactory = $salesOrderFactory;
        parent::__construct(
            $context,
            $registry,
            $resource,
            $resourceCollection,
            $data
        );
    }

    /**
     * @param $_processLog
     * @return self
     */
    public function addProcessLog($_processLog) {
        $log = $this->getProcessLog();
        if (empty($log)) $log = '';
        $log .= $_processLog . "\n";
        $this->setData('process_log', $log);
        return $this;
    }

    /** @return bool */
    public function hasProcessLog() {
        $log = trim($this->getProcessLog());
        return !empty($log);
    }

    /**
     * @see Varien_Object::_construct()
     */
    protected function _construct()
    {
        //$infom= new Xtwo\SalesMailing\order\infoMailing;
        //$this->_init('Xtwo\SalesMailing\Model\Order\infoMailing');
        
        $this->_init(ResourceModel::class);
    }



    public function __toString() {
        $value = sprintf('OrderInfoMailingItem, Name=%s, ChangeLog=%s', '', '');
        return $value;
    }


    /**
     * @return bool|\Magento\Sales\Model\Order|null
     */
    public function getOrder() {
        if (is_null($this->_order)) {
            $this->_order = $this->salesOrderFactory->create()->load($this->getId());
        }
        if ($this->_order->getId()) {
            return $this->_order;
        }
        return false;
    }

    /**
     * Usecase: For any reason an order switches back to processing (because of payment) => the trigger creates a new
     * entry for infomailing to be processed. We want here to ensure that we don't send any further mail in case we
     * already sent it.
     *
     * @param $order
     * @return bool
     */
    public function isStatusHandlingToBeBlocked($order) {
        $entries = $this->getLogEntriesForStatus('canceled');
        if (in_array('canceled', $entries)) {
            return true;
        }
        return false;
    }

    /**
     * Checks for an already sent E-Mail on the given Template ID and the InfoMailing Status
     *
     * @param $templateId
     * @return bool
     */
    public function isEMailTemplateAlreadySent($templateId) {
        $result = $this->getTemplateIdSentDateTime($templateId, $this->getStatus());
        return !empty($result);
    }

    /**
     * @param $templateId
     * @param null|string $status
     * @return bool|string
     */
    public function getTemplateIdSentDateTime($templateId, $status=null) {
        $log = $this->getProcessLog();
        if (!empty($log)) {
            $logLines = explode("\n", $log);
            foreach ($logLines as $logLine) {
                if ($status && stripos($logLine, $status) === false) continue;
                if (stripos($logLine, (self::EMAIL_TEMPL_LOG_ENTRY.'='.$templateId)) !== false) {
                    $pos = strpos($logLine, ' [status=');
                    return $pos ? substr($logLine, 0, $pos) : false;
                }
            }
        }
        return false;
    }

    /**
     * Returns array with timestamp (latest top) as key and status as value.
     * @param $status
     * @return array
     */
    public function getLogEntriesForStatus($status) {
        $result = array();
        $log = $this->getProcessLog();
        if (!empty($log)) {
            $logLines = explode("\n", $log);
            foreach ($logLines as $logLine) {
                $lineData = explode(' ', $logLine);
                if (empty($logLine) || count($lineData) < 3 ) continue;
                $date = $lineData[0];
                $time = $lineData[1];
                $statusTerm = $lineData[2];
                if (strpos($statusTerm, $status) !== false) {
                    $timestamp = strtotime($date.' '.$time);
                    $result[$timestamp] = $status;
                }
            }
        }
        return $result;
    }
}