<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_SalesMailing
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

 namespace Xtwo\SalesMailing\Model;

 use Magento\Framework\DataObject;

 class Observer extends \Magento\Framework\Model\AbstractModel
 {
    /** number of hours to generally look back on status creation */
    const HOURS_LOOKBACK = 150;
    /** number of hours to wait (block) if a shipping tracking code is not available */
    const HOURS_BLOCK_WAIT_TRACKING_CODE = 2;

    protected $_processLog = null;
    /**
     * \Magento\Store\Model\App\Emulation
    */
    protected $storeAppEmulation;
    /**
     * @var \Magento\Payment\Helper\Data
     */
    protected $paymentHelper;

    /**
     * @var \Magento\Framework\Mail\Template\TransportBuilderFactory
     */
    protected $templateTransportBuilderFactory;

    /**
     * @var \Magento\Framework\Mail\MessageInterfaceFactory
     */
    protected $messageInterfaceFactory;

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;
    /**
     * \Magento\Store\Model\App\Emulation
    */
    protected $emulation;

    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Store\Model\App\Emulation $storeAppEmulation,
        \Magento\Payment\Helper\Data $paymentHelper,
        \Magento\Framework\Mail\Template\TransportBuilderFactory $templateTransportBuilderFactory,
        \Magento\Framework\Mail\MessageInterfaceFactory $messageInterfaceFactory,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Xtwo\SalesMailing\Helper\Data $salesMailingHelper,
        \Xtwo\SalesMailing\Model\Resource\Order\InfoMailing\Collection $salesCollection,
        \Xtwo\SalesMailing\Model\Order\InfoMailing $infoMailing,
        \Magento\Store\Model\App\Emulation $emulation,
        \Xtwo\SalesMailing\Model\Core\Email\Template\Mailer $emailMailer,
        \Magento\Framework\Mail\Template\TransportBuilder $transportBuilder,
        \Psr\Log\LoggerInterface $logger,
        \Xtwo\SalesMailing\Logger\Logger $smLogger,
        \Magento\Framework\Stdlib\DateTime\DateTime $dateTime,
        \Magento\Framework\Stdlib\DateTime\TimezoneInterface $timezoneInterface,
        \Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        
        array $data = []
    ) {
        $this->storeAppEmulation = $storeAppEmulation;
        $this->paymentHelper = $paymentHelper;
        $this->templateTransportBuilderFactory = $templateTransportBuilderFactory;
        $this->messageInterfaceFactory = $messageInterfaceFactory;
        $this->scopeConfig = $scopeConfig;
        $this->salesMailingHelper =$salesMailingHelper;
        $this->salesCollection =$salesCollection;
        $this->emulation = $emulation;
        $this->emailMailer = $emailMailer;
        $this->transportBuilder= $transportBuilder;
        $this->logger = $logger;
        $this->infoMailing=$infoMailing;
        $this->dateTime=$dateTime;
        $this->_timezoneInterface = $timezoneInterface;
        $this->smLogger=$smLogger;
        parent::__construct(
            $context,
            $registry,
            $resource,
            $resourceCollection,
            $data
        );
    }

    /**
     * Main processing method.
     *
     * @param $observer
     * @throws Zend_Date_Exception
     */
    public function processOrderInfoItems($observer) {
        /** @var \Xtwo\SalesMailing\Helper\Data $helper */
        //$helper = Mage::helper('xtwo_salesmailing');
        $configurations = $this->salesMailingHelper->getActiveConfigurations();
       
        if (empty($configurations)) {
            $this->logger->debug('Skipped as no active or invalid configuration found.',[]);
            $this->salesMailingHelper->log(\Zend_Log::INFO, 'Skipped as no active or invalid configuration found.');
            return;
        }
        $unhandledItems = $this->fetchUnhandledItems();
        /** @var \Xtwo\SalesMailing\Model\Order\InfoMailing $unhandledItem */     
        $delayhas = 0;
        $delayno = 0;
        $limit = null;
        $till = 0;
        $blockedTime = null;
        $now = $this->_timezoneInterface->date(new \DateTime(new \Zend_Date()))->format('Y-m-d H:i:s');       
        foreach($unhandledItems as $unhandledItem){
            try {
                $order = $unhandledItem->getOrder();
                if ($order) {
                    
                    $status = $order->getStatus();
                    $shippingMethod = $order->getShippingMethod();
                    foreach($configurations as $config){
                        if ($unhandledItem->getStatus() == $status) {
                            $configuration = $this->salesMailingHelper->getActiveConfiguration($config);                        
                            if ($configuration->matchesOrder($order)) {                         
                                $blockedUntil = $unhandledItem->getBlockedUntil();
                                if(!$configuration->getDelay()){   
                                    $delayno = 1;
                                    $now = $this->_timezoneInterface->date(new \DateTime(new \Zend_Date()))->format('Y-m-d H:i:s');
                                    if($blockedUntil == NULL){
                                        if(($configuration->getShippingMethod() == 'flatrate_flatrate') && ($configuration->getShippingMethod() == $shippingMethod)){
                                            $result = $this->queueInfoMail($unhandledItem, $configuration, null, null, $limit);
                                            $unhandledItem->setLastEmailSentAt($now);
                                        }else{
                                            $result = $this->queueInfoMail($unhandledItem, $configuration, null, null, $limit);
                                            $unhandledItem->setLastEmailSentAt($now);
                                        }
                                    }                                    

                                }
                                if($configuration->getDelay()){           
                                    $delayhas = 1;
                                    $limit = new \Zend_Date();
                                    $limit->addHour($configuration->getDelay());
                                    $blockedTime = $this->_timezoneInterface->date(new \DateTime($limit))->format('Y-m-d H:i:s');                                
                                    if($blockedUntil == NULL){  
                                        $till = 1;
                                        $blockedTime = $this->_timezoneInterface->date(new \DateTime($limit))->format('Y-m-d H:i:s');                               
                                    } 
                                    if($blockedUntil != NULL){
                                        if($now >= $blockedUntil && $blockedUntil != NULL){
                                            $result = $this->queueInfoMail($unhandledItem, $configuration, null, null, $limit);
                                            $unhandledItem->setLastEmailSentAt($now);
                                            $unhandledItem->setStatusChangeProcessed($now);
                                            $unhandledItem->save();                                    
                                        }     

                                    }                             

                                }                            
                                
                            }
                        }                      

                    }
                }            
                if($till == 1){
                    $unhandledItem->setBlockedUntil($blockedTime);
                    $unhandledItem->save();
                }
                if($delayno == 1 && $delayhas != 1){
                    $unhandledItem->setStatusChangeProcessed($now);
                    $unhandledItem->save();                       
                }else{
                    $unhandledItem->save();
                }
                //$unhandledItem->save();
            } catch(\Exception $e) {
                $this->setProcessLog('Problem on processing InfoMailing:',['exception'=>$e->getTraceAsString()]);
                $this->salesMailingHelper->log(\Zend_Log::ALERT, 'Unexpected exception: '.$e->getMessage());
                $this->logger->debug('Problem on processing InfoMailing:',['exception'=>$e->getTraceAsString()]);
                $unhandledItem->save();
            }
            //$this->resetProcessLog();
        }

    }
    /**
     * @param \Xtwo\SalesMailing\Model\Order\InfoMailing $item
     * @param string $msg
     */
    private function addProcessLog($item, $msg) {
        if (is_null($this->_processLog)) {
            $this->_processLog = date('Y-m-d H:i:s');
        }
        $this->_processLog .= sprintf(' [status=%s] %s', $item->getStatus(), $msg);
    }
    /**
     *
     * @throws Zend_Date_Exception
     */
    private function fetchUnhandledItems() {
        $limit = new \Zend_Date();
        $limit->subHour(self::HOURS_LOOKBACK);
        $now = new \Zend_Date();        
        /** @var \Xtwo\SalesMailing\Model\Resource\Order\InfoMailing\Collection $items */        
        $getData= array('pending','processing','complete','canceled','payment_review');
        $items = $this->infoMailing->getCollection();
        $items->addFieldToFilter('status',array('in'=> $getData ));        
        $items->addFieldToFilter('status_change_processed', array('null' => true));        
        $items->addFieldToFilter(array('blocked_until'),
            array(
                array(
                array('attribute' => 'blocked_until', 'null' => true),
                array('attribute' => 'blocked_until', 'lt' => $this->_timezoneInterface->date(new \DateTime($now))->format('Y-m-d H:i:s'))
                )
            )
        );
        $items->addFieldToFilter('status_change_at', array('gt' => $this->_timezoneInterface->date(new \DateTime($limit))->format('Y-m-d H:i:s')));
        //echo $qurey = $items->getSelect()->__toString();        
        /** @var \Xtwo\SalesMailing\Helper\Data $infoMailingHelper */
        $infoMailingHelper = $this->salesMailingHelper;//Mage::helper('xtwo_salesmailing');
        $infoMailingHelper->log(\Zend_Log::INFO, sprintf('InfoMailing, fetched %s items to be processed', $items->getSize()));
        
        return $items;
    }

    private function resetProcessLog() {
        $this->_processLog = null;
    }
    /**
     * Queue email with new order data
     *
     * @param \Xtwo\SalesMailing\Model\Order\InfoMailing $infoMailing
     * @param \Xtwo\SalesMailing\Model\Configuration $configuration
     * @param bool $forceMode if true then email will be sent regardless of the fact that it was already sent previously
     * @param null $attachments array with <file-path> => <content-type>
     * @return \Xtwo\SalesMailing\Model\QueueInfoMailResult
     * @throws Exception
     */
    public function queueInfoMail($infoMailing, $configuration, $forceMode = false, $attachments=null, $limit=null)
    {
        $order = $infoMailing->getOrder();
		
        $storeId = $order->getStoreId();
        $infoMailResult = new \Xtwo\SalesMailing\Model\QueueInfoMailResult();
        $templateId = $configuration->getTemplateId($order->getStoreId());
    
        // Check for double-sent E-Mail (which may occur). If we have attachments we send Invoices, Shipments - in that
        // case we allow sending them!
        if ($infoMailing->isEMailTemplateAlreadySent($templateId) && empty($attachments)) {
            $infoMailResult->setStatusBlocked();
            $infoMailResult->addStatusInfo(
                \Xtwo\SalesMailing\Model\Order\InfoMailing::EMAIL_TEMPL_LOG_ENTRY.'='.$templateId);
            return $infoMailResult;
           
        }
        
        // Start store emulation process
        /** @var $appEmulation Mage_Core_Model_App_Emulation */
        //$appEmulation = Mage::getSingleton('core/app_emulation');
        
        //$initialEnvironmentInfo = $appEmulation->startEnvironmentEmulation($storeId);
        $initialEnvironmentInfo = $this->emulation->startEnvironmentEmulation($storeId);


        $paymentBlockHtml = '';
        if ($order->getPayment()) {
            try {
                // Retrieve specified view block from appropriate design package (depends on emulated store)                
            } catch (\Exception $exception) {
                // Stop store emulation process
                $this->emulation->stopEnvironmentEmulation($initialEnvironmentInfo);
                throw $exception;
            }
        }

        // Stop store emulation process
        //$appEmulation->stopEnvironmentEmulation($initialEnvironmentInfo);
        $this->emulation->stopEnvironmentEmulation($initialEnvironmentInfo);

        // Retrieve corresponding email template id and customer name
        if ($order->getCustomerIsGuest()) {
            $customerName = $order->getBillingAddress()->getName();
        } else {
            $customerName = $order->getCustomerName();
        }
        /** @var $mailer \Xtwo\SalesMailing\Model\Core\Email\Template\Mailer */
        $mailer = $this->emailMailer;
        
        /** @var $emailInfo Mage_Core_Model_Email_Info */
        $shipments = $order->getShipmentsCollection();
        $sender = $this->getSender($configuration, $order);
        
        $transport = [
            'order' => $order,
            'order_id' => $order->getId(),
            'billing' => $order->getBillingAddress(),
            'payment_html' => $this->getPaymentHtml($order),
            'store' => $order->getStore(),
            'formattedShippingAddress' => $this->salesMailingHelper->getFormattedShippingAddress($order),
            'formattedBillingAddress' => $this->salesMailingHelper->getFormattedBillingAddress($order),
            'created_at_formatted' => $order->getCreatedAtFormatted(2),
            'order_data' => [
                'customer_name' => $order->getCustomerName(),
                'is_not_virtual' => $order->getIsNotVirtual(),
                'email_customer_note' => $order->getEmailCustomerNote(),
                'frontend_status_label' => $order->getFrontendStatusLabel()
            ]
        ];
        $transportObject = new DataObject($transport);


        $transport = $this->transportBuilder
                ->setTemplateIdentifier(
                    $templateId, 
                    \Magento\Store\Model\ScopeInterface::SCOPE_STORE)
                ->setTemplateOptions([
                    'area' => \Magento\Framework\App\Area::AREA_FRONTEND,
                    'store' => $storeId
                ])
                ->setTemplateVars($transportObject->getData())                
                ->setFrom($sender);

        if ($configuration->getSecondaryMailActive() && $configuration->getInternalRecipientsSecondary()) {
            $toEmail = $configuration->getInternalRecipientsSecondary();
        } else {
            $toEmail = $configuration->isExternal() ? $order->getCustomerEmail() : $configuration->getInternalRecipients();

        }
        if (empty($toEmail)) {
            throw new \Magento\Framework\Exception\LocalizedException('no e-mail recipient given - check configuration!');
            $this->logger->debug('no e-mail recipient given',[]);
        }
        
        if (is_array($toEmail)) {
            
            foreach ($toEmail as $rec) {
                
                $transport->addTo($rec);
            }
        } else {
            $transport->addTo($toEmail, $customerName);
        }
        
        $copyBcc = $configuration->getBccRecipients();
        if($copyBcc){
            if (is_array($copyBcc)) {
                
                foreach ($copyBcc as $email) {
                    
                    $transport->addBcc($email);
                }
            } else {
                $transport->addBcc($copyBcc);
            }
        }                
        // Email copies are sent as separated emails if their copy method is 'copy'
        if ($copyCc = $configuration->getCcRecipients()) {
            foreach ($copyCc as $email) {               
                $transport->addBcc($email);
            }
        }
        // Set all required params and send emails
        /** @var $shipments Mage_Sales_Model_Entity_Order_Shipment_Collection */
        
        // Attachments
        $isAttachmentSet = false;
        if (!empty($attachments)) {
            
            foreach ($attachments as $filePath => $contentType) {
               
                $fileData = file_get_contents($filePath);

                if ($fileData) {
                    $transport->addAttachment($fileData, basename($filePath), $contentType);
                    //$this->transportBuilder->addAttachment($fileData,$filePath);  
                    $isAttachmentSet = true;
                }
                /*if (file_exists($filePath) && !empty($contentType)) {
                    $fileData = file_get_contents($filePath);
                   
                    if ($fileData) {
                        $transport->addAttachment($fileData, basename($filePath), $contentType);
                        $isAttachmentSet = true;
                    } else {
                        //Js_Log::log(sprintf('Invalid PDF attachment, empty file_get_contents, file=%s, content-type=%s',
                         //       $filePath, $contentType), $this, Zend_Log::ALERT);
                    }
                } else {
                    //Js_Log::log(sprintf('Invalid PDF attachment, file=%s, content-type=%s', $filePath, $contentType),
                    //    $this, \Zend_Log::ERR);
                }*/
            }
        }
        $transport=$transport->getTransport();
       
        try{
            if ($isAttachmentSet) {
                // The mail queue doesn't support attachments -> we directly send!
                $transport->sendMessage();
                
            } else {
                /** @var $emailQueue Mage_Core_Model_Email_Queue */            
                $transport->sendMessage();            
            }

        }catch(\Exception $e){
            echo $e->getMessage();
        }
       
        $infoMailResult->addStatusInfo('mail=SUCCESS');
        $infoMailResult->addStatusInfo('attachment='.(($isAttachmentSet) ? 'ADDED' : 'NONE'));
        $infoMailResult->addStatusInfo(
            \Xtwo\SalesMailing\Model\Order\InfoMailing::EMAIL_TEMPL_LOG_ENTRY.'='.$templateId);
        $infoMailResult->addStatusInfo('rec='.(is_array($toEmail) ? implode(',', $toEmail) : $toEmail));
        if (!empty($copyBcc)) {
            $infoMailResult->addStatusInfo('bcc='.(is_array($copyBcc) ? implode(',', $copyBcc) : $copyBcc));
        }
		//dd($infoMailResult);
        return $infoMailResult; 
		
        
    }

    /**
     * @param \Xtwo\SalesMailing\Model\Configuration $configuration
     * @param \Magento\Sales\Model\Order $order
     * @return array
     */
    private function getSender($configuration, $order) {
        $sender = array();
        $identity = $configuration->getEmailIdentity($order->getStoreId());
        if (strpos($identity, 'support') !== false) {
            $sender['name'] = $this->scopeConfig->getValue('trans_email/'.$identity.'/'.$identity.'_name', \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $order->getStoreId());
            $sender['email'] = $this->scopeConfig->getValue('trans_email/'.$identity.'/'.$identity .'_address', \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $order->getStoreId());
        } else {
            $sender['name'] = $this->scopeConfig->getValue('trans_email/ident_' . $identity . '/name', \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $order->getStoreId());
            $sender['email'] = $this->scopeConfig->getValue('trans_email/ident_' . $identity . '/email', \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $order->getStoreId());
        }
        return $sender;
    }


    /**
     * Get payment info block as html
     *
     * @param Order $order
     * @return string
     */
    protected function getPaymentHtml($order)
    {
        return $this->paymentHelper->getInfoBlockHtml($order->getPayment(), $order->getStoreId());
    }
    
 }