<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_SalesMailing
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

 namespace Xtwo\SalesMailing\Model;

class DocumentObserver
{
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var \Magento\Framework\Registry
     */
    protected $registry;
    protected $ftp;
    protected $fileFilter;
    protected $statusNotificationMessage;
    protected $doumentMover;
    protected $urlResolver;

    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\Registry $registry,
        \Xtwo\CoreHelpers\Helper\Ftp $ftp,
        \Xtwo\CoreHelpers\Model\Ftp\DirectoryFilter $directoryFilter,
        \Xtwo\CoreHelpers\Model\Ftp\FileFilter $fileFilter,
        \Xtwo\CoreHelpers\Model\StatusNotificationMessage $statusNotificationMessage,
        \Xtwo\SalesMailing\Model\Service\DocumentMover $doumentMover,
        \Xtwo\SalesMailing\Model\Service\UrlResolver $urlResolver,
       
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->registry = $registry;
        $this->ftp = $ftp;
        $this->directoryFilter = $directoryFilter;
        $this->fileFilter = $fileFilter;
        $this->statusNotificationMessage =$statusNotificationMessage;
        $this->doumentMover =$doumentMover;
        $this->urlResolver =$urlResolver;
        
    }
    /**
     * The PDF-Files are fetched from an external server via FTP
     *
     *      ##### currently not used #####
     */
    public function fetchFiles() {

        $ftpClient = null;
        try {
            /** @var Justselling_CoreHelpers_Model_Ftp_Client $ftpClient */
            //$ftpClient = Mage::helper('jscorehelpers/ftp')->getFtpClient('fetchpdfs');
            $ftpClient = $this->ftp->getFtpClient('fetchpdfs');
            if (empty($ftpClient->getCredentials()->getHost()) || $ftpClient->getCredentials()->getHost() == '-') {
                //Js_Log::log('Simulation ftp fetch status - do nothing.', $this, \Zend_Log::INFO, true);
                return;
            }

            $failedDownloads = array();
            $directoryFilter = $this->directoryFilter->setPath('others');
            /** @var $fileFilter Justselling_CoreHelpers_Model_Ftp_FileFilter */
            $fileFilter = $this->fileFilter;
            $fileFilter->addNameFilterPattern('.*invoice\.pdf');
            $fileFilter->addNameFilterPattern('.*delivery-note\.pdf');
            $fileFilter->addNameFilterPattern('.*order_confirmation\.pdf');
            $fileFilter->addNameFilterPattern('.*credit_memo\.pdf');

            $fileProxies = $ftpClient->listFiles($directoryFilter);
            /** @var Justselling_CoreHelpers_Model_Ftp_FileProxy $fileProxy */
            foreach ($fileProxies as $fileProxy) {
                $fileProxy->setLocalFilePath(
                    //Mage::getConfig()->getOptions()->getMediaDir() . DS .
                    $this->scopeConfig->getOptions()->getMediaDir().
                                        \Xtwo\SalesMailing\Model\Service\DocumentMover::READ_PATH_PART);
                $ftpClient->download($fileProxy);
                if ($fileProxy->getIsDownloaded()) {
                    $localFile = $fileProxy->getLocalFilePath();
                    //Js_Log::log(sprintf('Downloaded successfully: %s', $localFile),
                    //    $this, \Zend_Log::INFO, true);
                    $isDeleteSuccess = $ftpClient->fileDelete($fileProxy);
                    if (!$isDeleteSuccess) {
                        throw new Exception('File deletion failed:'.$fileProxy->getRemoteFileName());
                    }
                    //Js_Log::log(sprintf('Remote deletions successful: %s', $fileProxy->getRemoteFileName()),
                    //    $this, \Zend_Log::INFO, true);
                } else {
                    $failedDownloads[] = $fileProxy->getRemoteFileName();
                }
            }


            if (!empty($failedDownloads)) {
                $msg = sprintf('Ftp download of invoice/shipment files failed, files="%s"', implode(',', $failedDownloads));
                //Js_Log::log($msg, $this, \Zend_Log::ALERT, true);

                /** @var Justselling_CoreHelpers_Model_StatusNotificationMessage $statusMsg */
                //$statusMsg = Mage::getModel('jscorehelpers/statusNotificationMessage');
                $statusMsg =$this->statusNotificationMessage;
                $statusMsg->addError($msg);
                $statusMsg->setMailSubjectTopic('xtwo invoice/shipment PDF ftp download FAILURE!');
                $statusMsg->addRecipient(explode(',', $this->scopeConfig->getValue('dev/statusnoti/emails', \Magento\Store\Model\ScopeInterface::SCOPE_STORE)));
                $statusMsg->send();
            }

        } catch (Exception $e) {
            $msg = sprintf('Ftp download of invoice/shipment/order_confirmation/credit_memo files failed, reason:connect/login: %s"', $e->getMessage());
            //Js_Log::log($msg, $this, \Zend_Log::ALERT, true);

            /** @var Justselling_CoreHelpers_Model_StatusNotificationMessage $statusMsg */
            //$statusMsg = Mage::getModel('jscorehelpers/statusNotificationMessage');
            $statusMsg =$this->statusNotificationMessage;
            $statusMsg->addError($msg);
            $statusMsg->setMailSubjectTopic('xtwo invoice/shipment PDF ftp download Exception!');
            $statusMsg->addRecipient(explode(',', $this->scopeConfig->getValue('dev/statusnoti/emails', \Magento\Store\Model\ScopeInterface::SCOPE_STORE)));
            $statusMsg->send();
        }
        if ($ftpClient) {
            $ftpClient->disconnect();
        }

    }
    /**
     * Move documents
     *
     * @return $this
     * @throws \Exception
     */
    public function moveFiles()
    {
        //Mage::getSingleton('xtwo_infomailing/service_documentMover')->moveDocuments();
        $this->doumentMover->moveDocuments();

        return $this;
    }
    /**
     * Add button to invoice view
     *
     * @param Varien_Event_Observer $observer
     *
     * @return $this
     * @throws Varien_Exception
     */
    public function addDownloadButtonToInvoiceView(Varien_Event_Observer $observer)
    {
        $block = $observer->getBlock();
        if ($block instanceof \Magento\Sales\Block\Adminhtml\Order\View) {
            $order = $this->registry->registry('current_order');
            //$location = Mage::getSingleton('xtwo_salesmailing/service_urlResolver')->getInvoiceUrl($order);
            $location = $this->urlResolver->getInvoiceUrl($order);

            //if we got no location (file doesn't exist), don't show button
            if (!$location) {
                return $this;
            }
            $block->addButton(
                'xtwo_salesmailing_download',
                array(
                    'label'   => Mage::helper('xtwo_salesmailing')->__('Invoice PDF'),
                    'onclick' => "setLocation('$location')",
                    'class'   => 'go'
                )
            );

        }

        return $this;
    }
    /**
     * Add button to shipment view
     *
     * @param \Magento\Framework\Event\Observer $observer
     *
     * @return $this
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function addDownloadButtonToShipmentView(Varien_Event_Observer $observer)
    {
        $block = $observer->getBlock();
        if ($block instanceof \Magento\Sales\Block\Adminhtml\Order\View) {
            $order = $this->registry->registry('current_order');
            //$location = Mage::getSingleton('xtwo_salesmailing/service_urlResolver')->getShipmentUrl($order);
            $location = $this->urlResolver->getShipmentUrl($order);

            //if we got no location (file doesn't exist), don't show button
            if (!$location) {
                return $this;
            }
            $block->addButton(
                'justselling_infomailing_download',
                array(
                    'label'   => __('Shipment PDF'),
                    'onclick' => "setLocation('$location')",
                    'class'   => 'go'
                )
            );
        }

        return $this;
    }

    /**
     * Add button to order confirmation view
     *
     * @param \Magento\Framework\Event\Observer $observer
     *
     * @return $this
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function addDownloadButtonToOrderConfirmationView(\Magento\Framework\Event\Observer $observer)
    {
        $block = $observer->getBlock();
        if ($block instanceof \Magento\Sales\Block\Adminhtml\Order\View) {
            $order = $this->registry->registry('current_order');
            /** @var J\Xtwo\SalesMailing\Model\Service\UrlResolver $urlResolver */
            //$urlResolver = Mage::getSingleton('xtwo_salesmailing/service_urlResolver');
            $urlResolver = $this->urlResolver;
            $location = $urlResolver->getOrderConfirmationUrl($order);

            //if we got no location (file doesn't exist), don't show button
            if (!$location) {
                return $this;
            }
            $block->addButton(
                'xtwo_salesmailing_download',
                array(
                    //'label'   => Mage::helper('xtwo_salesmailing')->__('OrderConfirmation PDF'),
                    'label'   => __('OrderConfirmation PDF'),
                    'onclick' => "setLocation('$location')",
                    'class'   => 'go'
                )
            );
        }

        return $this;
    }

    /**
     * Add button to order confirmation view
     *
     * @param \Magento\Framework\Event\Observer $observer
     *
     * @return $this
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function addDownloadButtonToCreditMemoView(Varien_Event_Observer $observer)
    {
        $block = $observer->getBlock();
        if ($block instanceof \Magento\Sales\Block\Adminhtml\Order\View) {
            $order = $this->registry->registry('current_order');
            /** @var \Xtwo\SalesMailing\Model\Service\UrlResolver $urlResolver */
            //$urlResolver = Mage::getSingleton('xtwo_salesmailing/service_urlResolver');
            $urlResolver = $this->urlResolver;
            $location = $urlResolver->getCreditMemoUrl($order);

            //if we got no location (file doesn't exist), don't show button
            if (!$location) {
                return $this;
            }
            $block->addButton(
                'xtwo_salesmailing_download',
                array(
                    //'label'   => Mage::helper('xtwo_salesmailing')->__('CreditMemo PDF'),
                    'label'   => __('CreditMemo PDF'),
                    'onclick' => "setLocation('$location')",
                    'class'   => 'go'
                )
            );
        }

        return $this;
    }

}