<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_SalesMailing
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\SalesMailing\Model\Core\Email\Template;

class Mailer extends \Magento\Framework\Mail\Template\TransportBuilder
{
    protected $_afile = array();

    /**
     * @var \Magento\Email\Model\TemplateFactory
     */
    protected $emailTemplateFactory;

    public function __construct(
        \Magento\Framework\Mail\Template\FactoryInterface $templateFactory,
        \Magento\Framework\Mail\MessageInterface $message,
        \Magento\Framework\Mail\Template\SenderResolverInterface $senderResolver,
        \Magento\Framework\ObjectManagerInterface $objectManager,
        \Magento\Framework\Mail\TransportInterfaceFactory $mailTransportFactory,
        \Magento\Email\Model\TemplateFactory $emailTemplateFactory,
        \Magento\Store\Model\StoreManagerInterface $storeManager,   
        \Magento\Framework\Mail\MessageInterfaceFactory $messageFactory = null
    ) {
        $this->emailTemplateFactory = $emailTemplateFactory;
        $this->_storeManager = $storeManager;
        parent::__construct(
            $templateFactory,
            $message,
            $senderResolver,
            $objectManager,
            $mailTransportFactory,
            $messageFactory
        );
    }

    /**
     * @param $fileContents
     * @param $fileName
     * @param $contentType
     * @return $this
     */
    public function addAttachment($fileContents, $fileName, $contentType) {
        $tmp = array();
        $tmp['fileData'] = $fileContents;
        $tmp['fileName'] = $fileName;
        $tmp['contentType'] = $contentType;
        $this->_afile = $tmp;
        return $this;
    }

    /**
     * Send all emails from email list
     * @see self::$_emailInfos
     *
     * @return \Magento\Framework\Mail\Template\TransportBuilder
     */
    public function send()
    {
        
        /** @var $emailTemplate Mage_Core_Model_Email_Template */
        //$emailTemplate = Mage::getModel('core/email_template');
        $emailTemplate=$this->emailTemplateFactory;
        // Send all emails from corresponding list
        while (!empty($this->_emailInfos)) {
            $emailInfo = array_pop($this->_emailInfos);
            // Handle "Bcc" recipients of the current email
            $emailTemplate->addBcc($emailInfo->getBccEmails());

            // Attachments
            if (!empty($this->_afile)) {
                $attachment = $emailTemplate->getMail()->createAttachment($this->_afile['fileData']);
                $attachment->type = $this->_afile['contentType'];
                $attachment->filename = $this->_afile['fileName'];
                //Js_Log::log(sprintf('Attachment "%s" added, content-type=%s', $this->_afile['fileName'],
                //    $this->_afile['contentType']), $this, \Zend_Log::INFO);
            }
            // Set required design parameters and delegate email sending to Mage_Core_Model_Email_Template
            $emailTemplate->setDesignConfig(array('area' => 'frontend', 'store' => $this->getStoreId()));
            if ($this->getQueue()) {
                $emailTemplate->setQueue($this->getQueue());
            }
            if ($replyTo = $this->getReplyTo()) {
                $emailTemplate->setReplyTo($this->getReplyTo());
            }
            $emailTemplate->sendTransactional(
                    $this->getTemplateId(),
                    $this->getSender(),
                    $emailInfo->getToEmails(),
                    $emailInfo->getToNames(),
                    $this->getTemplateParams(),
                    $this->getStoreId()
                );
        }
        return $this;
    }
}