<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_SalesMailing
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\SalesMailing\Model;

class Configuration extends \Magento\Framework\Model\AbstractModel 
{
    const TRIGGER_TYPE_EXT_DOCUMENTS = 'external_documents';
    const TRIGGER_TYPE_EXT_SHIPMENT = 'external_shipment';
    const TRIGGER_TYPE_EXT_INVOICE = 'external_invoice';
    const TRIGGER_TYPE_EXT_CREDITMEMO = 'external_creditmemo';
    const TRIGGER_TYPE_EXT_ORDERCONFIRMATION = 'external_orderconfirmation';

    /** @var array List of InfoMailing types not handled by the core cron, but via external triggered process */
    public static $_EXTERNAL_TRIGGERED_TYPES = array(self::TRIGGER_TYPE_EXT_DOCUMENTS, self::TRIGGER_TYPE_EXT_SHIPMENT,
        self::TRIGGER_TYPE_EXT_INVOICE, self::TRIGGER_TYPE_EXT_CREDITMEMO, self::TRIGGER_TYPE_EXT_ORDERCONFIRMATION);

    private $mailBcc = [];
    private $mailCc = [];
    private $mailTo = [];
    protected $dateTime;
    protected $infoMailingItem;

    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Stdlib\DateTime\DateTime $dateTime,
        \Xtwo\SalesMailing\Model\Order\InfoMailing $infoMailingItem,
        \Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        $this->dateTime= $dateTime;
        $this->infoMailingItem =$infoMailingItem;
        parent::__construct(
            $context,
            $registry,
            $resource,
            $resourceCollection,
            $data
        );
    }

    /**
     * @param Xtwo\SalesMailing\Model\Order\InfoMailing $item
     * @return bool
     * @throws Zend_Date_Exception
     */
    public function isItemDelayReached(\Xtwo\SalesMailing\Model\Order\InfoMailing $item) {
        $delay = $this->getDelay();
        $blockedUntil = $item->getBlockedUntil();
        if ($delay && !$blockedUntil) {
            return false;
        }
        if ($item->getLastEmailSentAt()) {
            // An e-mail has been sent already (the first one)
            return false;
        }
        if ($blockedUntil) {
            $now = $this->dateTime->gmtDate();
            $limit = $this->dateTime->gmtDate(strtotime($blockedUntil));
            $nowString = $now->toString('yyyy-MM-dd HH:mm:ss');
            $limitString = $limit->toString('yyyy-MM-dd HH:mm:ss');
            $isReached = $now->isLater($limit);
            return $isReached;
        }
        return true;
    }
    /**
     * @param \Xtwo\SalesMailing\Model\Order\InfoMailing $item
     * @return bool
     * @throws Zend_Date_Exception
     */
    public function isSecondaryItemDelayReached(\Xtwo\SalesMailing\Model\Order\InfoMailing $item) {
        if (!$this->hasSecondaryMail($item->getOrder()->getStoreId())) {
            return false;
        }
        $delay = $this->getSecondaryDelay();
        $blockedUntil = $item->getBlockedUntil();
        if ($delay && !$blockedUntil) {
            return false;
        }
        if ($blockedUntil) {
            $now = $this->dateTime->gmtDate();
            $limit = $this->dateTime->gmtDate(($blockedUntil));
            $nowString = $now->toString('yyyy-MM-dd HH:mm:ss');
            $limitString = $limit->toString('yyyy-MM-dd HH:mm:ss');
            $isReached = $now->isLater($limit);
            return $isReached;
        }
        return true;
    }
    /**
     * @param \Xtwo\SalesMailing\Model\Order\InfoMailing $item
     * @return bool
     * @throws Zend_Date_Exception
     */
    public function isSecondaryConditionFulfilled(\Xtwo\SalesMailing\Model\Order\InfoMailing $item) {
        $isConditionFulfilled = true; // by default, if no condition is set
        $condition = $this->getData('condition_key_secondary');
        if ($condition) {
            switch ($condition) {
                case 'COMPLETE24HRS': {
                    $processingData = $item->getLogEntriesForStatus('processing');
                    $processingTime = empty($processingData) ? null : reset(array_keys($processingData));
                    $limit = new \Zend_Date();
                    $limit->subHour(24);
                    $limitTime = $limit->getTimestamp();
                    $isConditionFulfilled = $processingTime > $limitTime;
                    break;
                }
                case 'ORDER-CONFIRMATION-REQUIRED': {
                    $isConditionFulfilled = $this->hasOrderItemProductAttributeActivated($item, 'order_confirmation');
                    break;
                }
                default:
                    $isConditionFulfilled = false;
            }
        }
        return $isConditionFulfilled;
    }

    /**
     * Returns true in case at least one of the products of the given item has the given attribute and is not empty!
     * @param \Xtwo\SalesMailing\Model\Order\InfoMailing $item
     * @param $attributeKey
     * @return bool
     */
    protected function hasOrderItemProductAttributeActivated($item, $attributeKey) {
        /** @var \Magento\Sales\Model\Order\Item $item */
        foreach ($item->getOrder()->getAllItems() as $item) {
            $product = $item->getProduct();
            if ($product && $product->hasData($attributeKey) && $product->getData($attributeKey)) return true;
        }
        return false;
    }


    public function getId() {
        return $this->getData('id');
    }

    /** @return array|bool */
    public function getBccRecipients() {
		
        if (empty($this->mailBcc)) {
            $bcc = trim($this->getData('bcc'));
			
            if (!empty($bcc)) {
                $this->mailBcc = explode(',', $bcc);
            }
        }
        return empty($this->mailBcc) ? [] : $this->mailBcc;
    }

    /** @param string[] $recipients */
    public function setBccRecipients($recipients) {
        if (empty($recipients)) return;
        $this->mailBcc = $recipients;
    }

    /** @return array|bool */
    public function getCcRecipients() {
        if (empty($this->mailCc)) {
            $cc = trim($this->getData('cc') && '');
            if (!empty($cc)) {
                $this->mailCc = explode(',', $cc);
            }
        }
        return empty($this->mailCc) ? [] : $this->mailCc;
    }

    /** @param string[] $recipients */
    public function setCcRecipients($recipients) {
        if (!$recipients) return;
        $this->mailCc = $recipients;
    }

    /**
     * @return array|bool
     */
    public function getInternalRecipients() {
        $bcc = trim($this->getData('internal_recipients'));
        if (!empty($bcc)) {
            $mails = explode(',', $bcc);
            return $mails;
        }
        return false;
    }

    /**
     * @return array|bool
     */
    public function getInternalRecipientsSecondary() {
        $bcc = trim($this->getData('internal_recipients_secondary'));
        if (!empty($bcc)) {
            $mails = explode(',', $bcc);
            return $mails;
        }
        return false;
    }

    /**
     * Set a list of e-mail addresses
     * @param string[] $recipients
     */
    public function setInternalRecipients($recipients) {
        $list = implode(',', $recipients);
        $this->setData('internal_recipients', $list);
    }

    /** @return bool */
    public function isExternal()
    {
        $type = $this->getType();
        return $type == 'external' || in_array($type, self::$_EXTERNAL_TRIGGERED_TYPES);
    }

    /**
     * @param $storeId
     * @return bool
     */
    public function getTemplateId($storeId)
    {
        $key = $this->getSecondaryMailActive() ? 'template_id_secondary' : 'template_id';
        $value = $this->getStoreRelatedData($key, $storeId);
        return $value;
    }

    public function getTemplateIdSecondary($storeId) {
        $value = $this->getStoreRelatedData('template_id_secondary', $storeId);
        return $value;
    }

    /**  */
    public function setSecondaryMailInActive() {
        $this->setData('secondary_mail_active', false);
    }

    /**
     * @param $storeId
     * @return bool
     */
    public function getEmailIdentity($storeId)
    {
        $value = $this->getStoreRelatedData('email_identity', $storeId);
        return $value;
    }

    /**
     * @see Varien_Object::_construct()
     */
    protected function _construct()
    {
        //$this->_init('xtwo_salesmailing/configuration');
        //$this->_init('Xtwo\SalesMailing\Model\configuration');
    }
     /** @return int number of hours */
     public function getDelay() {
        return intval($this->getData('delay'));
    }

    /**
     * @param $storeId
     * @return bool
     */
    public function hasSecondaryMail($storeId) {
        $isActive = (bool) $this->getData('is_secondary_active');
        $templateIdSecondary = $this->getTemplateIdSecondary($storeId);
        return $isActive && $templateIdSecondary;
    }

    /**
     * @return int
     */
    public function getSecondaryDelay() {
        $val = intval($this->getData('delay_secondary'));
        if (!$val) {
            $val = '1h';
        }
        return intval($val);
    }

    /** @return mixed */
    public function isShippingMethodFilterActive() {
        return (bool)$this->getData('shipping_method');
    }

    /** @return mixed */
    public function isPaymentMethodFilterActive() {
        return (bool)$this->getPayment();
    }

    /** @return mixed */
    public function isProductAttributeFilterActive() {
        return (bool)$this->getProductAttribute();
    }

    /**
     * @param \Magento\Sales\Model\Order $order
     * @return bool
     */
    public function isShippingMatch($order) {
        $pattern = $this->getData('shipping_method');
        $orderShippingMethod = $order->getShippingMethod();
        $isMatch = preg_match('/'.$pattern.'/', $orderShippingMethod);
        return (bool) $isMatch;
    }

    /** @return bool */
    private function isShipmentTrackingCodeRequired() {
        $isRequired = (bool)$this->getData('trackingcode_required_secondary');
        return $isRequired;
    }

    /**
     * Returns true if, and only if, the order shipment of the given item matches this configuration, but a tracking
     * code is not available. The tracking code is a precondition of sending the shipment info mail. If that code is not
     * already set, it is required to block the item for a specific amount of time.
     *
     * @param \Xtwo\SalesMailing\Model\Order\InfoMailing $infoMailingItem
     * @return bool
     */
    public function isShippingMatchAndTrackingCodeRequiredButNotSet($infoMailingItem) {
        $precondition = $this->isShippingMethodFilterActive() && $this->isShippingMatch($infoMailingItem->getOrder());
        if ($precondition && $this->isShipmentTrackingCodeRequired()) {
            /** @var Mage_Sales_Model_Entity_Order_Shipment_Collection $shipments */
            //$shipments = $infoMailingItem->getOrder()->getShipmentsCollection();
            $shipments = $this->infoMailingItem->getOrder()->getShipmentsCollection();
            /** @var \Magento\Sales\Model\Order\Shipment $firstShipment */
            $firstShipment = $shipments->getFirstItem();
            if (!$firstShipment->getId()) {
                return true;
            }

            /** @var Mage_Sales_Model_Entity_Order_Shipment_Track_Collection $tracks */
            $tracks = $firstShipment->getTracksCollection();
            $track = $tracks->getFirstItem();
            if (!$track->getId()) {
                return true;
            }
        }
        return false;
    }

    /**
     * @param $storeId
     * @return bool
     */
    public function isActive($storeId) {
        return $this->getStoreRelatedData('is_active', $storeId);
    }

    /**
     * Returns store-related data for given key & store
     * @param $key
     * @param $storeId
     * @return bool
     */
    private function getStoreRelatedData($key, $storeId) {
        $data = $this->getData($key);
        if (is_array($data) && array_key_exists($storeId, $data)) {
            return $data[$storeId];
        }
        return false;
    }

    /**
     * @param \Magento\Framework\DataObject $file
     * @param \Magento\Sales\Model\Order $order
     * @return bool
     */
    public function matchesExternalTriggeredEvent($file, $order) {
        
        if (!$order || !$order->getId() || !$this->isActive($order->getStoreId())) {
            return false;
        }
		//echo $this->getType();
        //print_r($this->getType());
        //echo '<br/>';
        //print_r(self::$_EXTERNAL_TRIGGERED_TYPES);
       //echo $this->getType();
	   //exit;
        if ($this->getStatus() == '*' || $order->getStatus() == $this->getStatus()) {

            if (in_array($this->getType(), self::$_EXTERNAL_TRIGGERED_TYPES)&&
                (('external_'.$file->getData('type')) == $this->getType() ||
                 $this->getType() == self::TRIGGER_TYPE_EXT_DOCUMENTS)) {
                return true;
            }
        }
        return false;
    }


    /**
     * @param Mage_Sales_Model_Order $order
     * @return bool
     */
    public function matchesOrder($order) {
        if (!$order || !$order->getId() || !$this->isActive($order->getStoreId())) {
            return false;
        }
        
        if ($order && $order->getStatus() == $this->getStatus()) {
            
            if (in_array($this->getType(), self::$_EXTERNAL_TRIGGERED_TYPES)) {
                return false;

            } elseif (strpos($this->getType(), 'documents') !== false ||
                      strpos($this->getType(), 'shipment') !== false ||
                      strpos($this->getType(), 'invoice') !== false ||
                      strpos($this->getType(), 'orderconfirmation') !== false ||
                      strpos($this->getType(), 'creditmemo') !== false) {
                // Only (additionally) to ensure NOT matching on type containg that words
                return false;

            } elseif ($this->isShippingMethodFilterActive() && !$this->isShippingMatch($order)) {
                return false;

            } elseif ($this->isPaymentMethodFilterActive()) {
                $paymentMethod = $order->getPayment()->getMethod();
                if ($paymentMethod && $paymentMethod == $this->getPayment()) {
                    return true;
                }
            } elseif($this->isProductAttributeFilterActive()) {
                $attributeKey = $this->getProductAttribute();
                $attributeValue = $this->getProductAttributeValue();
                foreach ($order->getAllItems() as $item) {
                    $product = $item->getProduct();
                    if ($product && $product->hasData($attributeKey) && ($product->getData($attributeKey) == $attributeValue)) return true;
                }
                return false;
            } else {
                return true;
            }
        }
        return false;
    }

}