<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_SalesMailing
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */
namespace Xtwo\SalesMailing\Helper;

use \Magento\Framework\App\Helper\AbstractHelper;
use \Magento\Sales\Model\Order\Address\Renderer;

class Data extends AbstractHelper
{
    const CONFIGURATION_COUNT = 13;

    /**
     * @var \Psr\Log\LoggerInterface
     */
    protected $logger;

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;
    protected $fileResolver;
    protected $hasher;
    protected $salesMailingConfig;
    protected $_storeManagerInterface;
    protected $addressRenderer;

    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Psr\Log\LoggerInterface $logger,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Xtwo\SalesMailing\Model\Configuration $salesMailingConfig,
        \Xtwo\SalesMailing\Model\Service\FileResolver $fileResolver,
        \Xtwo\SalesMailing\Model\Service\Hasher $hasher,
        \Xtwo\SalesMailing\Logger\Logger $smLogger,
        \Magento\Store\Model\StoreManagerInterface $storeManagerInterface,
        Renderer $addressRenderer
    ) {
        $this->logger = $logger;
        $this->scopeConfig = $scopeConfig;
        $this->storeManager = $storeManager;
        $this->salesMailingConfig=$salesMailingConfig;
        $this->fileResolver = $fileResolver;
        $this->hasher = $hasher;
        $this->smLogger=$smLogger;
        $this->_storeManagerInterface = $storeManagerInterface;
        parent::__construct(
            $context
        );

        $this->addressRenderer = $addressRenderer;
    }
    /**
     * Function to log message in log file
     * @param $level
     * @param $msg
     */
    public function log($level, $msg) {
        $this->smLogger->info($msg,[]);
    }
     /**
     * Returns an array configurations.
     * @param $type
     * @return array
     */
    public function getActiveConfigurationsOfSpecificType($type) {
        $result = array();
        $configurations = $this->getActiveConfigurations();
        /** @var $configuration \Xtwo\SalesMailing\Model\Configuration */
        foreach ($configurations as $configuration) {
            if ($configuration['type'] == $type) {
                $result[] = $configuration;
            }
        }
        return $result;
    }

    public function getFormattedShippingAddress($order) {
        return $order->getIsVirtual()
            ? null
            : $this->addressRenderer->format($order->getShippingAddress(), 'html');
    }

    public function getFormattedBillingAddress($order) {
        return $this->addressRenderer->format($order->getBillingAddress(), 'html');
    }

    /**
     * @return bool
     */
    public function isProcessingBridgeActive() {
        $isActive =(bool)$this->scopeConfig->getValue('sales_email/infomailing/bridge_processing',
         \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        return $isActive;
    }
    public function getActiveCustomConfigurations() {
        $configs = $this->getActiveConfigurations('custom_');
        return $configs;
    }

    /**
     * Returns the configuration items as data array
     * @param array $config
     * @return array
     */
    public function getActiveConfiguration($config) {
        $configInstance = $this->salesMailingConfig;
        $configInstance->setData($config);
        return $configInstance;
    }

    /**
     * Returns the configurations items as data array
     * @param string $pathPostfix
     * @return array
     */
    public function getActiveConfigurations($pathPostfix='') {
        $configurations = array();
        $activeStores = $this->getActiveStores();
        // $configInstance = $this->salesMailingConfig;
        for ($i = 0; $i <= self::CONFIGURATION_COUNT; $i++) {
            $config = array();
            $config['id'] = $i;

            $path = 'sales_email/infomailing_'.$pathPostfix.$i;
            // Fetch is_active store-related
            $storeRelatedValues = $this->getStoreConfigurations($path.'/active', $activeStores);
            $config['is_active'] = $storeRelatedValues;

            $isComplete = true;
            
            $data = trim((string) $this->scopeConfig->getValue($path.'/data', \Magento\Store\Model\ScopeInterface::SCOPE_STORE));

            if (!in_array('1', $config['is_active']) || empty($data)) {
                // Seems to be an empty configuration
                continue;
            }

            $lines = explode(PHP_EOL, $data);
            foreach ($lines as $line) {
                $line = trim($line);
                if (empty($line)) continue;
                $lineData = explode('=', $line);
                if (count($lineData)==2) {
                    $config[$lineData[0]] = $lineData[1];
                } else {
                    $this->log(\Zend_Log::ERR, sprintf('configuration line %s invalid=%s', $path, $line));
                    $isComplete = false;
                }
            }
            // E-mail Template
            $storeRelatedValues = $this->getStoreConfigurations($path.'/item_template', $activeStores);
            if (!empty($storeRelatedValues)) {
                $config['template_id'] = $storeRelatedValues;
            } else {
                $this->log(\Zend_Log::ERR, sprintf('configuration template empty!'));
                $isComplete = false;
            }

            // E-mail Sender
            $storeRelatedValues = $this->getStoreConfigurations($path.'/item_email_identity', $activeStores);
            if (!empty($storeRelatedValues)) {
                $config['email_identity'] = $storeRelatedValues;
            } else {
                $this->log(\Zend_Log::ERR, sprintf('configuration email sender invalid'));
                $isComplete = false;
            }

            // Secondary E-mail Activated
            $storeRelatedValues = $this->getStoreConfigurations($path.'/secondary_active', $activeStores);
            $config['is_secondary_active'] = $storeRelatedValues;

            // Secondary E-mail Template
            $storeRelatedValues = $this->getStoreConfigurations($path.'/secondary_item_template', $activeStores);
            if (!empty($storeRelatedValues)) {
                $config['template_id_secondary'] = $storeRelatedValues;
            }


            if (!array_key_exists('status', $config) || !array_key_exists('type', $config) ||
                ($config['type'] == 'internal' && !array_key_exists('internal_recipients', $config))) {
                $this->log(\Zend_Log::ERR, sprintf('configuration invalid, status and/or type missing: %s', $data));
                $isComplete = false;
            }
            if ($isComplete) {
                // $configInstance->setData($config);
                $configurations[] = $config;
            }
        }
        return $configurations;
    }
    /**
     * function to get active stores
     * @return array
     */
    protected function getActiveStores() {
        $stores = array();
        /** @var \Magento\Store\Model\Store $store */
        $storesOB=$this->_storeManagerInterface->getStores($withDefault = false);
        foreach ($storesOB as $store) {
            
            if ($store->getIsActive()) {
                $stores[] = $store;
            }
        }

        return $stores;
    }
    /**
     * @param $path
     * @param $stores
     * @return array
     */
    private function getStoreConfigurations($path, $stores) {
        $configs = array();
        /** @var \Magento\Store\Model\ScopeInterface $store */
        foreach ($stores as $store) {
            $value = $this->scopeConfig->getValue($path, 
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $store);
            $configs[$store->getId()] = $value;
        }
        return $configs;
    }
    /**
     * @param \Magento\Framework\App\Request\Http $request
     * @return \Magento\Framework\DataObject
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getRawPDFData($request) {
        $filename = $request->getParam('file', null);
        $hash = $request->getParam('hash', null);
        
        if ($filename !== null && $hash !== null) {
            /** @var Xtwo_SalesMailing_Model_Service_FileResolver $fileResolver */

            $fileObject = $this->fileResolver->resolve($filename.'.pdf');
           
            if ($fileObject && $fileObject->getPath()) {
                $path = $fileObject->getPath();
                
                //if hash is valid, return a file
                $isFileExisting = file_exists($path);
                
                $isHashValid = $this->hasher->isHashValid($hash, $filename);
                if ($isFileExisting ) {
                    $content = file_get_contents($path);
                    $fileObject->setData('raw_data', $content);
                    return $fileObject;
                } else {
                    //Js_Log::log(sprintf('Could not get document. File=%s, HashOk=%s, FileExists=%s',
                     //   $filename, (int)$isHashValid, (int)$isFileExisting), $this, \Zend_Log::ERR);
                        //throw new \Magento\Framework\Exception\LocalizedException('Invalid call getting document!');
                }
            } else {
                //Js_Log::log(sprintf('Could not get document as file not existing. File=%s', $filename),
                 //   $this, \Zend_Log::ERR);
                    //throw new \Magento\Framework\Exception\LocalizedException('File not found.');
            }
        }
       // throw new \Magento\Framework\Exception\LocalizedException('Invalid call.');
    }
}