<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_SalesMailing
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\SalesMailing\Controller\Adminhtml\Download;

use Magento\Backend\App\Action;
use Xtwo\SalesMailing\Helper\Data as dataHelper;

class Index extends \Magento\Backend\App\Action
{
    /**
     * @var \Magento\Backend\Model\Session
     */
    protected $backendSession;
    /**
     * @var \Magento\Backend\Model\Auth\Session
     */
    protected $backendAuthSession;
    /**
     * @var \Magento\Framework\Filesystem\Io\FileFactory
     */
    protected $ioFileFactory;
    protected $ioFile;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Backend\Model\Session $backendSession,
        \Magento\Backend\Model\Auth\Session $backendAuthSession,
        \Magento\Framework\Filesystem\Io\FileFactory $ioFileFactory,
        \Magento\Framework\Filesystem\Io\File $ioFile,
        dataHelper $helper
    ){
        $this->helper = $helper;
        parent::__construct($context);
    }
    public function execute()
    {
        try {
            $fileObject = $this->helper->getRawPDFData($this->getRequest());
            $this->_prepareDownloadResponse($fileObject->getFileName(), $fileObject->getData('raw_data'));

        } catch ( \Magento\Framework\Exception\LocalizedException $e) {
            $this->messageManager->addError($e->getMessage());
            //throw new \Magento\Framework\Exception\LocalizedException('File not found');
            //$this->backendSession->addError($e->getMessage());
           // $this->_redirectReferer();
        }
    }
    /**
     * Declare headers and content file in response for file download
     *
     * @param string $fileName
     * @param string|array $content set to null to avoid starting output, $contentLength should be set explicitly in
     *                              that case
     * @param string $contentType
     * @param int $contentLength    explicit content length, if strlen($content) isn't applicable
     * @return Mage_Adminhtml_Controller_Action
     */
    protected function _prepareDownloadResponse($fileName, $content, $contentType = 'application/pdf',
    $contentLength = null
    ) {
        $session = $this->backendAuthSession;
        //if ($session->isFirstPageAfterLogin()) {
        //    $this->_redirect($session->getUser()->getStartupPageUrl());
        //    return $this;
        //}

        $isFile = false;
        $file   = null;
        if (is_array($content)) {
            if (!isset($content['type']) || !isset($content['value'])) {
                return $this;
            }
            if ($content['type'] == 'filename') {
                $isFile         = true;
                $file           = $content['value'];
                $contentLength  = filesize($file);
            }
        }

        $this->getResponse()
            ->setHttpResponseCode(200)
            ->setHeader('Pragma', 'public', true)
            ->setHeader('Cache-Control', 'must-revalidate, post-check=0, pre-check=0', true)
            ->setHeader('Content-type', $contentType, true)
            ->setHeader('Content-Length', is_null($contentLength) ? strlen($content) : $contentLength)
            ->setHeader('Content-Disposition', 'inline; filename="'.$fileName.'"')
            ->setHeader('Last-Modified', date('r'));

        if (!is_null($content)) {
            if ($isFile) {
                $this->getResponse()->clearBody();
                $this->getResponse()->sendHeaders();

                $ioAdapter = new  $this->ioFile();
                if (!$ioAdapter->fileExists($file)) {
                    //Mage::throwException(Mage::helper('core')->__('File not found'));
                    throw new \Magento\Framework\Exception\LocalizedException('File not found');
                }
                $ioAdapter->open(array('path' => $ioAdapter->dirname($file)));
                $ioAdapter->streamOpen($file, 'r');
                while ($buffer = $ioAdapter->streamRead()) {
                    print $buffer;
                }
                $ioAdapter->streamClose();
                if (!empty($content['rm'])) {
                    $ioAdapter->rm($file);
                }

                exit(0);
            } else {
                $this->getResponse()->setBody($content);
            }
        }
        return $this;
    }

    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Xtwo_SalesMailing::download');
    }
}