<?php

namespace Xtwo\RestrictShipping\Plugin;
use Magento\Checkout\Model\Session;
class ApplyShipping
{
    /**
   * @var \Magento\Framework\App\Config\ScopeConfigInterface
   */
  
   protected $scopeConfig;

    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        Session $session
        
    )
    {
        $this->scopeConfig = $scopeConfig;
        $this->_session = $session;

    }

    public function aroundCollectCarrierRates(
        \Magento\Shipping\Model\Shipping $subject,
        \Closure $proceed,
        $carrierCode,
        $request
    )
    {
        $restrictEnabled = $this->scopeConfig->getValue('restrict/shippingmethod/active',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        
        $restrictedSkusList = $this->scopeConfig->getValue('restrict/shippingmethod/restrict_skus',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        
        $items = $this->_session->getQuote()->getAllVisibleItems();
        
        $restrictedSkusArray =[];
        if(!empty($restrictedSkusList)){
            $restrictedSkusArray = explode(',', $restrictedSkusList);
        }
            // Enter Shipping Code here instead of 'freeshipping'
        if ($carrierCode == 'freeshipping') {
            $skuFound = false;
            if(!empty($restrictedSkusArray) && $restrictEnabled){
               
                foreach($items as $iK=>$item){
                    if(in_array($item['sku'],$restrictedSkusArray)){
                        $skuFound =true;
                    }
                }
            }
            if($skuFound){
                // To disable the shipping method return false
                return false;
            }
        } 
           // To enable the shipping method
            return $proceed($carrierCode, $request);
    }
}