<?php
namespace Xtwo\ProductListingApi\Model;

use Xtwo\ProductListingApi\Api\CategoryProductsInterface;
use Magento\Catalog\Model\CategoryFactory;
use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory as ProductCollectionFactory;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\Api\SearchCriteria\CollectionProcessorInterface;
class CategoryProducts implements CategoryProductsInterface
{
    private $categoryFactory;
    protected $productCollectionFactory;
    protected $storeManager;
    protected $stockRegistry;
    private $collectionProcessor;
    /**
      * @var null|Quantity
      */
     protected $quantityModel = null;
    
     public function __construct(
         ProductCollectionFactory $productCollectionFactory,
         CategoryFactory $categoryFactory,
         StoreManagerInterface $storeManager,
         \Magento\CatalogInventory\Api\StockRegistryInterface $stockRegistry,
         ProductRepositoryInterface $productRepository,
         \Magento\Catalog\Api\Data\ProductSearchResultsInterfaceFactory $searchResultsFactory,
         CollectionProcessorInterface $collectionProcessor = null
     ) {
         $this->productCollectionFactory = $productCollectionFactory;
         $this->categoryFactory = $categoryFactory;
         $this->storeManager = $storeManager;
         $this->stockRegistry = $stockRegistry;
         $this->productRepository = $productRepository;
         $this->searchResultsFactory = $searchResultsFactory;    
         $this->collectionProcessor = $collectionProcessor ?: $this->getCollectionProcessor();
     }
    public function getCategoryProducts($categoryId,\Magento\Framework\Api\SearchCriteriaInterface $searchCriteria){
        $category = $this->categoryFactory->create()->load($categoryId);
        $itemsArray = [];
        if(!empty($category)){
            $collection = $this->productCollectionFactory->create();
            //$this->extensionAttributesJoinProcessor->process($collection);
            $collection->addCategoriesFilter(['eq' => $categoryId]);
            $collection->addAttributeToSelect('*');
            $collection->joinAttribute('status', 'catalog_product/status', 'entity_id', null, 'inner');
            $collection->joinAttribute('visibility', 'catalog_product/visibility', 'entity_id', null, 'inner');

            $this->collectionProcessor->process($searchCriteria, $collection);

            $collection->load();
            $items = $collection->getItems();
            foreach ($collection->getItems() as $product) {
                $itemsArray[] = [
                    'id' =>$product->getId(),
                    'name' => $product->getName(),
                    'sku' => $product->getSku(),
                    'price' => $product->getPrice()
                ];
            }
            
            $searchResult = $this->searchResultsFactory->create();
            $searchResult->setSearchCriteria($searchCriteria);
            $searchResult->setItems($itemsArray);
            $searchResult->setTotalCount($collection->getSize());
            return $searchResult;
        }else {
            return [];
        }

    }
    /**
     * Retrieve collection processor
     *
     * @deprecated 102.0.0
     * @return CollectionProcessorInterface
     */
    private function getCollectionProcessor()
    {
        if (!$this->collectionProcessor) {
            $this->collectionProcessor = \Magento\Framework\App\ObjectManager::getInstance()->get(
                \Magento\Catalog\Model\Api\SearchCriteria\ProductCollectionProcessor::class
            );
        }
        return $this->collectionProcessor;
    }
}