<?php
namespace Xtwo\ProductListingApi\Model;

use Xtwo\ProductListingApi\Api\CategoryFilterInterface;
use Magento\Catalog\Model\Layer\Category\FilterableAttributeList;
use Magento\Catalog\Model\Layer\FilterListFactory;
use Magento\Catalog\Model\Layer\Resolver as layerResolver;
use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory as ProductCollectionFactory;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Catalog\Model\Layer\Filter\Item\DataBuilder as ItemDataBuilder;
use Magento\Framework\App\CacheInterface;
class CategoryFilter implements CategoryFilterInterface
{
    protected $storeManager;
    protected $layerResolver;
    protected $request;
    protected $amastyLayerFilterList;
     /**
     * @var \Magento\Catalog\Model\Layer\FilterList
     */
    protected $filterList;
    protected $cache;
    public function __construct(
        FilterableAttributeList $filterableAttributes,
        layerResolver $layerResolver,
        FilterListFactory $filterListFactory,
        ProductCollectionFactory $productCollectionFactory,
        StoreManagerInterface $storeManager,
        \Magento\Catalog\Model\Layer\Filter\ItemFactory $filterItemFactory,
        \Magento\Catalog\Model\ResourceModel\Layer\Filter\AttributeFactory $filterAttributeFactory,
        \Magento\Framework\Stdlib\StringUtils $string,
        \Magento\Framework\App\RequestInterface $request,
        //\Magento\Catalog\Model\Layer\FilterList $filterList
        \Magento\Framework\Pricing\PriceCurrencyInterface $priceCurrency,
        \Amasty\Shopby\Model\Layer\FilterList  $amastyLayerFilterList,
        ItemDataBuilder $itemDataBuilder,
        CacheInterface $cache
    ) {
        $this->filterableAttributes = $filterableAttributes;
        $this->layerResolver = $layerResolver;
        $this->filterListFactory = $filterListFactory;
        $this->productCollectionFactory = $productCollectionFactory;
        $this->storeManager = $storeManager;
        $this->_filterItemFactory = $filterItemFactory;
        $this->_resource = $filterAttributeFactory->create();
        $this->string = $string;
        $this->request = $request;
        //$this->filterList = $filterList;
        $this->priceCurrency = $priceCurrency;
        $this->amastyLayerFilterList = $amastyLayerFilterList;
        $this->cache = $cache;
        
        
    }
    public function getCategoryFilters($categoryId){
        // Getting selected filters from URI
		$requestedfilters = $this->request->getParams();
        $cacheRequestId = $categoryId;
        
        //if(isset($requestedfilters['searchkey']) && !empty($requestedfilters['searchkey'])){
        //    $cacheRequestId = 'search-'.strtolower(preg_replace('/\s+/', '-', $requestedfilters['searchkey']));
        //}
        //unset($filters['category_id']); // Remove category ID if present

        // Generate a unique cache key based on the selected filters
        $cacheKey = 'layered_navigation_' . $categoryId . '_' . md5(json_encode($requestedfilters));


        //$cacheKey = 'layered_navigation_' . $categoryId;
        
       $cacheData = $this->cache->load($cacheKey);
        if ($cacheData) {
           // return json_decode($cacheData, true);
        }

        $storeId = $this->storeManager->getStore()->getId();
       
        $this->storeManager->setCurrentStore($storeId);
       
        
        if(isset($requestedfilters['currency']) && !empty($requestedfilters['currency'])){
            $this->storeManager->getStore()->setCurrentCurrencyCode($requestedfilters['currency']);
        }
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $filterableAttributes = $objectManager->getInstance()->get(\Magento\Catalog\Model\Layer\Category\FilterableAttributeList::class);
        $layerResolver = $objectManager->getInstance()->get(\Magento\Catalog\Model\Layer\Resolver::class);
        $filterList = $objectManager->getInstance()->create(
            \Magento\Catalog\Model\Layer\FilterList::class,
                [
                    'filterableAttributes' => $filterableAttributes
                ]
        );
        
        $layer = $layerResolver->get();
        //$cat = $layer->getCurrentCategory();
        //if(!isset($requestedfilters['searchkey']) && empty($requestedfilters['searchkey'])){
            $layer->setCurrentCategory($categoryId);
        //}
        
        $productCollection = $layer->getProductCollection();
        $productCollection->joinAttribute('status', 'catalog_product/status', 'entity_id', null, 'inner');
        $productCollection->joinAttribute('visibility', 'catalog_product/visibility', 'entity_id', null, 'inner');
        
        if(!empty($requestedfilters['manufacturer'])){
            if (strpos($requestedfilters['manufacturer'], ',') !== false) {
				// Split the values by comma into an array
				$manufacturerFilters = explode(',', $requestedfilters['manufacturer']);
			}else {
                $manufacturerFilters = $requestedfilters['manufacturer'];
            }
            $productCollection->addAttributeToFilter('manufacturer', array('in' => array($manufacturerFilters)));
        }
        if(!empty($requestedfilters['series'])){
            if (strpos($requestedfilters['series'], ',') !== false) {
				// Split the values by comma into an array
				$seriesFilters = explode(',', $requestedfilters['series']);
			}else {
                $seriesFilters = $requestedfilters['series'];
            }
            $productCollection->addAttributeToFilter('series', array('in' => array($seriesFilters)));
        }
        if(!empty($requestedfilters['color'])){
            if (strpos($requestedfilters['color'], ',') !== false) {
				// Split the values by comma into an array
				$colorFilters = explode(',', $requestedfilters['color']);
			}else {
                $colorFilters = $requestedfilters['color'];
            }
            $productCollection->addAttributeToFilter('color', array('in' => array($colorFilters)));
        }
        if(!empty($requestedfilters['delivery_time'])){
            if (strpos($requestedfilters['delivery_time'], ',') !== false) {
				// Split the values by comma into an array
				$deliveryTimeFilters = explode(',', $requestedfilters['delivery_time']);
			}else {
                $deliveryTimeFilters = $requestedfilters['delivery_time'];
            }
            //echo $deliveryTimeFilters;
            $productCollection->addAttributeToFilter('delivery_time', array('in' => array($deliveryTimeFilters)));
        }
        if(!empty($requestedfilters['connection_size'])){
            if (strpos($requestedfilters['connection_size'], ',') !== false) {
				// Split the values by comma into an array
				$connectionSizeFilters = explode(',', $requestedfilters['connection_size']);
			}else {
                $connectionSizeFilters = $requestedfilters['connection_size'];
            }
            $productCollection->addAttributeToFilter('connection_size', array('in' => array($connectionSizeFilters)));
        }
        if(!empty($requestedfilters['tiles_color_group'])){
            if (strpos($requestedfilters['tiles_color_group'], ',') !== false) {
				// Split the values by comma into an array
				$type2Filters = explode(',', $requestedfilters['tiles_color_group']);
			}else {
                $type2Filters = $requestedfilters['tiles_color_group'];
            }
            $productCollection->addAttributeToFilter('tiles_color_group', array('in' => array($type2Filters)));
        }
        if(!empty($requestedfilters['price'])){
              $priceArr = $requestedfilters['price'];
            if(!empty($priceArr)){
                $priceFilter = explode('-',$priceArr);
            }
            list($from, $to) = $priceFilter;
            $layer->getProductCollection()->addAttributeToFilter('price', ['from'=>$from, 'to'=>$to]);
        }
        //if(isset($requestedfilters['searchkey']) && !empty($requestedfilters['searchkey'])){
       //     $productCollection->addFieldToFilter('name',['like' => '%'.$requestedfilters['searchkey'].'%']
                
         //   );
            
       // }
       
        //$layer->apply();
        //$filters = $this->amastyLayerFilterList->getAllFilters($layer);
        $filters = $filterList->getFilters($layer);
        $filterArray =[];
        $i = 0;
        $maxPrice = $layer->getProductCollection()->getMaxPrice();
        $minPrice = $layer->getProductCollection()->getMinPrice();
        $filterArray[]['price']=[
            'min' => $minPrice,
            'max' => $maxPrice
        ];
        $filterArray[]['showSort'] = [
            'position' => 'Topseller',
            'name' => 'Product Name',
            'price' => 'Price',
            'delivery_time' => 'Delivery Time'
        ];
         
        foreach($filters as $filter){
            $availablefilter = (string)$filter->getName(); //Gives Display Name of the filter such as Category,Price etc.
            $items = $filter->getItems(); //Gives all available filter options in that particular filter
            
            $filterValues = array();
            $j = 0;
           
            
			$attr_code = (string)$filter->getRequestVar();
             
             $attr_label = (string)$filter->getName();
             $fprice =0;
             $tprice = 0;
            if($attr_code !='price'){
            foreach($items as $item){
                $filterValues[$j]['value']   = $item->getValue();
                if($attr_code =='cat') {
                    $baseUrl = $this->storeManager->getStore()->getBaseUrl(); // Get the base URL
                    $categoryDeObj = $objectManager->create('Magento\Catalog\Model\Category')->load($item->getValue());
                    $categoryDeObj->getUrl();
                    $catUrl = str_replace(".html", "",str_replace($baseUrl, "/category/", $categoryDeObj->getUrl()));
                    $filterValues[$j]['value']   = $catUrl;
                }else{
                    $filterValues[$j]['value']   = $item->getValue();
                }
                $filterValues[$j]['display'] = strip_tags($item->getLabel());
                
                $filterValues[$j]['count']   = $item->getCount(); //Gives no. of products in each filter options
           
                $j++;
            }
        }
            //if(!empty($filterValues) && count($filterValues)>1){
                $filterArray[] =[
                 "attr_code"=>$attr_code,
                 "attr_label"=>$attr_label,
                 "values"=>$filterValues
                ];  
            //}
            $i++;
        }
          $this->cache->save(json_encode($filterArray), $cacheKey, ['LAYERS'], 600);
        return  $filterArray;

    }
}