<?php
namespace Xtwo\ProductListingApi\Model;

use Magento\Catalog\Api\CategoryRepositoryInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory as ProductCollectionFactory;
use Magento\Catalog\Model\CategoryFactory;
use Magento\Catalog\Model\Product\Visibility;
use Xtwo\AttributeOption\Helper\Image as ImageHelper;
use Magento\Store\Model\StoreManagerInterface;
use Magento\CatalogInventory\Api\StockRegistryInterface;
use Magento\Wishlist\Model\WishlistFactory;
use Xtwo\CustomApis\Helper\Data as CustomApisHelper;
use Magento\Review\Model\ReviewFactory;
use Magento\Review\Model\ResourceModel\Review\CollectionFactory as ReviewCollectionFactory;
use Magento\Review\Model\ResourceModel\Rating\Option\Vote\Collection as RatingOptionCollection;
use Magento\Framework\App\RequestInterface;
use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory as CategoryCollectionFactory;
use Magento\Framework\App\CacheInterface;
use Magento\Search\Model\QueryFactory;
use Magento\Catalog\Model\Layer\Resolver;
class CatalogSearchLayer implements \Xtwo\ProductListingApi\Api\CatalogSearchLayerInterface
{
    protected $categoryRepository;
    protected $productCollectionFactory;
    private $categoryFactory;
    protected $visibility;
    protected $imageHelper;
    protected $storeManager;
    protected $stockRegistry;
    protected $mediaBaseUrl;
    protected $wishlistFactory;
    protected $customApisHelper;
    protected $reviewFactory;
    protected $reviewCollectionFactory;
    protected $ratingOption;
    protected $request;
    protected $categoryCollectionFactory;

    public function __construct(
        CategoryRepositoryInterface $categoryRepository,
        ProductCollectionFactory $productCollectionFactory,
        CategoryFactory $categoryFactory,
        Visibility $visibility,
        ImageHelper $imageHelper,
        StoreManagerInterface $storeManager,
        StockRegistryInterface $stockRegistry,
        WishlistFactory $wishlistFactory,
        CustomApisHelper $customApisHelper,
        ReviewFactory $reviewFactory,
        ReviewCollectionFactory $reviewCollectionFactory,
        RatingOptionCollection $ratingOption,
        RequestInterface $request,
        CategoryCollectionFactory $categoryCollectionFactory,
        CacheInterface $cache
    ) {
        $this->categoryRepository = $categoryRepository;
        $this->productCollectionFactory = $productCollectionFactory;
        $this->categoryFactory = $categoryFactory;
        $this->visibility = $visibility;
        $this->imageHelper = $imageHelper;
        $this->storeManager = $storeManager;
        $this->stockRegistry = $stockRegistry;
        $this->mediaBaseUrl = $this->storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA);
        $this->wishlistFactory = $wishlistFactory;
        $this->customApisHelper = $customApisHelper;
        $this->reviewFactory = $reviewFactory;
        $this->reviewCollectionFactory = $reviewCollectionFactory;
        $this->ratingOption = $ratingOption;
        $this->request = $request;
        $this->categoryCollectionFactory = $categoryCollectionFactory;
        $this->cache = $cache;

    }

    public function getLayerSearchResult($searchKey,$currency)
    {
        $requestedfilters = $this->request->getParams();
        if (strlen($searchKey) < 3) {
            return [
                'error' => true,
                'message' => 'Search key must have at least 3 characters.',
            ];
        }

        $cacheKey = 'catalog_search_layered_navigation_' .'_' . md5(json_encode($searchKey)).'_'. md5(json_encode($requestedfilters));
        $cacheData = $this->cache->load($cacheKey);
        if ($cacheData) {
            return json_decode($cacheData, true);
        }
       $category = $this->categoryCollectionFactory->create();
        $category->addAttributeToSelect('*');
        $category->addAttributeToFilter('is_active', ['eq' => 1]);
        $category->addAttributeToFilter('name', ['like' => '%' . $searchKey . '%']);

        $storeId = $this->storeManager->getStore()->getId();
       
        $this->storeManager->setCurrentStore($storeId);
        
        
        if(isset($requestedfilters['currency']) && !empty($requestedfilters['currency'])){
            $this->storeManager->getStore()->setCurrentCurrencyCode($requestedfilters['currency']);
        }
		/*
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $filterableAttributes = $objectManager->getInstance()->get(\Magento\Catalog\Model\Layer\Category\FilterableAttributeList::class);
        $layerResolver = $objectManager->getInstance()->get(\Magento\Catalog\Model\Layer\Resolver::class);
        $filterList = $objectManager->getInstance()->create(
            \Magento\Catalog\Model\Layer\FilterList::class,
                [
                    'filterableAttributes' => $filterableAttributes
                ]
        );
        
        $layer = $layerResolver->get();
        //$cat = $layer->getCurrentCategory();
        //if(!isset($requestedfilters['searchkey']) && empty($requestedfilters['searchkey'])){
            //$layer->setCurrentCategory($categoryId);
        //}
        
        $productCollection = $layer->getProductCollection();
        $productCollection->joinAttribute('status', 'catalog_product/status', 'entity_id', null, 'inner');
        $productCollection->joinAttribute('visibility', 'catalog_product/visibility', 'entity_id', null, 'inner');
        
        if(!empty($requestedfilters['manufacturer'])){
            if (strpos($requestedfilters['manufacturer'], ',') !== false) {
				// Split the values by comma into an array
				$manufacturerFilters = explode(',', $requestedfilters['manufacturer']);
			}else {
                $manufacturerFilters = $requestedfilters['manufacturer'];
            }
            $productCollection->addAttributeToFilter('manufacturer', array('in' => array($manufacturerFilters)));
        }
        if(!empty($requestedfilters['series'])){
            if (strpos($requestedfilters['series'], ',') !== false) {
				// Split the values by comma into an array
				$seriesFilters = explode(',', $requestedfilters['series']);
			}else {
                $seriesFilters = $requestedfilters['series'];
            }
            $productCollection->addAttributeToFilter('series', array('in' => array($seriesFilters)));
        }
        if(!empty($requestedfilters['color'])){
            if (strpos($requestedfilters['color'], ',') !== false) {
				// Split the values by comma into an array
				$colorFilters = explode(',', $requestedfilters['color']);
			}else {
                $colorFilters = $requestedfilters['color'];
            }
            $productCollection->addAttributeToFilter('color', array('in' => array($colorFilters)));
        }
        if(!empty($requestedfilters['delivery_time'])){
            if (strpos($requestedfilters['delivery_time'], ',') !== false) {
				// Split the values by comma into an array
				$deliveryTimeFilters = explode(',', $requestedfilters['delivery_time']);
			}else {
                $deliveryTimeFilters = $requestedfilters['delivery_time'];
            }
            //echo $deliveryTimeFilters;
            $productCollection->addAttributeToFilter('delivery_time', array('in' => array($deliveryTimeFilters)));
        }
        if(!empty($requestedfilters['connection_size'])){
            if (strpos($requestedfilters['connection_size'], ',') !== false) {
				// Split the values by comma into an array
				$connectionSizeFilters = explode(',', $requestedfilters['connection_size']);
			}else {
                $connectionSizeFilters = $requestedfilters['connection_size'];
            }
            $productCollection->addAttributeToFilter('connection_size', array('in' => array($connectionSizeFilters)));
        }
        if(!empty($requestedfilters['type2'])){
            if (strpos($requestedfilters['type2'], ',') !== false) {
				// Split the values by comma into an array
				$type2Filters = explode(',', $requestedfilters['type2']);
			}else {
                $type2Filters = $requestedfilters['type2'];
            }
            $productCollection->addAttributeToFilter('type2', array('in' => array($type2Filters)));
        }
        if(!empty($requestedfilters['price'])){
              $priceArr = $requestedfilters['price'];
            if(!empty($priceArr)){
                $priceFilter = explode('-',$priceArr);
            }
            list($from, $to) = $priceFilter;
            $layer->getProductCollection()->addAttributeToFilter('price', ['from'=>$from, 'to'=>$to]);
        }
        if(isset($requestedfilters['searchkey']) && !empty($requestedfilters['searchkey'])){
           $productCollection->addFieldToFilter('name',['like' => '%'.$requestedfilters['searchkey'].'%']
                
            );
            
       }
       
        //$layer->apply();
        //$filters = $this->amastyLayerFilterList->getAllFilters($layer);
        $filters = $filterList->getFilters($layer);
        $filterArray =[];
        $i = 0;
        $maxPrice = $layer->getProductCollection()->getMaxPrice();
        $minPrice = $layer->getProductCollection()->getMinPrice();
        $filterArray[]['price']=[
            'min' => $minPrice,
            'max' => $maxPrice
        ];
        $filterArray[]['showSort'] = [
            'position' => 'Topseller',
            'name' => 'Product Name',
            'price' => 'Price',
            'delivery_time' => 'Delivery Time'
        ];
         
        foreach($filters as $filter){
            $availablefilter = (string)$filter->getName(); //Gives Display Name of the filter such as Category,Price etc.
            $items = $filter->getItems(); //Gives all available filter options in that particular filter
            
            $filterValues = array();
            $j = 0;
           
            
            $attr_code = (string)$filter->getRequestVar();
             
             $attr_label = (string)$filter->getName();
             $fprice =0;
             $tprice = 0;
            if($attr_code !='price'){
            foreach($items as $item){
                $filterValues[$j]['value']   = $item->getValue();
                if($attr_code =='cat') {
                    $baseUrl = $this->storeManager->getStore()->getBaseUrl(); // Get the base URL
                    $categoryDeObj = $objectManager->create('Magento\Catalog\Model\Category')->load($item->getValue());
                    $categoryDeObj->getUrl();
                    $catUrl = str_replace(".html", "",str_replace($baseUrl, "/category/", $categoryDeObj->getUrl()));
                    $filterValues[$j]['value']   = $catUrl;
                }else{
                    $filterValues[$j]['value']   = $item->getValue();
                }
                $filterValues[$j]['display'] = strip_tags($item->getLabel());
                
                $filterValues[$j]['count']   = $item->getCount(); //Gives no. of products in each filter options
           
                $j++;
            }
        }
            if(!empty($filterValues) && count($filterValues)>1){
                $filterArray[] =[
                 "attr_code"=>$attr_code,
                 "attr_label"=>$attr_label,
                 "values"=>$filterValues
                ];  
            }
            $i++;
        }
        $this->cache->save(json_encode($filterArray), $cacheKey, ['LAYERS'], 600);
        return  $filterArray;
        exit;*/
        //if (1) {
            $catLevel = $category->getFirstItem()->getLevel();
            if($catLevel == 2){
                $catId = $category->getFirstItem()->getId();
            } else {
                $catId = $category->getFirstItem()->getParentId();
            }
            $pageSize = $this->request->getParam('pageSize');
            $currentPage = $this->request->getParam('currentPage');
            if($catId == 0){
                $productCollectionAttr = $this->productCollectionFactory->create();
                $productCollectionAttr->addAttributeToFilter('sku', ['like' => '%' . $searchKey . '%'])
                    ->addAttributeToFilter('visibility', ['in' => [Visibility::VISIBILITY_BOTH, Visibility::VISIBILITY_IN_CATALOG]])
                    ->addAttributeToFilter('status', \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED)
                    ->addAttributeToFilter(
                        [
                            ['attribute' => 'color', 'notnull' => true],
                            ['attribute' => 'series', 'notnull' => true],
                            ['attribute' => 'connection_size', 'notnull' => true],
                            ['attribute' => 'type2', 'notnull' => true],
                        ],
                        '',
                        'left'
                    )
                    ->addAttributeToSelect(['price', 'delivery_time', 'manufacturer', 'color', 'series', 'connection_size', 'type2'])
                    ->setPageSize($pageSize)
                    ->setCurPage($currentPage);
            }else{
                $category = $this->categoryRepository->get($catId);
                $subCategories = $category->getChildrenCategories();
                $layerInfoCategory = [];

                if (!empty($subCategories)) {
                    $category = $this->categoryRepository->get($catId);
                    $layerInfoCategory[] = [
                        'Name' => $category->getName(),
                        'link' => $category->getUrlKey()
                    ];
                }

                foreach ($subCategories as $subCategory) {
                    $layerInfoCategory[] = [
                        'Name' => $subCategory->getName(),
                        'link' => $subCategory->getUrlKey()
                    ];
                }

                $categoryArray = [
                    'id' => 'category',
                    'name' => 'category',
                    'items' => $layerInfoCategory
                ];

                $category = $this->categoryCollectionFactory->create();
                $category->addAttributeToSelect('*');
                $category->addAttributeToFilter('is_active', ['eq' => 1]);
                $category->addAttributeToFilter('name', ['like' => '%' . $searchKey . '%']);
                $catID = '';
                foreach($category->getData() as $cat){
                    $catID = $cat['entity_id'];
                }

                $productCollectionAttr = $this->productCollectionFactory->create();
                $productCollectionAttr->addCategoriesFilter(['eq' => $catID])
                    ->addAttributeToFilter('visibility', ['in' => [Visibility::VISIBILITY_BOTH, Visibility::VISIBILITY_IN_CATALOG]])
                    ->addAttributeToFilter('status', \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED)
                    ->addAttributeToFilter(
                        [
                            ['attribute' => 'color', 'notnull' => true],
                            ['attribute' => 'series', 'notnull' => true],
                            ['attribute' => 'connection_size', 'notnull' => true],
                            ['attribute' => 'type2', 'notnull' => true],
                        ],
                        '',
                        'left'
                    )
                    ->addAttributeToSelect(['price', 'delivery_time', 'manufacturer', 'color', 'series', 'connection_size', 'type2'])
                    ->setPageSize($pageSize)
                    ->setCurPage($currentPage);
            }

			$brandLable =  $productCollectionAttr->getResource()->getAttribute('manufacturer')->getStoreLabel();
			$colorLable =  $productCollectionAttr->getResource()->getAttribute('color')->getStoreLabel();
			$seriesLable =  $productCollectionAttr->getResource()->getAttribute('series')->getStoreLabel();
			$deliveryTimeLable =  $productCollectionAttr->getResource()->getAttribute('delivery_time')->getStoreLabel();
			$type2Lable =  $productCollectionAttr->getResource()->getAttribute('type2')->getStoreLabel();
			$connectionSizeLable =  $productCollectionAttr->getResource()->getAttribute('connection_size')->getStoreLabel();
			$layerNavArray = [];

			foreach ($productCollectionAttr as $dataAttr) {
                if (!empty($dataAttr->getPrice())) {
                    $price = round($dataAttr->getData('price'), 2);
                    $layerInfoPrice[] = $price;
                    $showPrice = array_unique($layerInfoPrice);

                    $currencyExchange = $this->storeManager->getStore()->getBaseCurrency()->getRate($currency);
                    if(!empty($currencyExchange)){
                        $exchangedMinPrice = min($showPrice)*$currencyExchange;
                        $exchangedMaxPrice = max($showPrice)*$currencyExchange;
                        $pricesort['price']['min'] = $exchangedMinPrice;
                        $pricesort['price']['max'] = $exchangedMaxPrice;
                    }else{
                        $pricesort['price']['min'] = min($showPrice);
                        $pricesort['price']['max'] = max($showPrice);
                    }
                }
				if (!empty($dataAttr->getAttributeText('manufacturer')))
				{
					$manufacturer = str_replace('.html', '' , $dataAttr->getAttributeText('manufacturer'));
					$layerInfoBrand [intval($dataAttr->getData('manufacturer'))] = $manufacturer;
					$manufacturerArray = [ 'id' => 'manufacturer',
											'name' => $brandLable,
											'items' => array_unique($layerInfoBrand)
										 ];
				}
				if (!empty($dataAttr->getAttributeText('color')))
				{
					$color = str_replace('.html', '' , $dataAttr->getAttributeText('color'));
					$layerInfoColor [intval($dataAttr->getData('color'))] = $color;
					$colorArray = [ 'id' => 'color',
									'name' => $colorLable,
									'items' =>array_unique($layerInfoColor)
								  ];
				}
				if (!empty($dataAttr->getAttributeText('series')))
				{
					$series = str_replace('.html', '' , $dataAttr->getAttributeText('series'));
					$layerInfoSeries [intval($dataAttr->getData('series'))] = $series;
					$seriesArray = [ 'id' => 'series',
									'name' => $seriesLable,
									'items' =>array_unique($layerInfoSeries)
								  ];
				}
				if (!empty($dataAttr->getAttributeText('delivery_time')))
				{
					$deliveryTime = $dataAttr->getAttributeText('delivery_time');
					$layerInfoDeliveryTime [intval($dataAttr->getData('delivery_time'))] = $deliveryTime;
					$deliverytimeArray = [ 'id' => 'delivery_time',
									'name' => $deliveryTimeLable,
									'items' =>array_unique($layerInfoDeliveryTime)
								  ];
				}
				if (!empty($dataAttr->getAttributeText('connection_size')))
				{
					$connectionSize = $dataAttr->getAttributeText('connection_size');
					$layerInfoConnectionSize [intval($dataAttr->getData('connection_size'))] = $connectionSize;
					$connectionsizeArray = [ 'id' => 'connection_size',
									'name' => $connectionSizeLable,
									'items' =>array_unique($layerInfoConnectionSize)
								  ];
				}
				if (!empty($dataAttr->getAttributeText('type2')))
				{
					$type2 = $dataAttr->getAttributeText('type2');
					$layerInfoType [intval($dataAttr->getData('type2'))] = $type2;
					$type2Array = [ 'id' => 'type2',
									'name' => $type2Lable,
									'items' =>array_unique($layerInfoType)
								  ];
				}
			}
			if(!empty($categoryArray)){
			$layerNavArray['category'] = $categoryArray;
			}
			if(!empty($manufacturerArray)){
			$layerNavArray['manufacturer'] = $manufacturerArray;
			}
			if(!empty($colorArray)){
			$layerNavArray['color'] = $colorArray;
			}
			if(!empty($seriesArray)){
			$layerNavArray['series'] = $seriesArray;
			}
			if(!empty($deliverytimeArray)){
			$layerNavArray['delivery_time'] = $deliverytimeArray;
			}
			if(!empty($connectionsizeArray)){
			$layerNavArray['connection_size'] = $connectionsizeArray;
			}
			if(!empty($connectionsizeArray)){
			$layerNavArray['type2'] = $type2Array;
			}
			$pricesort['showSort'] = [
					'position' => 'Topseller',
					'name' => 'Product Name',
					'price' => 'Price',
					'delivery_time' => 'Delivery Time'
                  ];

				$layerNavArray['sorting'] = [
					'pricesort_navigation' => $pricesort,

                  ];

            $result = $layerNavArray;

            $this->cache->save(json_encode($result), $cacheKey, ['LAYERS'], 600);
            return $result;
        //}else{
          //  return [];
        //}
    }
}
