<?php
namespace Xtwo\ProductListingApi\Model;

use Magento\Catalog\Api\CategoryRepositoryInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory as ProductCollectionFactory;
use Magento\Catalog\Model\CategoryFactory;
use Magento\Catalog\Model\Product\Visibility;
use Xtwo\AttributeOption\Helper\Image as ImageHelper;
use Magento\Store\Model\StoreManagerInterface;
use Magento\CatalogInventory\Api\StockRegistryInterface;
use Magento\Wishlist\Model\WishlistFactory;
use Xtwo\CustomApis\Helper\Data as CustomApisHelper;
use Magento\Review\Model\ReviewFactory;
use Magento\Review\Model\ResourceModel\Review\CollectionFactory as ReviewCollectionFactory;
use Magento\Review\Model\ResourceModel\Rating\Option\Vote\Collection as RatingOptionCollection;
use Magento\Framework\App\RequestInterface;
use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory as CategoryCollectionFactory;

class AmstyLayerSearchResult implements \Xtwo\ProductListingApi\Api\AmstyLayerSearchResultInterface
{
    protected $categoryRepository;
    protected $productCollectionFactory;
    private $categoryFactory;
    protected $visibility;
    protected $imageHelper;
    protected $storeManager;
    protected $stockRegistry;
    protected $mediaBaseUrl;
    protected $wishlistFactory;
    protected $customApisHelper;
    protected $reviewFactory;
    protected $reviewCollectionFactory;
    protected $ratingOption;
    protected $request;
    protected $categoryCollectionFactory;

    public function __construct(
        CategoryRepositoryInterface $categoryRepository,
        ProductCollectionFactory $productCollectionFactory,
        CategoryFactory $categoryFactory,
        Visibility $visibility,
        ImageHelper $imageHelper,
        StoreManagerInterface $storeManager,
        StockRegistryInterface $stockRegistry,
        WishlistFactory $wishlistFactory,
        CustomApisHelper $customApisHelper,
        ReviewFactory $reviewFactory,
        ReviewCollectionFactory $reviewCollectionFactory,
        RatingOptionCollection $ratingOption,
        RequestInterface $request,
        CategoryCollectionFactory $categoryCollectionFactory,
    ) {
        $this->categoryRepository = $categoryRepository;
        $this->productCollectionFactory = $productCollectionFactory;
        $this->categoryFactory = $categoryFactory;
        $this->visibility = $visibility;
        $this->imageHelper = $imageHelper;
        $this->storeManager = $storeManager;
        $this->stockRegistry = $stockRegistry;
        $this->mediaBaseUrl = $this->storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA);
        $this->wishlistFactory = $wishlistFactory;
        $this->customApisHelper = $customApisHelper;
        $this->reviewFactory = $reviewFactory;
        $this->reviewCollectionFactory = $reviewCollectionFactory;
        $this->ratingOption = $ratingOption;
        $this->request = $request;
        $this->categoryCollectionFactory = $categoryCollectionFactory;
    }

    public function getAmstyLayerSearchResult($searchKey,$currency)
    {

        if (strlen($searchKey) < 3) {
            return [
                'error' => true,
                'message' => 'Search key must have at least 3 characters.',
            ];
        }

        $category = $this->categoryCollectionFactory->create();
        $category->addAttributeToSelect('*');
        $category->addAttributeToFilter('is_active', ['eq' => 1]);
        $category->addAttributeToFilter('name', ['like' => '%' . $searchKey . '%']);

        if (1) {
            $catLevel = $category->getFirstItem()->getLevel();
            if($catLevel == 2){
                $catId = $category->getFirstItem()->getId();
            } else {
                $catId = $category->getFirstItem()->getParentId();
            }
            $pageSize = $this->request->getParam('pageSize');
            $currentPage = $this->request->getParam('currentPage');
            if($catId == 0){
                $productCollectionAttr = $this->productCollectionFactory->create();
                $productCollectionAttr->addAttributeToFilter('sku', ['like' => '%' . $searchKey . '%'])
                    ->addAttributeToFilter('visibility', ['in' => [Visibility::VISIBILITY_BOTH, Visibility::VISIBILITY_IN_CATALOG]])
                    ->addAttributeToFilter('status', \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED)
                    ->addAttributeToFilter(
                        [
                            ['attribute' => 'color', 'notnull' => true],
                            ['attribute' => 'series', 'notnull' => true],
                            ['attribute' => 'connection_size', 'notnull' => true],
                            ['attribute' => 'type2', 'notnull' => true],
                        ],
                        '',
                        'left'
                    )
                    ->addAttributeToSelect(['price', 'delivery_time', 'manufacturer', 'color', 'series', 'connection_size', 'type2'])
                    ->setPageSize($pageSize)
                    ->setCurPage($currentPage);
            }else{
                $category = $this->categoryRepository->get($catId);
                $subCategories = $category->getChildrenCategories();
                $layerInfoCategory = [];

                if (!empty($subCategories)) {
                    $category = $this->categoryRepository->get($catId);
                    $layerInfoCategory[] = [
                        'Name' => $category->getName(),
                        'link' => $category->getUrlKey()
                    ];
                }

                foreach ($subCategories as $subCategory) {
                    $layerInfoCategory[] = [
                        'Name' => $subCategory->getName(),
                        'link' => $subCategory->getUrlKey()
                    ];
                }

                $categoryArray = [
                    'id' => 'category',
                    'name' => 'category',
                    'items' => $layerInfoCategory
                ];

                $category = $this->categoryCollectionFactory->create();
                $category->addAttributeToSelect('*');
                $category->addAttributeToFilter('is_active', ['eq' => 1]);
                $category->addAttributeToFilter('name', ['like' => '%' . $searchKey . '%']);
                $catID = '';
                foreach($category->getData() as $cat){
                    $catID = $cat['entity_id'];
                }

                $productCollectionAttr = $this->productCollectionFactory->create();
                $productCollectionAttr->addCategoriesFilter(['eq' => $catID])
                    ->addAttributeToFilter('visibility', ['in' => [Visibility::VISIBILITY_BOTH, Visibility::VISIBILITY_IN_CATALOG]])
                    ->addAttributeToFilter('status', \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED)
                    ->addAttributeToFilter(
                        [
                            ['attribute' => 'color', 'notnull' => true],
                            ['attribute' => 'series', 'notnull' => true],
                            ['attribute' => 'connection_size', 'notnull' => true],
                            ['attribute' => 'type2', 'notnull' => true],
                        ],
                        '',
                        'left'
                    )
                    ->addAttributeToSelect(['price', 'delivery_time', 'manufacturer', 'color', 'series', 'connection_size', 'type2'])
                    ->setPageSize($pageSize)
                    ->setCurPage($currentPage);
            }

			$brandLable =  $productCollectionAttr->getResource()->getAttribute('manufacturer')->getStoreLabel();
			$colorLable =  $productCollectionAttr->getResource()->getAttribute('color')->getStoreLabel();
			$seriesLable =  $productCollectionAttr->getResource()->getAttribute('series')->getStoreLabel();
			$deliveryTimeLable =  $productCollectionAttr->getResource()->getAttribute('delivery_time')->getStoreLabel();
			$type2Lable =  $productCollectionAttr->getResource()->getAttribute('type2')->getStoreLabel();
			$connectionSizeLable =  $productCollectionAttr->getResource()->getAttribute('connection_size')->getStoreLabel();
			$layerNavArray = [];

			foreach ($productCollectionAttr as $dataAttr) {
                if (!empty($dataAttr->getPrice())) {
                    $price = round($dataAttr->getData('price'), 2);
                    $layerInfoPrice[] = $price;
                    $showPrice = array_unique($layerInfoPrice);

                    $currencyExchange = $this->storeManager->getStore()->getBaseCurrency()->getRate($currency);
                    if(!empty($currencyExchange)){
                        $exchangedMinPrice = min($showPrice)*$currencyExchange;
                        $exchangedMaxPrice = max($showPrice)*$currencyExchange;
                        $pricesort['price']['min'] = $exchangedMinPrice;
                        $pricesort['price']['max'] = $exchangedMaxPrice;
                    }else{
                        $pricesort['price']['min'] = min($showPrice);
                        $pricesort['price']['max'] = max($showPrice);
                    }
                }
				if (!empty($dataAttr->getAttributeText('manufacturer')))
				{
					$manufacturer = str_replace('.html', '' , $dataAttr->getAttributeText('manufacturer'));
					$layerInfoBrand [intval($dataAttr->getData('manufacturer'))] = $manufacturer;
					$manufacturerArray = [ 'id' => 'manufacturer',
											'name' => $brandLable,
											'items' => array_unique($layerInfoBrand)
										 ];
				}
				if (!empty($dataAttr->getAttributeText('color')))
				{
					$color = str_replace('.html', '' , $dataAttr->getAttributeText('color'));
					$layerInfoColor [intval($dataAttr->getData('color'))] = $color;
					$colorArray = [ 'id' => 'color',
									'name' => $colorLable,
									'items' =>array_unique($layerInfoColor)
								  ];
				}
				if (!empty($dataAttr->getAttributeText('series')))
				{
					$series = str_replace('.html', '' , $dataAttr->getAttributeText('series'));
					$layerInfoSeries [intval($dataAttr->getData('series'))] = $series;
					$seriesArray = [ 'id' => 'series',
									'name' => $seriesLable,
									'items' =>array_unique($layerInfoSeries)
								  ];
				}
				if (!empty($dataAttr->getAttributeText('delivery_time')))
				{
					$deliveryTime = $dataAttr->getAttributeText('delivery_time');
					$layerInfoDeliveryTime [intval($dataAttr->getData('delivery_time'))] = $deliveryTime;
					$deliverytimeArray = [ 'id' => 'delivery_time',
									'name' => $deliveryTimeLable,
									'items' =>array_unique($layerInfoDeliveryTime)
								  ];
				}
				if (!empty($dataAttr->getAttributeText('connection_size')))
				{
					$connectionSize = $dataAttr->getAttributeText('connection_size');
					$layerInfoConnectionSize [intval($dataAttr->getData('connection_size'))] = $connectionSize;
					$connectionsizeArray = [ 'id' => 'connection_size',
									'name' => $connectionSizeLable,
									'items' =>array_unique($layerInfoConnectionSize)
								  ];
				}
				if (!empty($dataAttr->getAttributeText('type2')))
				{
					$type2 = $dataAttr->getAttributeText('type2');
					$layerInfoType [intval($dataAttr->getData('type2'))] = $type2;
					$type2Array = [ 'id' => 'type2',
									'name' => $type2Lable,
									'items' =>array_unique($layerInfoType)
								  ];
				}
			}
			if(!empty($categoryArray)){
			$layerNavArray['category'] = $categoryArray;
			}
			if(!empty($manufacturerArray)){
			$layerNavArray['manufacturer'] = $manufacturerArray;
			}
			if(!empty($colorArray)){
			$layerNavArray['color'] = $colorArray;
			}
			if(!empty($seriesArray)){
			$layerNavArray['series'] = $seriesArray;
			}
			if(!empty($deliverytimeArray)){
			$layerNavArray['delivery_time'] = $deliverytimeArray;
			}
			if(!empty($connectionsizeArray)){
			$layerNavArray['connection_size'] = $connectionsizeArray;
			}
			if(!empty($connectionsizeArray)){
			$layerNavArray['type2'] = $type2Array;
			}
			$pricesort['showSort'] = [
					'position' => 'Topseller',
					'name' => 'Product Name',
					'price' => 'Price',
					'delivery_time' => 'Delivery Time'
                  ];

				$layerNavArray['sorting'] = [
					'pricesort_navigation' => $pricesort,

                  ];

            $result = $layerNavArray;

            return $result;
        }else{
            return [];
        }
    }
}
