<?php
namespace Xtwo\ProductDetailApi\Model;

use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Catalog\Model\ProductRepository;
use Magento\Catalog\Api\ProductAttributeRepositoryInterface;
use Magento\Eav\Api\AttributeGroupRepositoryInterface;
use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory as ProductCollectionFactory;
use Magento\Catalog\Model\ProductFactory;
use Magento\Catalog\Helper\Product as ProductHelper;
use Magento\Review\Model\RatingFactory;
use Xtwo\AttributeOption\Model\ResourceModel\Image\Collection as GridCollection;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Catalog\Model\Product\Attribute\Repository as AttributeRepository;
use Magento\Eav\Api\Data\AttributeInterface;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Eav\Model\Config;
use Magento\Eav\Model\Entity\Attribute\GroupFactory;
use Magento\Catalog\Helper\ImageFactory;
use Magento\Catalog\Api\ProductAttributeMediaGalleryManagementInterface;
use Magento\Catalog\Api\Data\ProductAttributeMediaGalleryEntryInterface;
use Magento\Framework\Translate\Inline\StateInterface;
use Magento\Checkout\Model\Session;
use Magento\Framework\View\Result\PageFactory;
use Xtwo\Catalog\Model\ProductFactory as XtwoProductFactory;
use Xtwo\AttributeOption\Helper\Image as ImageHelper;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Review\Model\ReviewFactory;
use Xtwo\CustomApis\Helper\Data as CustomApisHelper;
use Magento\ConfigurableProduct\Model\Product\Type\Configurable;
use Magento\ConfigurableProduct\Model\ResourceModel\Product\Type\Configurable as configurableProduct;
use Magento\Catalog\Model\Product\Visibility;
use Magento\Tax\Helper\Data as TaxHelper;

class ProductLinkingDetail implements \Xtwo\ProductDetailApi\Api\ProductLinkingDetailInterface
{

    /**
     * @var ProductRepositoryInterface
     */
    protected $productRepository;
    protected $productAttributeRepository;
    protected $attributeGroupRepository;
    protected $productCollectionFactory;
    protected $stockRegistry;
    protected $productFactory;
    protected $productHelper;
    protected $ratingFactory;
    protected $gridCollection;
    protected $storeManager;
    protected $attributeRepository;
    protected $searchCriteriaBuilder;
    protected $_registry;
    protected $groupCollection;

    /**
     * @var ProductAttributeMediaGalleryManagementInterface
     */
    private $productAttributeMediaGallery;

    /**
     * @var StateInterface
     */
    protected $inlineTranslation;
    protected $checkoutSession;
    protected $helper;
    protected $alternativesellFactory;
    protected $_imageHelper;
    private XtwoProductFactory $xtwoProductFactory;
    /**
     * ProductDetail constructor.
     * @param ProductRepositoryInterface $productRepository
     * @param AttributeRepository $attributeRepository
     * // ... other dependencies
     */

    /**
     * ProductDetail constructor.
     * @param ProductRepositoryInterface $productRepository
     */
    /**

     * @var \Magento\Catalog\Api\ProductCustomOptionRepositoryInterface

     */

     protected $customOptionRepository;
     protected $reviewFactory;
     protected $customApisHelper;
     protected $taxCalculation;
     protected $configurable;
     protected $_storeManager;
     protected $_productTypeConfigurable;
     private $optionRepository;
     protected $visibility;
	 protected $taxHelper;
	 protected $scopeConfig;

    public function __construct(
        ProductRepositoryInterface $productRepository,
        ProductAttributeRepositoryInterface $productAttributeRepository,
        AttributeGroupRepositoryInterface $attributeGroupRepository,
        ProductCollectionFactory $productCollectionFactory,
        \Magento\CatalogInventory\Api\StockRegistryInterface $stockRegistry,
        ProductFactory $productFactory,
        ImageHelper $_imageHelper,
        ProductHelper $productHelper,
        GridCollection $gridCollection,
        StoreManagerInterface $storeManager,
        ProductRepositoryInterface $_productRepository,
        AttributeRepository $attributeRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        ProductAttributeMediaGalleryManagementInterface $productAttributeMediaGallery,
        \Magento\Framework\Registry $registry,
        \Xtwo\AttributesGroup\Block\Product\View\CustomAttributes $groupCollection,
        StateInterface $inlineTranslation,
        Session $checkoutSession,
        \Xtwo\ProductDetailApi\Helper\Data $helper,
        XtwoProductFactory $xtwoProductFactory,
        \Magento\Catalog\Api\ProductCustomOptionRepositoryInterface $customOptionRepository,
        ReviewFactory $reviewFactory,
        CustomApisHelper $customApisHelper,
        \Magento\Tax\Model\Calculation $taxCalculation,
        Configurable $configurable,
        configurableProduct $configurableProduct,
        \Magento\ConfigurableProduct\Api\OptionRepositoryInterface $optionRepository,
        Visibility $visibility,
		\Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
		TaxHelper $taxHelper
    ) {
        $this->productAttributeRepository = $productAttributeRepository;
        $this->attributeGroupRepository = $attributeGroupRepository;
        $this->productCollectionFactory = $productCollectionFactory;
        $this->stockRegistry = $stockRegistry;
        $this->productFactory = $productFactory;
        $this->_imageHelper = $_imageHelper;
        $this->productHelper = $productHelper;
        $this->gridCollection = $gridCollection;
        $this->storeManager = $storeManager;
        $this->attributeRepository = $attributeRepository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->productAttributeMediaGallery = $productAttributeMediaGallery;
        $this->_registry = $registry;
        $this->groupCollection = $groupCollection;
        $this->inlineTranslation = $inlineTranslation;
        $this->checkoutSession = $checkoutSession;
        $this->helper = $helper;
        $this->xtwoProductFactory = $xtwoProductFactory;
        $this->productRepository = $productRepository;
        $this->customOptionRepository = $customOptionRepository;
        $this->ratingFactory = $reviewFactory;
        $this->customApisHelper = $customApisHelper;
        $this->taxCalculation = $taxCalculation;
        $this->configurable = $configurable;
        $this->_productTypeConfigurable = $configurableProduct;
        $this->optionRepository = $optionRepository;
        $this->visibility = $visibility;
		$this->taxHelper = $taxHelper;
		$this->scopeConfig = $scopeConfig;
    }

    public function getProductLinkingDetailByUrl($productUrl)
    {
        $productResponse = [];
        try{
            $this->inlineTranslation->suspend();
            $storeId = $this->storeManager->getStore()->getId();
            $productCollection = $this->productCollectionFactory->create();
            $productCollection->addAttributeToSelect('*');

           /*$productCollection->addAttributeToFilter(
                'visibility',
                ['in' => [Visibility::VISIBILITY_BOTH, Visibility::VISIBILITY_IN_CATALOG, Visibility::VISIBILITY_NOT_VISIBLE]]
            );*/
            
            $productCollection->addAttributeToFilter('status', \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED);
			$productCollection->addStoreFilter($storeId);
            $productCollection->addAttributeToFilter('url_key', ['in' => $productUrl]);
            $productCollection->addAttributeToFilter('type_id', ['neq' => 'configurable']);
            $productCollection->setPageSize(1);
            
            $product = $productCollection->getFirstItem();
            $store = $this->storeManager->getStore();
            $relatedProductsResponse = [];
            $relatedProducts = $product->getRelatedProducts();
            if (count($relatedProducts)){
                foreach ($relatedProducts as $productItem){
                    $productItem = $this->productRepository->getById($productItem->getData('entity_id'));
                    if($productItem->getStatus()==\Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED){
                        $relatedProductsResponse[] =$this->getProductData($productItem);
                    }
                }
            }
            $crossSellProducts = $product->getCrossSellProducts();
            $crossSellProductsResponse =[];
            if (count($crossSellProducts)){
                foreach ($crossSellProducts as $crossProductItem){
                    $crossProductItem = $this->productRepository->getById($crossProductItem->getData('entity_id'));
                    
                    if($crossProductItem->getStatus()==\Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED){
                        $crossSellProductsResponse[] =$this->getProductData($crossProductItem);
                    }
                }
            }
            $currentProduct = $this->xtwoProductFactory->create()->load($product->getId());
            $alternativeProductsResponse =[];
            $alternativeProducts = $currentProduct->getAlternativesellProductCollection()
            ->addAttributeToFilter('status', 1)
            ->addFieldToSelect('*');
            
            foreach ($alternativeProducts as $alternativeItem){
                $alternativeProductsResponse[] =$this->getProductData($alternativeItem);
            }
            $spareSellProductsResponse =[];
            $spareSellProducts = $currentProduct->getSparesellProductCollection()
            ->addAttributeToFilter('status', 1)
            ->addFieldToSelect('*');
            
            foreach ($spareSellProducts as $spareItem){
                $spareSellProductsResponse[] =$this->getProductData($spareItem);
            }
            $upSellProducts = $product->getUpSellProducts();
            $upSellProductsResponse = [];
            if (count($upSellProducts)){
                foreach ($upSellProducts as $upsellProductItem){
                    $upSellProductsResponse[] =$this->getProductData($upsellProductItem);
                }
            }
            $seriesProductsResponse =[];
            $seriesSellProducts = $currentProduct->getSeriessellProductCollection()
            ->addAttributeToFilter('status', 1)
            ->addFieldToSelect('*');
            
            foreach ($seriesSellProducts as $seriesItem){
                $seriesProductsResponse[] =$this->getProductData($seriesItem);
            }
           $sampleProductsResponse =[];
           $seriesSellProducts = $currentProduct->getSamplesellProductCollection()
           ->addAttributeToFilter('status', 1)
           ->addFieldToSelect('*');
           
            foreach ($seriesSellProducts as $sampleItem){
                $sampleProductsResponse[] =$this->getProductData($sampleItem);
            }
            $productResponse['other_products']['Buy it with'] = $relatedProductsResponse;
            $productResponse['other_products']['Frequently bought together'] = $crossSellProductsResponse;
            $productResponse['other_products']['You may interested in'] = $alternativeProductsResponse;
            $productResponse['other_products']['Spare part'] = $spareSellProductsResponse;
            $productResponse['other_products']['Series Products'] = $seriesProductsResponse;
            $productResponse['other_products']['Similar products'] = $upSellProductsResponse;
            $productResponse['other_products']['Sample Sell'] = $sampleProductsResponse;
            
            if (empty($productResponse)) {
                throw new NoSuchEntityException();
            }

            return $productResponse;
        } catch (NoSuchEntityException $e) {
            throw $e;
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }

    protected function getProductData($product)
    {
        
        $productStock = $this->stockRegistry->getStockItem($product->getId());
        $showButtons = $this->customApisHelper->getButtonStatus($product);
		// Calculate price with VAT
		$taxClassId = $product->getTaxClassId();
		$store      = $this->storeManager->getStore();
		$request = $this->taxCalculation->getRateRequest(null, null, null, $store);
		$taxRate = $this->taxCalculation->getRate($request->setProductClassId($taxClassId));
		
		
        $cpProduct = $this->xtwoProductFactory->create()->load($product->getId());
        $otherPrice = $cpProduct->getPrice();
		$otherPrice = ($otherPrice);
		$otherBasePrice = $otherPrice / 1.19;
		$otherPriceWithTax = $otherBasePrice + ($otherBasePrice * ($taxRate / 100));
		
		$otherMsrpPrice = $cpProduct->getMsrp();
		$otherMsrpBasePrice = $otherMsrpPrice / 1.19;
		$otherMsrpPriceWithTax = $otherMsrpBasePrice + ($otherMsrpBasePrice * ($taxRate / 100));
        $layerImageOptionId = $cpProduct->getLayerImages();
        return [
            'id' => $product->getId(),
            'sku' => $product->getSku(),
            'name' => $cpProduct->getName(),
            'qty' => $productStock->getQty(),
            'is_in_stock' =>$productStock->getIsInStock(),
            'image' => $cpProduct->getData('image'),
            'product_link' => $cpProduct->getUrlKey(),
            //'msrp' => (string)$otherMsrpPriceWithTax,
            'msrp' => (string)$cpProduct->getMsrp(),
            //'price' => (string)$otherPriceWithTax,
            'price' => (string)$cpProduct->getPrice(),
            'product_avg_rating' => $this->customApisHelper->getAverageRating($product->getId()),
            'show_addtocart_button' => $showButtons,
            'layer_image' => $this->getLayerImagesPath($layerImageOptionId),
        ];
    }

    private function getLayerImagesPath($optionId)
    {
        if ($this->_imageHelper->getLayerImage($optionId)) {
            $imagePath = 'attributeoption/image/' . $this->_imageHelper->getLayerImage($optionId);
            return $imagePath;
        }else{
            return '';
        }
    }

    private function getConfigurableOptionsByChildProductId($childProductId, $storeId) {
        try {
            $childProduct = $this->productRepository->getById($childProductId);
            $parentIds = $this->configurable->getParentIdsByChild($childProductId);
            if (!empty($parentIds)) {
                $parentId = reset($parentIds);
                $parentProduct = $this->productRepository->getById($parentId);
                $options = [];
                $attributes = $parentProduct->getTypeInstance()->getConfigurableAttributes($parentProduct);
                foreach ($attributes as $attribute) {
                    $attributeLabel = $attribute->getProductAttribute()->getStoreLabel($storeId);
                    if (!$attributeLabel) {
                        $attributeLabel = $attribute->getLabel();
                    }
                    $optionValue = $childProduct->getAttributeText($attribute->getProductAttribute()->getAttributeCode());
                    $optionValue = strip_tags($optionValue);
                    $options[] = [
                        'label' => $attributeLabel,
                        'value' => $optionValue
                    ];
                }
                return [$options];
            } else {
                return [];
            }
        } catch (\Exception $e) {
            return [];
        }
    }
    
    protected function getChildData($product,$urlKey,$childAttributes){
        $selection = false;
        if($product->getUrlKey() == $urlKey){
            $selection = true;
        }

        $finalResponse = [
            'id' => $product->getId(),
            'sku' => $product->getSku(),
            'url_key' => $product->getUrlKey(),
            'default_select' => $selection,
            'attributes' => $childAttributes
        ];
        return $finalResponse;
    }

    private function getManufacturerImagePath($data)
    {
        if ($this->_imageHelper->getManufacturerImage($data)) {
            $imagePath = 'attributeoption/image/' . $this->_imageHelper->getManufacturerImage($data);
            return $this->storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA) . $imagePath;
        } else {
            return '';
        }
    }

    protected function getChildProducts($configurableProduct)
    {
        $childProducts = $configurableProduct->getTypeInstance()->getUsedProducts($configurableProduct);

        $enabledChildProducts = array_filter($childProducts, function ($childProduct) {
            return $childProduct->getStatus() == \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED;
        });

        return $enabledChildProducts;
    }

    protected function generateConfigData(\Magento\Catalog\Model\Product $parentProduct,\Magento\Catalog\Model\Product $currentProduct)
    {
        $typeInstance = $parentProduct->getTypeInstance();

        $configData = array();
        $attributes = $typeInstance->getUsedProductAttributes($parentProduct);

        foreach ($attributes as $code => $data) {
            $configData[$code] = $currentProduct->getData($data->getAttributeCode());
        }

        return $configData;
    }

    protected function getSelectedOptions(\Magento\Catalog\Model\Product $parentProduct,\Magento\Catalog\Model\Product $currentProduct)
    {
        /* @var $typeInstance Mage_Catalog_Model_Product_Type_Configurable */
        $typeInstance = $parentProduct->getTypeInstance();

        $configData = array();
        $attributes = $typeInstance->getUsedProductAttributes($parentProduct);

        foreach ($attributes as $code => $data) {
            $configData[$data->getAttributeCode()] = $currentProduct->getData($data->getAttributeCode());
        }

        return $configData;
    }
}