<?php
namespace Xtwo\ProductDetailApi\Model;

use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Catalog\Model\ProductRepository;
use Magento\Catalog\Api\ProductAttributeRepositoryInterface;
use Magento\Eav\Api\AttributeGroupRepositoryInterface;
use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory as ProductCollectionFactory;
use Magento\Catalog\Model\ProductFactory;
use Magento\Catalog\Helper\Product as ProductHelper;
use Magento\Review\Model\RatingFactory;
use Xtwo\AttributeOption\Model\ResourceModel\Image\Collection as GridCollection;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Catalog\Model\Product\Attribute\Repository as AttributeRepository;
use Magento\Eav\Api\Data\AttributeInterface;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Eav\Model\Config;
use Magento\Eav\Model\Entity\Attribute\GroupFactory;
use Magento\Catalog\Helper\ImageFactory;
use Magento\Catalog\Api\ProductAttributeMediaGalleryManagementInterface;
use Magento\Catalog\Api\Data\ProductAttributeMediaGalleryEntryInterface;
use Magento\Framework\Translate\Inline\StateInterface;
use Magento\Checkout\Model\Session;
use Magento\Framework\View\Result\PageFactory;
use Xtwo\Catalog\Model\ProductFactory as XtwoProductFactory;
use Xtwo\AttributeOption\Helper\Image as ImageHelper;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Review\Model\ReviewFactory;
use Xtwo\CustomApis\Helper\Data as CustomApisHelper;
use Magento\ConfigurableProduct\Model\Product\Type\Configurable;
use Magento\ConfigurableProduct\Model\ResourceModel\Product\Type\Configurable as configurableProduct;
use Magento\Catalog\Model\Product\Visibility;
use Magento\Tax\Helper\Data as TaxHelper;
use Xtwo\Priceunitgroup\Model\Group as PriceUnitGroup;

class ProductDetail implements \Xtwo\ProductDetailApi\Api\ProductDetailInterface
{

    /**
     * @var ProductRepositoryInterface
     */
    protected $productRepository;
    protected $productAttributeRepository;
    protected $attributeGroupRepository;
    protected $productCollectionFactory;
    protected $stockRegistry;
    protected $productFactory;
    protected $productHelper;
    protected $ratingFactory;
    protected $gridCollection;
    protected $storeManager;
    protected $attributeRepository;
    protected $searchCriteriaBuilder;
    protected $_registry;
    protected $groupCollection;

    /**
     * @var ProductAttributeMediaGalleryManagementInterface
     */
    private $productAttributeMediaGallery;

    /**
     * @var StateInterface
     */
    protected $inlineTranslation;
    protected $checkoutSession;
    protected $helper;
    protected $alternativesellFactory;
    protected $_imageHelper;
    private XtwoProductFactory $xtwoProductFactory;
    /**
     * ProductDetail constructor.
     * @param ProductRepositoryInterface $productRepository
     * @param AttributeRepository $attributeRepository
     * // ... other dependencies
     */

    /**
     * ProductDetail constructor.
     * @param ProductRepositoryInterface $productRepository
     */
    /**

     * @var \Magento\Catalog\Api\ProductCustomOptionRepositoryInterface

     */

     protected $customOptionRepository;
     protected $reviewFactory;
     protected $customApisHelper;
     protected $taxCalculation;
     protected $configurable;
     protected $_storeManager;
     protected $_productTypeConfigurable;
     private $optionRepository;
     protected $visibility;
	 protected $taxHelper;
	 protected $scopeConfig;

    public function __construct(
        ProductRepositoryInterface $productRepository,
        ProductAttributeRepositoryInterface $productAttributeRepository,
        AttributeGroupRepositoryInterface $attributeGroupRepository,
        ProductCollectionFactory $productCollectionFactory,
        \Magento\CatalogInventory\Api\StockRegistryInterface $stockRegistry,
        ProductFactory $productFactory,
        ImageHelper $_imageHelper,
        ProductHelper $productHelper,
        GridCollection $gridCollection,
        StoreManagerInterface $storeManager,
        ProductRepositoryInterface $_productRepository,
        AttributeRepository $attributeRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        ProductAttributeMediaGalleryManagementInterface $productAttributeMediaGallery,
        \Magento\Framework\Registry $registry,
        \Xtwo\AttributesGroup\Block\Product\View\CustomAttributes $groupCollection,
        StateInterface $inlineTranslation,
        Session $checkoutSession,
        \Xtwo\ProductDetailApi\Helper\Data $helper,
        XtwoProductFactory $xtwoProductFactory,
        \Magento\Catalog\Api\ProductCustomOptionRepositoryInterface $customOptionRepository,
        ReviewFactory $reviewFactory,
        CustomApisHelper $customApisHelper,
        \Magento\Tax\Model\Calculation $taxCalculation,
        Configurable $configurable,
        configurableProduct $configurableProduct,
        \Magento\ConfigurableProduct\Api\OptionRepositoryInterface $optionRepository,
        Visibility $visibility,
		\Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
		TaxHelper $taxHelper,
        PriceUnitGroup $priceUnitGroup
    ) {
        $this->productAttributeRepository = $productAttributeRepository;
        $this->attributeGroupRepository = $attributeGroupRepository;
        $this->productCollectionFactory = $productCollectionFactory;
        $this->stockRegistry = $stockRegistry;
        $this->productFactory = $productFactory;
        $this->_imageHelper = $_imageHelper;
        $this->productHelper = $productHelper;
        $this->gridCollection = $gridCollection;
        $this->storeManager = $storeManager;
        $this->attributeRepository = $attributeRepository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->productAttributeMediaGallery = $productAttributeMediaGallery;
        $this->_registry = $registry;
        $this->groupCollection = $groupCollection;
        $this->inlineTranslation = $inlineTranslation;
        $this->checkoutSession = $checkoutSession;
        $this->helper = $helper;
        $this->xtwoProductFactory = $xtwoProductFactory;
        $this->productRepository = $productRepository;
        $this->customOptionRepository = $customOptionRepository;
        $this->ratingFactory = $reviewFactory;
        $this->customApisHelper = $customApisHelper;
        $this->taxCalculation = $taxCalculation;
        $this->configurable = $configurable;
        $this->_productTypeConfigurable = $configurableProduct;
        $this->optionRepository = $optionRepository;
        $this->visibility = $visibility;
		$this->taxHelper = $taxHelper;
		$this->scopeConfig = $scopeConfig;
        $this->priceUnitGroup = $priceUnitGroup;
    }

    public function getProductDetailByUrl($productUrl)
    {
        $msrpPriceWithTax = 0;
        $priceWithTax = 0;
        
        try{
           
            $this->inlineTranslation->suspend();
            $storeId = $this->storeManager->getStore()->getId();
            $productCollection = $this->productCollectionFactory->create();
            $productCollection->addAttributeToSelect('*');

            $productCollection->addAttributeToFilter(
                'visibility',
                ['in' => [Visibility::VISIBILITY_BOTH, Visibility::VISIBILITY_IN_CATALOG, Visibility::VISIBILITY_NOT_VISIBLE]]
            );
            
            $productCollection->addAttributeToFilter('status', \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED);
			$productCollection->addStoreFilter($storeId);
            $productCollection->addAttributeToFilter('url_key', ['in' => $productUrl]);
            $productCollection->addAttributeToFilter('type_id', ['neq' => 'configurable']);
            $productCollection->setPageSize(1);
            $finalArray = [];
            foreach ($productCollection as $value) {
                preg_match('/href="(.*?)"/', $value->getAttributeText('manufacturer'), $matches);
                preg_match('/href="(.*?)"/', $value->getAttributeText('series'), $matches1);
                preg_match('/href="(.*?)"/', $value->getAttributeText('type'), $matches2);
                $productData = [];

                $metaInfo = [
                    'meta_title' => $value->getMetaTitle(),
                    'meta_description' => $value->getMetaDescription(),
                ];
                //$productData['meta_info'] = $metaInfo;

                $breadcrumbPath = $this->helper->getBreadcrumbByProductId($value->getId());
                $productData['bread_crumb'] = $breadcrumbPath;

                $taxClassId = $value->getTaxClassId();
                $store      = $this->storeManager->getStore();
                $request = $this->taxCalculation->getRateRequest(null, null, null, $store);
                $taxRate = $this->taxCalculation->getRate($request->setProductClassId($taxClassId));
               
                $showButtons = $this->customApisHelper->getButtonStatus($value);
                
				// Calculate price with VAT
				$price = $value->getPrice();
        
				$price = round($price, 2);
				$basePrice = $price / 1.19;
				
				$msrpPrice = $value->getMsrp();
				$msrpBasePrice = $msrpPrice / 1.19;
				
				$restrictedSkusList = "";
				$restrictedSkusList = $this->scopeConfig->getValue('restrict/shippingmethod/restrict_skus',
				\Magento\Store\Model\ScopeInterface::SCOPE_STORE);
				
				$restrictedSkusArray =[];
				if(!empty($restrictedSkusList)){
					$restrictedSkusArray = explode(',', $restrictedSkusList);
				}
				
				if(!empty($restrictedSkusArray)){
					if (in_array($value->getSku(), $restrictedSkusArray)) {
						$priceWithTax = $value->getPrice();
						$msrpPriceWithTax = $value->getMsrp();
					}
					else
					{
						$priceWithTax = $basePrice + ($basePrice * ($taxRate / 100));
						$msrpPriceWithTax = $msrpBasePrice + ($msrpBasePrice * ($taxRate / 100));
                       
					}
				}else {
                    $priceWithTax = $value->getPrice();
					$msrpPriceWithTax = $value->getMsrp();
                }
                
	
                $basicInfo = [
                    'id' => $value->getId(),
                    'sku' => $value->getSku(),
                    'url_key' => $value->getUrlKey(),
                    'name' => $value->getName(),
                    'attribute_set_id' => $value->getAttributeSetId(),
                    'price' => (string)$priceWithTax,
                    'status' => $value->getStatus(),
                    'visibility' => $value->getVisibility(),
                    'type_id' => $value->getTypeId(),
                    'weight' => $value->getWeight(),
                    'delivery_time' => $value->getAttributeText('delivery_time'),
                    'show_addtocart_button' => $showButtons,
                    'msrp' => (string)$msrpPriceWithTax,
                    'series' => [
                        'name' => strip_tags($value->getAttributeText('series')),
                        'link' => isset($matches1[1]) ? str_replace('.html', '', $matches1[1]) : '',
                    ],
                    'manufacturer' => [
                        'name' => strip_tags($value->getAttributeText('manufacturer')),
                        'link' => isset($matches[1]) ? str_replace('.html', '', $matches[1]) : '',
                        'image' => $this->getManufacturerImagePath($value),
                    ],
                    'average_rating' => $this->customApisHelper->getAverageRating($value->getId()),
                    'tax' => $taxRate,
                    'base_price_unit'=>$value->getData('base_price_unit'),
                    'packaging_format'=>$value->getAttributeText('packaging_format'),
                    'price_per_pallet'=>$value->getData('price_per_pallet'),
                    'price_per_carton'=>$value->getData('price_per_carton'),
                ];
                $productData['basic_info'] = $basicInfo;

               $productStock = $this->stockRegistry->getStockItem($value->getId());
                $stockItem = [
                    'qty' => $productStock->getQty(),
                    'is_in_stock' => $productStock->getIsInStock(),
                ];
                $productData['stock_item'] = $stockItem;

                $mediaGalleryEntries = [];

                $mediaGallery = $this->productRepository->getById($value->getId());
                $images = $mediaGallery->getMediaGalleryEntries();
                foreach ($images as $media) {
                    $mediaGalleryEntries[] = [
                        'id' => $media->getId(),
                        'media_type' => $media->getMediaType(),
                        'label' => $media->getLabel(),
                        'position' => $media->getPosition(),
                        'disabled' => $media->isDisabled(),
                        'types' => $media->getTypes(),
                        'file' => $media->getFile()
                    ];
                }

                $productData['media_gallery_entries'] = $mediaGalleryEntries;

                /*$relatedProductCollection = $value->getRelatedProductCollection();
                $relatedProductCollection
                    ->addAttributeToSelect('*')
                    ->addAttributeToFilter('status', 1)
                    ->addAttributeToSort('position');
                $relatedProducts = [];
                foreach ($relatedProductCollection as $product) {
                    $relatedProducts[] = $this->getProductData($product);
                }

                $product = $this->productFactory->create()->load($value->getId());
                $upSellProductCollection = $product->getUpSellProductCollection();
                $upSellProductCollection->addFieldToSelect('*');
                $upSellProductCollection->addAttributeToFilter('status', 1);
                $upSellProductCollection->addAttributeToSort('position');
                $upSellProducts = [];
                foreach ($upSellProductCollection as $upSellProduct) {
                $upSellProducts[] = $this->getProductData($upSellProduct);
                }

                $crossSellProductCollection = $value->getCrossSellProductCollection();
                $crossSellProductCollection->addFieldToSelect('*');
                $crossSellProductCollection->addAttributeToFilter('status', 1);
                $crossSellProductCollection->addAttributeToSort('position');
                $crossSellProducts = [];
                foreach($crossSellProductCollection as $crossSellProduct){
                    $crossSellProducts[] = $this->getProductData($crossSellProduct);
                }

                $currentProduct = $this->xtwoProductFactory->create()->load($value->getId());
                $alternativeProducts = [];

                $alternativeSellProductCollection = $currentProduct->getAlternativesellProductCollection()
                                                                    ->addAttributeToFilter('status', 1)
                                                                    ->addFieldToSelect('*');
                foreach ($alternativeSellProductCollection as $alternativeProduct) {
                    $alternativeProducts[] = $this->getProductData($alternativeProduct);
                }

                $spareSellProductCollection = $currentProduct->getSparesellProductCollection()
                                                            ->addAttributeToFilter('status', 1)
                                                            ->addFieldToSelect('*');
                $spareSellProducts = [];
                foreach ($spareSellProductCollection as $spareSellProduct) {
                    $spareSellProducts[] = $this->getProductData($spareSellProduct);
                }

                $seriesSellProductCollection = $currentProduct->getSeriessellProductCollection()
                                                            ->addAttributeToFilter('status', 1)
                                                            ->addFieldToSelect('*');
                $seriesSellProducts = [];
                foreach ($seriesSellProductCollection as $seriesSellProduct) {
                    $seriesSellProducts[] = $this->getProductData($seriesSellProduct);
                }

                $sampleSellProductCollection = $currentProduct->getSamplesellProductCollection()
                                                            ->addAttributeToFilter('status', 1)
                                                            ->addFieldToSelect('*');
                $sampleSellProducts = [];
                foreach ($sampleSellProductCollection as $sampleSellProduct) {
                    $sampleSellProducts[] = $this->getProductData($sampleSellProduct);
                }
                    */

                $customAttributeArray = $this->groupCollection->getExtendedGroupedAttributesForProduct($value, true);
                $escapedCustomAttributeArray = [];

                foreach ($customAttributeArray as $groupLabel => $groupData) {
                    $escapedGroupLabel = $groupLabel;
                    $escapedGroupData = [];

                    foreach ($groupData as $attribute) {
                        $escapedAttributeCode = isset($attribute['attributeCode']) ? $attribute['attributeCode'] : '';
                        $escapedLabel = isset($attribute['attributeLabel']) ? $attribute['attributeLabel'] : '';
                        $escapedValue = isset($attribute['value']) ? $attribute['value'] : '';
                        if(is_array($escapedValue)){
                            $escapedValue = [];
                            foreach($attribute['value'] as $abc){
                                $escapedValue[] = $abc['frontend'];
                            }
                        }
                        if ($escapedAttributeCode === 'manufacturer') {
                            $manufacturerData = [
                                'attribute_code' => $escapedAttributeCode,
                                'label' => $escapedLabel,
                                'value' => [
                                    strip_tags($value->getAttributeText('manufacturer')),
                                    isset($matches[1]) ? str_replace('.html', '', $matches[1]) : '',
                                    $this->getManufacturerImagePath($value)
                                ]
                            ];
                            $escapedGroupData[] = $manufacturerData;
                        } elseif($escapedAttributeCode === 'series'){
                            $seriesData = [
                                'attribute_code' => $escapedAttributeCode,
                                'label' => $escapedLabel,
                                'value' => [
                                    strip_tags($value->getAttributeText('series')),
                                    isset($matches1[1]) ? str_replace('.html', '', $matches1[1]) : '',
                                ]
                            ];
                            $escapedGroupData[] = $seriesData;
                        } elseif($escapedAttributeCode === 'type'){
                            $typeData = [
                                'attribute_code' => $escapedAttributeCode,
                                'label' => $escapedLabel,
                                'value' => [
                                    strip_tags($value->getAttributeText('type')),
                                    isset($matches2[1]) ? str_replace('.html', '', $matches2[1]) : '',
                                ]
                            ];
                            $escapedGroupData[] = $typeData;
                        } else {
                            $escapedGroupData[] = [
                                'attribute_code' => $escapedAttributeCode,
                                'label' => $escapedLabel,
                                'value' => $escapedValue,
                            ];
                        }
                    }

                    $escapedCustomAttributeArray[$escapedGroupLabel] = $escapedGroupData;
                }

                $customizableOptionsCollection = $this->customOptionRepository->getList($value->getSku());
                $productData['customizable_options'] = [];
                
                foreach ($customizableOptionsCollection as $data) {
                    $mainArray = [
                        'main_title' => $data->getTitle(),
                        'main_type' => $data->getType(),
                        'sub_options' => []
                    ];
                
                    if ($data->getType() === 'drop_down') {
                        $values = $data->getValues();
                        $subArray = [];
                        foreach ($values as $value) {
                            $subArray[] = [
                                'option_id' => $value->getOptionTypeId(),
                                'title' => $value->getTitle(),
                                'price' => $value->getPrice(),
                                'price_type' => $value->getPriceType(),
                                'sku' => $value->getSku(),
                                'qty' => $value->getQtyOption(),
                                'unit' => $value->getUnitOption()
                            ];
                        }
                        $mainArray['sub_options'] = $subArray;
                    }
                
                    $productData['customizable_options'][] = $mainArray;
                }                

                $productData['product_details']['Item Details'] = $escapedCustomAttributeArray;

                //$productData['other_products']['Buy it with'] = $relatedProducts;

                //$productData['other_products']['You may interested in'] = $alternativeProducts;

               // $productData['other_products']['Spare part'] = $spareSellProducts;

               // $productData['other_products']['Series Products'] = $seriesSellProducts;

               // $productData['other_products']['Sample Sell'] = $sampleSellProducts;

               // $productData['other_products']['Similar products'] = $upSellProducts;

              //  $productData['other_products']['Frequently bought together'] = $crossSellProducts;

                $downloads = [
                    'data_sheet' => $value->getDataSheet(),
                    'mounting_instruction' => $value->getMountingInstruction(),
                    'care_instructions' => $value->getCareInstructions()
                ];

                $productData['other_products']['_Downloads'] = $downloads;

                // for configurable product
                if ($value->getTypeId() == \Magento\Catalog\Model\Product\Type::TYPE_SIMPLE) {
                    $configProductId = $this->_productTypeConfigurable->getParentIdsByChild($value->getId());
                    if (!empty($configProductId[0])) {
                        $configProduct = $this->productRepository->getById($configProductId[0]);
                        $childProducts = $this->getChildProducts($configProduct);
                
                        $childProductDetails = [];
                        $childUrlKey = [];
                
                        foreach ($childProducts as $childProduct) {
                            $childAttributes = $this->getConfigurableOptionsByChildProductId($childProduct->getId(), $storeId);
                            $childUrlKey[] = $childProduct->getUrlKey();
                            $childProductDetails[] = $this->getChildData($childProduct, $productUrl, $childAttributes);
                        }
                
                        foreach ($childProductDetails as $childProductDetail) {
                            $childProductDetail['configurable_product_id'] = $configProductId[0];
                        }
                        $productData['child_products'] = $childProductDetails;
                    }
                }
                // code to add tiles specification information like unit, price
                // get product price unit group
                $cc =[];
                $priceUnitGroup = $value->getPriceUnitGroup();
				$priceUnitGroupArray=[];
                if(!empty($priceUnitGroup)){
                    $objectManager = \Magento\Framework\App\ObjectManager::getInstance(); // Instance of object manager
                    $resource = $objectManager->get('Magento\Framework\App\ResourceConnection');
                    $connection = $resource->getConnection();
                    $tableName = 'ag_price_unit_group'; 
                    $sql = "select title,unit_data,unit_calc_factor FROM " . $tableName ." WHERE status=1 and entity_id=".$priceUnitGroup;
                    $result = $connection->fetchRow($sql);

                    $priceUnitGroup = unserialize( $result['unit_data']);
                    $defaultUnitList = $this->scopeConfig->getValue('price_unit_group/general/unit_list',
                    \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
                    if(!empty($defaultUnitList)){
                        $defaultUnitListArray = explode(',',$defaultUnitList);
                        
                         $priceUnitGroupArray =[];
                         $priceUnitGroupArray['price-group'][] =[
                             'label' =>__('Price Group'),
                            'value' => $result['title']
                         ];
                         $priceUnitGroupArray['price-group-unit'][] =[
                             'label' =>__('Price Group Unit'),
                            'value' => $result['unit_calc_factor']
                         ];
                         
                        foreach($defaultUnitListArray as $priceunitvalue){
                            $priceUnitKey = str_replace(" ", "-", strtolower(trim($priceunitvalue)));
                            if(array_key_exists($priceUnitKey,$priceUnitGroup) ){
                                $priceUnitGroupArray[strtolower(str_replace("m²", "m2", $priceUnitKey))][]=[
                                'label' =>$priceunitvalue,
                                'value' => $priceUnitGroup[$priceUnitKey]
                            ];

                            }
                        }
                    }
                    //dd($priceUnitGroupArray);

                }
                $productData['price_unit_list']=$priceUnitGroupArray;
                /*[
                    //"unit_list"=>$priceUnitGroup,
                    //'unit_calc_factor' => $result['unit_calc_factor']
                ];*/

                $finalArray[] =  $productData;
            }

            $this->inlineTranslation->resume();

            if (empty($finalArray)) {
                throw new NoSuchEntityException();
            }

            return $finalArray;
        } catch (NoSuchEntityException $e) {
            throw $e;
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }

    protected function getProductData($product)
    {
        $productStock = $this->stockRegistry->getStockItem($product->getId());
        $showButtons = $this->customApisHelper->getButtonStatus($product);
        $layerImageOptionId = $product->getLayerImages();
		// Calculate price with VAT
		$taxClassId = $product->getTaxClassId();
		$store      = $this->storeManager->getStore();
		$request = $this->taxCalculation->getRateRequest(null, null, null, $store);
		$taxRate = $this->taxCalculation->getRate($request->setProductClassId($taxClassId));
		
		$otherPrice = $product->getPrice();
		$otherPrice = round($otherPrice, 2);
		$otherBasePrice = $otherPrice / 1.19;
		$otherPriceWithTax = $otherBasePrice + ($otherBasePrice * ($taxRate / 100));
		
		$otherMsrpPrice = $product->getMsrp();
		$otherMsrpBasePrice = $otherMsrpPrice / 1.19;
		$otherMsrpPriceWithTax = $otherMsrpBasePrice + ($otherMsrpBasePrice * ($taxRate / 100));
		
        return [
            'id' => $product->getId(),
            'sku' => $product->getSku(),
            'name' => $product->getName(),
            'qty' => $productStock->getQty(),
            'is_in_stock' =>$productStock->getIsInStock(),
            'image' => $product->getData('image'),
            'product_link' => $product->getUrlKey(),
            'msrp' => (string)$otherMsrpPriceWithTax,
            'price' => (string)$otherPriceWithTax,
            'product_avg_rating' => $this->customApisHelper->getAverageRating($product->getId()),
            'show_addtocart_button' => $showButtons,
            'layer_image' => $this->getLayerImagesPath($layerImageOptionId),
        ];
    }

    private function getLayerImagesPath($optionId)
    {
        if ($this->_imageHelper->getLayerImage($optionId)) {
            $imagePath = 'attributeoption/image/' . $this->_imageHelper->getLayerImage($optionId);
            return $imagePath;
        }else{
            return '';
        }
    }

    private function getConfigurableOptionsByChildProductId($childProductId, $storeId) {
        try {
            $childProduct = $this->productRepository->getById($childProductId);
            $parentIds = $this->configurable->getParentIdsByChild($childProductId);
            if (!empty($parentIds)) {
                $parentId = reset($parentIds);
                $parentProduct = $this->productRepository->getById($parentId);
                $options = [];
                $attributes = $parentProduct->getTypeInstance()->getConfigurableAttributes($parentProduct);
                foreach ($attributes as $attribute) {
                    $attributeLabel = $attribute->getProductAttribute()->getStoreLabel($storeId);
                    if (!$attributeLabel) {
                        $attributeLabel = $attribute->getLabel();
                    }
                    $optionValue = $childProduct->getAttributeText($attribute->getProductAttribute()->getAttributeCode());
                    $optionValue = strip_tags($optionValue);
                    $options[] = [
                        'label' => $attributeLabel,
                        'value' => $optionValue
                    ];
                }
                return [$options];
            } else {
                return [];
            }
        } catch (\Exception $e) {
            return [];
        }
    }
    
    protected function getChildData($product,$urlKey,$childAttributes){
        $selection = false;
        if($product->getUrlKey() == $urlKey){
            $selection = true;
        }

        $finalResponse = [
            'id' => $product->getId(),
            'sku' => $product->getSku(),
            'url_key' => $product->getUrlKey(),
            'default_select' => $selection,
            'attributes' => $childAttributes
        ];
        return $finalResponse;
    }

    private function getManufacturerImagePath($data)
    {
        if ($this->_imageHelper->getManufacturerImage($data)) {
            $imagePath = 'attributeoption/image/' . $this->_imageHelper->getManufacturerImage($data);
            return $this->storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA) . $imagePath;
        } else {
            return '';
        }
    }

    protected function getChildProducts($configurableProduct)
    {
        $childProducts = $configurableProduct->getTypeInstance()->getUsedProducts($configurableProduct);

        $enabledChildProducts = array_filter($childProducts, function ($childProduct) {
            return $childProduct->getStatus() == \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED;
        });

        return $enabledChildProducts;
    }

    protected function generateConfigData(\Magento\Catalog\Model\Product $parentProduct,\Magento\Catalog\Model\Product $currentProduct)
    {
        $typeInstance = $parentProduct->getTypeInstance();

        $configData = array();
        $attributes = $typeInstance->getUsedProductAttributes($parentProduct);

        foreach ($attributes as $code => $data) {
            $configData[$code] = $currentProduct->getData($data->getAttributeCode());
        }

        return $configData;
    }

    protected function getSelectedOptions(\Magento\Catalog\Model\Product $parentProduct,\Magento\Catalog\Model\Product $currentProduct)
    {
        /* @var $typeInstance Mage_Catalog_Model_Product_Type_Configurable */
        $typeInstance = $parentProduct->getTypeInstance();

        $configData = array();
        $attributes = $typeInstance->getUsedProductAttributes($parentProduct);

        foreach ($attributes as $code => $data) {
            $configData[$data->getAttributeCode()] = $currentProduct->getData($data->getAttributeCode());
        }

        return $configData;
    }
}