<?php

namespace Xtwo\ProductDetailApi\Helper;

use Magento\Catalog\Model\Product;
use Magento\Catalog\Model\CategoryRepository;
use Magento\Framework\UrlInterface;
use Xtwo\Catalog\Block\Product\ProductList\Alternativesell;
use Magento\Catalog\Model\CategoryFactory;
use Magento\Catalog\Model\ProductRepository;
use Magento\Store\Model\StoreManagerInterface;


class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var CategoryRepository
     */
    protected $categoryRepository;
    protected $categoryFactory;
    protected $productRepository;

    /**
     * @var UrlInterface
     */
    protected $urlInterface;
    protected $alternativesellBlock;
	protected $storeManager;

    /**
     * Data constructor.
     *
     * @param CategoryRepository $categoryRepository
     * @param UrlInterface $urlInterface
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        CategoryRepository $categoryRepository,
        UrlInterface $urlInterface,
        Alternativesell $alternativesellBlock,
        CategoryFactory $categoryFactory,
		StoreManagerInterface $storeManager,
        ProductRepository $productRepository
    ) {
        $this->categoryRepository = $categoryRepository;
        $this->urlInterface = $urlInterface;
        $this->alternativesellBlock = $alternativesellBlock;
        $this->categoryFactory = $categoryFactory;
        $this->productRepository = $productRepository;
		$this->storeManager = $storeManager;
    }

    public function getBreadcrumbByProductId($productId)
    {
        $store = $this->storeManager->getStore();
        $breadcrumb[] = [
            'label' => __('Home'),
            'title' => __('Home'),
            'link'  => '/'
        ];
        try {
            $product = $this->productRepository->getById($productId, false, $store->getId());  
            $categoryIds = $product->getCategoryIds();
            $defaultCategoryId = $store->getRootCategoryId();
    
            foreach ($categoryIds as $categoryId) {
                $category = $this->categoryRepository->get($categoryId, $store->getId());
                if ($category->getIsActive() && $category->getId() != $defaultCategoryId && $category->getLevel() > 1) {
                    $categoryPath = $this->buildCategoryPath($category);
                    
                    $breadcrumb[] = [
                        'label' => $category->getName(),
                        'title' => $category->getName(),
                        'link'  => $categoryPath
                    ];
                }
            }
            return $breadcrumb;
        } catch (NoSuchEntityException $e) {
            throw new NoSuchEntityException(__('Product not found.'));
        }
    }

    protected function buildCategoryPath($category)
    {
        $pathSegments = [];
        $currentCategory = $category;
        while ($currentCategory->getLevel() > 1) {
            array_unshift($pathSegments, $currentCategory->getUrlKey());
            $parentCategory = $currentCategory->getParentCategory();
            $currentCategory = $parentCategory;
        }
        $fullPath = 'category/' . implode('/', $pathSegments);
    
        return $fullPath;
    }    

    public function getCategoryBreadcrumb($categoryId)
    {
        $breadcrumb = [];
        if (is_array($categoryId)) {
            $category = $this->categoryFactory->create()->load($categoryId[0]);
        } else {
            $category = $this->categoryFactory->create()->load($categoryId);
        }
        
        if ($category->getParentId() != \Magento\Catalog\Model\Category::TREE_ROOT_ID) {
            $breadcrumb = $this->getCategoryBreadcrumb($category->getParentId());
        }
        if ($category->getUrlPath() == null) {
            $catLink = '/';
        } else {
            $catLink = 'category/' . $category->getUrlPath();
        }
        $breadcrumb[] = [
            'label' => $category->getName(),
            'title' => $category->getName(),
            'link' => $catLink
        ];
    
        return $breadcrumb;
    }    
}