define([
    'uiComponent',
    'jquery',
    'mage/url',
    'ko'
], function (Component, $, urlBuilder, ko) {
    return Component.extend({
        initialize: function () {
            this._super();
            var self = this;

            // Observe changes
            $('[name="product[price_unit_group]"]').on('change', function () {
                var groupId = $(this).val();
                alert(groupId);
                if (groupId) {
                    $.ajax({
                        url: urlBuilder.build('xtwo_priceunitgroup/group/info'), // Controller URL
                        data: { id: groupId },
                        success: function (response) {
                            $('#unit-group-extra-content').html(response.content || '');
                        }
                    });
                } else {
                    $('#unit-group-extra-content').empty();
                }
            });
        }
    });
});
