<?php
namespace Xtwo\Priceunitgroup\Model\Config\Source;

use Magento\Eav\Model\Entity\Attribute\Source\AbstractSource;
use Xtwo\Priceunitgroup\Model\ResourceModel\Group\CollectionFactory;

class PriceUnitGroup extends AbstractSource
{
    protected $collectionFactory;

    public function __construct(CollectionFactory $collectionFactory)
    {
        $this->collectionFactory = $collectionFactory;
    }

    public function getAllOptions()
    {
        if ($this->_options === null) {
            $options = [];
            $collection = $this->collectionFactory->create();
            foreach ($collection as $group) {
                $options[] = [
                    'label' => $group->getTitle(),
                    'value' => $group->getId(),
                ];
            }
            $this->_options = $options;
        }
        return $this->_options;
    }
}
