<?php

namespace Xtwo\Priceunitgroup\Controller\Adminhtml\Group;
use Magento\Framework\App\Filesystem\DirectoryList;
//set_time_limit (0);
//ini_set("max_execution_time", 7200);
//ini_set("max_input_time", 7200);
class Save extends \Magento\Backend\App\Action
{
    protected $_navSyncLogger;
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Xtwo\Priceunitgroup\Model\GroupFactory $groupFactory,
        \Magento\Backend\Model\Auth\Session $authSession,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,														
    ){
       $this->authSession = $authSession;
       $this->groupFactory = $groupFactory;
       $this->scopeConfig = $scopeConfig;
       parent::__construct($context);        
       
    }
    public function execute()
    {
        $data = $this->getRequest()->getPostValue();

       
        if (!$data) {
            $this->_redirect('priceunitgroup/group/index');
        }
         $entityId = isset($data['entity_id']) ? $data['entity_id'] : '';
        $rowData = $this->groupFactory->create()->load($entityId);  
        try {
           
            if (!$rowData->getEntityId() && $entityId) {
                $this->messageManager->addError(__('data no longer exist.'));
                $this->_redirect('priceunitgroup/group/index');
            }
            
            
           
             $defaultUnitList = $this->scopeConfig->getValue('price_unit_group/general/unit_list',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
            
             $defaultUnitListArray = explode(',',$defaultUnitList);
             $arrayL = [];
            foreach($defaultUnitListArray as $k=>$va){
                $kName = str_replace(" ", "-", strtolower(trim($va)));
                if(!empty($data[$kName.'_value'])){
                    $arrayL[$kName] = $data[$kName.'_value'];

                }
            }
           //    dd($arrayL);
            $data['unit_data']=serialize($arrayL);
             $rowData->setData($data);
            $rowData->save();
            //$this->_navSyncLogger->info('navsync created');
            $this->messageManager->addSuccess(__('data has been successfully saved.'));
        } catch (\Exception $e) {
            $this->messageManager->addError(__($e->getMessage()));
        }
        $this->_redirect('priceunitgroup/group/index');
    }
    /**
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Xtwo_Priceunitgroup::group');
    }
}