<?php

namespace Xtwo\Priceunitgroup\Controller\Adminhtml\Group;

use Xtwo\Priceunitgroup\Model\ResourceModel\Group\CollectionFactory;

/** 
 * MassDelete function 
 * 
*/

class MassDelete extends \Magento\Backend\App\Action
{

    protected $groupFactory;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Xtwo\Priceunitgroup\Model\GroupFactory $groupFactory,
        \Magento\Ui\Component\MassAction\Filter $filter,
        CollectionFactory $collectionFactory
        
    ){
       $this->groupFactory = $groupFactory;
       $this->filter = $filter;
       $this->collectionFactory = $collectionFactory;
       parent::__construct($context);
    }
    public function execute()
    {
        $data = $this->getRequest()->getPostValue();
        $collection = $this->filter->getCollection($this->collectionFactory->create());
        try {
            $count = 0;
            foreach ($collection as $item) {
                $item->delete();
                $count++;
            }
            $this->messageManager->addSuccess(__('A total of %1 record(s) have been deleted.', $count));
        } catch (\Exception $e) {
            $this->messageManager->addError(__($e->getMessage()));
        }
        $this->_redirect('priceunitgroup/group/index');
    }

    /**
     * @authorisation
     * return allowed | bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Xtwo_Priceunitgroup::group');
    }
}
