<?php
namespace Xtwo\Priceunitgroup\Controller\Adminhtml\Group;

use Magento\Backend\App\Action;
use Magento\Framework\Controller\Result\JsonFactory;
use Xtwo\Priceunitgroup\Model\ResourceModel\Group\CollectionFactory;

class Info extends Action
{
    protected $resultJsonFactory;
    protected $collectionFactory;

    public function __construct(
        Action\Context $context,
        JsonFactory $resultJsonFactory,
        CollectionFactory $collectionFactory
    ) {
        parent::__construct($context);
        $this->resultJsonFactory = $resultJsonFactory;
        $this->collectionFactory = $collectionFactory;
    }

    public function execute()
    {
        $result = $this->resultJsonFactory->create();
        $groupId = $this->getRequest()->getParam('id');

        $collection = $this->collectionFactory->create();
        $group = $collection->getItemById($groupId);

        $content = $group ? $group->getData('description') : '';

        return $result->setData(['content' => $content]);
    }
}
