<?php

namespace Xtwo\Priceunitgroup\Controller\Adminhtml\Group;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\View\Result\Page;
use Magento\Framework\View\Result\PageFactory;
use Xtwo\Priceunitgroup\Model\GroupFactory;

/**
 * edit controller
 * before save of dependency form
 */

class Edit extends Action
{
    /**
     * @var PageFactory
     */
    private $pageFactory;

    /**
     * @var groupFactory
     */
    protected $groupFactory;

    /**
     * @var \Magento\Framework\Registry
     */
    private $coreRegistry;

    /**
     * Edit constructor.
     * @param Context $context
     * @param PageFactory $rawFactory
     * @param productFactory $_reviewFactory
     * @param \Magento\Framework\Registry $coreRegistry
     */
    public function __construct(
        Context $context,
        PageFactory $rawFactory,
        GroupFactory $groupFactory,
        \Magento\Framework\Registry $coreRegistry
    )
    {
        $this->pageFactory = $rawFactory;
        $this->groupFactory = $groupFactory;
        $this->coreRegistry = $coreRegistry;
        parent::__construct($context);
    }


    /**
     * edit screen
     * @param null
     * @return Page
     */
    public function execute(): Page
    {
        $resultPage = $this->pageFactory->create();
        $resultPage->setActiveMenu('Magento_Catalog::catalog_products');
      $rowId = (int)$this->getRequest()->getParam('id');
     
        $rowData = '';

        if ($rowId) {

            $rowData = $this->groupFactory->create()->load($rowId);
            if (!$rowData->getId()) {
                $this->messageManager->addError(__('row data no longer exist.'));
                $this->_redirect('priceunitgroup/group/index');
            }
        }
        
        $this->coreRegistry->register('row_data', $rowData);

        $title = $rowId ? __('Edit Price Unit') : __('Add Price Unit');

        $resultPage->getConfig()->getTitle()->prepend($title);
        return $resultPage;
    }

    /**
     * isAllowed is permission function
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Xtwo_Priceunitgroup::group');
    }
}
