<?php
namespace Xtwo\Priceunitgroup\Controller\Adminhtml\Ajax;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;

class Content extends Action
{
    protected $resultJsonFactory;

    public function __construct(
        Context $context,
        JsonFactory $resultJsonFactory
    ) {
        parent::__construct($context);
        $this->resultJsonFactory = $resultJsonFactory;
    }

    public function execute()
    {
        $result = $this->resultJsonFactory->create();
        $value = $this->getRequest()->getParam('value');
        
        try {
            // Your logic to get content based on selected value
            $content = $this->getContentForValue($value);
            
            return $result->setData([
                'success' => true,
                'content' => $content
            ]);
        } catch (\Exception $e) {
            return $result->setData([
                'success' => false,
                'error_message' => $e->getMessage()
            ]);
        }
    }
    
    protected function getContentForValue($value)
    {
        // Implement your logic here to return content based on value
        switch ($value) {
            case 'option1':
                return 'Content for Option 1';
            case 'option2':
                return 'Content for Option 2';
            case 'option3':
                return 'Content for Option 3';
            default:
                return 'No content available for this option';
        }
    }
}