<?php

namespace Xtwo\Priceunitgroup\Block\Adminhtml\Group\Edit;

use Magento\Store\Model\System\Store;
class Form extends \Magento\Backend\Block\Widget\Form\Generic{
    protected $scopeConfig;

    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Data\FormFactory $formFactory,
        \Magento\Cms\Model\Wysiwyg\Config $wysiwygConfig,
        \Xtwo\Priceunitgroup\Model\Source\Status $status,
        Store $systemStore,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        array $data = []
    )
    {
        $this->_wysiwygConfig = $wysiwygConfig;
        $this->_status = $status;
        $this->systemStore = $systemStore;
        $this->scopeConfig = $scopeConfig;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    /**
     * @return Form
     * @throws \Magento\Framework\Exception\LocalizedException
     */

    protected function _prepareForm(){
        $model = $this->_coreRegistry->registry('row_data');

        $form = $this->_formFactory->create([
            'data' => [
                'id' => 'edit_form', 
                'enctype' => 'multipart/form-data', 
                'action' => $this->getData('action'), 
                'method' => 'post'
            ]
        ]);
        $defaultUnitList = $this->scopeConfig->getValue('price_unit_group/general/unit_list',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE);

            //dd($defaultUnitList);
        if ($model) {
            $fieldset = $form->addFieldset('base_fieldset', [
                'legend' => __('Price Unit Group Details'), 
                'class' => 'fieldset-wide']
            );
            $fieldset->addField('entity_id', 'hidden', [
                'name' => 'entity_id',
                "value" => 1]);
        } else {
            $fieldset = $form->addFieldset('base_fieldset', [
                'legend' => __('Price Unit Group Details'), 
                'class' => 'fieldset-wide']);
        }

        $fieldset->addField('title', 'text', [
            'name'     => 'title',
            'label'    => __('Price Unit Group Name'),
            'title'    => __('Price Unit Group Name'),
            'value'    => '',
            'required' => true
        ]);
        $fieldset->addField('status', 'select',
            [
                'name' => 'status',
                'label' => __('Status'),
                'title' => __('Status'),
                'required' => false,
                'value' => 1,
                'values' => [
                    ['value' => 1, 'label' => __('Enabled')],
                    ['value' => 2, 'label' => __('Disabled')],
                    
                ],
        ]);
        $fieldset->addField(
            'unit_calc_factor',
            'radios',
            [
                'name' => 'unit_calc_factor',
                'label' => __('Select Option'),
                'title' => __('Select Option'),
                'required' => true,
                'value' => 'sqm', // Default selected value
                'values' => [
                    ['value' => 'sqm', 'label' => __('SQ Meter')],
                    ['value' => 'piece', 'label' => __('Piece')],
                ]
            ]
        );
        $form->setValues($model ? $model->getData() : '');
       $fillData  = ($model ?$model->getData()['unit_data']:'');
       if(!empty($fillData)){
                 $FilledUnitArray=unserialize($fillData);
       }

        if(!empty($defaultUnitList)){
            $defaultUnitListArray = explode(',',$defaultUnitList);
            $fieldsett = $form->addFieldset('key_value_base_fieldset', [
                    'legend' => __('Unit/Value'), 
                ]
                );
                $arr =[];
            foreach($defaultUnitListArray as $k=>$ff){
            $keyName = str_replace(" ", "-", strtolower(trim($ff)));
               //exit;
            $arr[$keyName]= [];
            $fvale ='';
            if(!empty($FilledUnitArray) && array_key_exists($keyName,$FilledUnitArray)){
                $fvale= $FilledUnitArray[$keyName];
            }
            
            $fieldsett->addField($keyName.'_value', 'text', [
                    'name'     => $keyName.'_value',
                    'label'    => __($keyName)." Value",
                    'title'    => __($ff)." Value",
                    'value'    => $fvale,
                    'style' => 'width:48%;float:left;margin-right:4%;',
                ]);

            }
        }
        
       
        
        $form->setUseContainer(true);
        $this->setForm($form);
        return parent::_prepareForm();
    }
    
}