define([
    'jquery',
    'Magento_Ui/js/lib/validation/utils'
], function ($, utils) {
    'use strict';

    return function (validator) {

        // override new rule to old one
        validator.addRule(
            'validate-zero-or-greater',
            function (value, params, additionalParams) {
				console.log('working');
                if (utils.isEmptyNoTrim(value)) {
                    return true;
                }
                value = utils.parseNumber(value);

                return !isNaN(value) && value >= 0;

            },
            $.mage.__('Please enter a number 0 or greater in this field.')
        );

        return validator;
    };
});