<?php
namespace Xtwo\PayonePostgateway\Model;


use Xtwo\PayonePostgateway\Api\TransactionstatusInterface;
use Magento\Sales\Model\Order;
use Magento\Framework\App\RequestInterface;
use Xtwo\PayonePostgateway\Logger\Logger;


/**
 * PayonePayment API implementation.
 */
class Transactionstatus implements TransactionstatusInterface 
{
	protected $logger;
	protected $request;
	/**
     * TransactionStatus model
     *
     * @var \Payone\Core\Model\ResourceModel\TransactionStatus
     */
    protected $transactionStatus;

    /**
     * PAYONE toolkit helper
     *
     * @var \Payone\Core\Helper\Toolkit
     */
    protected $toolkitHelper;

    /**
     * PAYONE environment helper
     *
     * @var \Payone\Core\Helper\Environment
     */
    protected $environmentHelper;

    /**
     * PAYONE order helper
     *
     * @var \Payone\Core\Helper\Order
     */
    protected $orderHelper;

    /**
     * TransactionStatus handler
     *
     * @var \Payone\Core\Model\Handler\TransactionStatus
     */
    protected $transactionStatusHandler;

    /**
     * Result factory for file-download
     *
     * @var \Magento\Framework\Controller\Result\RawFactory
     */
    protected $resultRawFactory;

    /**
     * PAYONE substitute order handler
     *
     * @var \Payone\Core\Model\Handler\SubstituteOrder
     */
    protected $substituteOrder;
	
	protected $order;

    /**
     * Constructor
     *
     * @param \Magento\Framework\App\Action\Context              $context
     * @param \Magento\Framework\Data\Form\FormKey               $formKey
     * @param \Payone\Core\Model\ResourceModel\TransactionStatus $transactionStatus
     * @param \Payone\Core\Helper\Toolkit                        $toolkitHelper
     * @param \Payone\Core\Helper\Environment                    $environmentHelper
     * @param \Payone\Core\Helper\Order                          $orderHelper
     * @param \Payone\Core\Model\Handler\TransactionStatus       $transactionStatusHandler,
     * @param \Magento\Framework\Controller\Result\RawFactory    $resultRawFactory
     * @param \Payone\Core\Model\Handler\SubstituteOrder         $substituteOrder
     */
    public function __construct(
        \Magento\Framework\App\Action\Context $context,
		RequestInterface $request,
        \Payone\Core\Model\ResourceModel\TransactionStatus $transactionStatus,
        \Payone\Core\Helper\Toolkit $toolkitHelper,
        \Payone\Core\Helper\Environment $environmentHelper,
        \Payone\Core\Helper\Order $orderHelper,
        \Payone\Core\Model\Handler\TransactionStatus $transactionStatusHandler,
        \Magento\Framework\Controller\Result\RawFactory $resultRawFactory,
        \Payone\Core\Model\Handler\SubstituteOrder $substituteOrder,
		Logger $logger,
		Order $order,
		\Xtwo\Buyerprotect\Model\Service\Soap\Data $soapdata,
		\Xtwo\Buyerprotect\Helper\Data $helper
    ) {
		$this->request = $request;
        $this->transactionStatus = $transactionStatus;
        $this->toolkitHelper = $toolkitHelper;
        $this->environmentHelper = $environmentHelper;
        $this->orderHelper = $orderHelper;
        $this->transactionStatusHandler = $transactionStatusHandler;
        $this->resultRawFactory = $resultRawFactory;
        $this->substituteOrder = $substituteOrder;
		$this->logger = $logger;
		$this->order = $order;
		$this->_soapdata = $soapdata;
		$this->_helper = $helper;
    }

    /**
     * Return request parameter value
     *
     * @param  string $sKey
     * @return string
     */
    protected function getParam($sKey)
    {
		this->logger->info('getParam');
        return $this->request->getParam($sKey, '');
    }

    /**
     * Return Post array
     *
     * @return array
     */
    protected function getPostArray()
    {
		$this->logger->info('getPostArray');
        return $this->request->getPostValue();
    }

    /**
     * Write the TransactionStatus to the database
     *
     * @param  Order $oOrder
     * @param  array $aRequest
     * @param  bool  $blWillBeHandled
     * @return void
     */
    protected function logTransactionStatus(Order $oOrder = null, $aRequest, $blWillBeHandled)
    {
		$this->logger->info('inside func logTransactionStatus');
        $this->transactionStatus->addTransactionLogEntry($aRequest, $oOrder, $blWillBeHandled);
    }
	
	protected function _requestV2(\Xtwo\Buyerprotect\Model\Service\Soap\Data $buyerprotectModul)
	{   
	
		$helper = $this->_helper;
		$wsdl = $helper->getWsdlUrl('backend');
			
		/*if (!$tsId) {echo "4444";
			$tsId = $helper->getTsUserId();
		}*/
		
		$soapClient = new \SoapClient($buyerprotectModul->getWsdlUrl('frontend'));

		$this->_requestErrorCode = $soapClient->requestForProtectionV2(
			$buyerprotectModul->getTsId(),
			$buyerprotectModul->getTsProductId(),
			$buyerprotectModul->getAmount(),
			$buyerprotectModul->getCurrency(),
			$buyerprotectModul->getPaymentType(),
			$buyerprotectModul->getBuyerEmail(),
			$buyerprotectModul->getShopCustomerId(),
			$buyerprotectModul->getShopOrderId(),
			$buyerprotectModul->getOrderDate(),
			$buyerprotectModul->getShopSystemVersion(),
			$buyerprotectModul->getWsUser(),
			$buyerprotectModul->getWsPassword()
		);
	
		return;
	}

    /**
     * Main method for executing all needed actions for the incoming TransactionStatus
     *
     * @return string
     */
    protected function handleTransactionStatus($data)
    {
		//print_r($data);
		$this->logger->info('inside func handleTransactionStatus');
		$this->logger->info('data array in handleTransactionStatus: => '.print_r($data,true));
		$oOrder = $this->orderHelper->getOrderByTxid($data['txid']);
			if (!$oOrder) 
			{
				return 'Order not found';
				$this->logger->info('Order not found');
			}
		 
			if ($data['txaction'] == 'appointed' && $oOrder->getStatus() == 'canceled') 
			{
				// order was canceled in checkout, probably due to browser-back-button usage -> create a new order for incoming payment
				$oOrder = $this->substituteOrder->createSubstituteOrder($oOrder, false);
				$this->logger->info('reate a new order for incoming payment');
			}
			if ($data['txaction'] == 'paid') 
			{
				$order = $this->order->loadByIncrementId($data['reference']);
				$this->logger->info('Cart data TS shop Start.');
				$orderItemsCollection = clone $order->getItemsCollection();
				$orderItemsCollection->addFieldToFilter('product_type', 'buyerprotect');
					if ($orderItemsCollection->count() >= 1) 
					{
						$this->logger->info('inside orderItemsCollection count.');
						$tsItem = null;
						foreach ($orderItemsCollection->getItems() as $item) 
						{
							$tsItem = $item;
							//print_r($tsItem->getData());
							$this->logger->info('Cart data TS shop=> '.print_r($tsItem->getData(),true));
						}
							$this->logger->info('product type=> '.print_r($tsItem->getProductType(),true));
							
							if($tsItem->getProductType() == 'buyerprotect')
							{
								//$this->checkIfTsItemIsSet($tsItem);
								$tsSoapDataObject = $this->_soapdata;
								//$tsSoapDataObject = $formatedTsSoapData;
								// have doubt on init funcion here
								$tsSoapDataObject->init($order, $tsItem);
								//print_r($tsSoapDataObject->getData());
								$this->logger->info('SOAP Object request=> '.print_r($tsSoapDataObject->getData(),true));
								if ($tsSoapDataObject->isActive()) 
								{
									try {
									//echo "test111"; print_r($tsSoapDataObject->getData());
									$this->_requestV2($tsSoapDataObject);
									//$this->logger->log(0, 'SOAP return value: '.$this->_requestErrorCode);
									//$this->logger->log(0, 'SOAP request successful.');
									$this->logger->info('SOAP return value: '.print_r($this->_requestErrorCode,true));
									$this->logger->info('SOAP request successful.');
									
									} catch (SoapFault $soapFault) {
									$this->_requestErrorCode = self::TS_SOAP_EXCEPTION_CODE;
									//$this->logger->log(0, 'SOAP request failed! See exception log!');
									$this->logger->info('SOAP request failed! See exception log!');
									$this->logger->critical($soapFault);
									}
									
									//$this->logger->log(0, implode(" ",$tsSoapDataObject->getTsSoapData()));
									$this->logger->info('SOAP return value: '.print_r(implode(" ",$tsSoapDataObject->getTsSoapData()),true));
								}
							}
					}
					
					$this->logger->info('No TS product in cart.');
					$this->logger->info('Cart data TS shop End.');
			}
				//$this->logger->info('for Request=> '.print_r($oOrder->getData(),true));
				$this->logTransactionStatus($oOrder, $data, true);
		 
				$this->transactionStatusHandler->handle($oOrder, $data);
				//$this->logger->info('for Request=> '.print_r($oOrder->getData(),true).' for Response=> '.print_r($data,true).'33333');
				$this->logger->info('TSOK');
				return 'TSOK';
    }

    /**
     * Executing TransactionStatus handling
     *
     * @return \Magento\Framework\Controller\Result\Raw
     */
    
	public function execute($data)
    {			
		//echo "asfa";exit;
		$this->logger->info('inside func execute');
		$this->logger->info('execute before handleTransactionStatus=> '.print_r($data,true).'44444');
		$sOutput = $this->handleTransactionStatus($data);

		//$oResultRaw = $this->resultRawFactory->create();
		//$oResultRaw->setContents($sOutput);
		$this->logger->info('execute after handleTransactionStatus=> '.print_r($data,true).'55555');
		return $sOutput;
    }
	
}