<?php

namespace Xtwo\PayonePostgateway\Model;

use Xtwo\PayonePostgateway\Api\EmailSenderInterface;
use Magento\Sales\Model\Order;
use Magento\Framework\Exception\NoSuchEntityException;
use Xtwo\PayonePostgateway\Logger\Logger;

class EmailSender implements EmailSenderInterface
{
    protected $order;
    protected $logger;

    public function __construct(

        Order $order,
        Logger $logger,
		\Xtwo\Buyerprotect\Model\Service\Soap\Data $soapdata,
		\Xtwo\Buyerprotect\Helper\Data $helper
    ) {

        $this->order = $order;
        $this->logger = $logger;
		$this->_soapdata = $soapdata;
		$this->_helper = $helper;
   
    }
	
	protected function _requestV2(\Xtwo\Buyerprotect\Model\Service\Soap\Data $buyerprotectModul)
		{   
		
			$helper = $this->_helper;
			$wsdl = $helper->getWsdlUrl('backend');
				
			/*if (!$tsId) {echo "4444";
				$tsId = $helper->getTsUserId();
			}*/
		 	
			$soapClient = new \SoapClient($buyerprotectModul->getWsdlUrl('frontend'));

			$this->_requestErrorCode = $soapClient->requestForProtectionV2(
				$buyerprotectModul->getTsId(),
				$buyerprotectModul->getTsProductId(),
				$buyerprotectModul->getAmount(),
				$buyerprotectModul->getCurrency(),
				$buyerprotectModul->getPaymentType(),
				$buyerprotectModul->getBuyerEmail(),
				$buyerprotectModul->getShopCustomerId(),
				$buyerprotectModul->getShopOrderId(),
				$buyerprotectModul->getOrderDate(),
				$buyerprotectModul->getShopSystemVersion(),
				$buyerprotectModul->getWsUser(),
				$buyerprotectModul->getWsPassword()
			);
		
			return;
		}

    public function sendOrderEmail($orderIncrementId)
    {
        try {
			

            $order = $this->order->loadByIncrementId($orderIncrementId);
			if (!$order->getPayoneTransactionStatus() || $order->getPayoneTransactionStatus() !== "paid") {
                throw new NoSuchEntityException(__('No "paid" entry found for order ID "%1".', $orderIncrementId));
            }

			if($order->getPayoneTransactionStatus() == "paid"){
				$this->logger->info('Cart data TS shop Start.');
				$orderItemsCollection = clone $order->getItemsCollection(); 
				$orderItemsCollection->addFieldToFilter('product_type', array('eq' => 'buyerprotect'));
				
				if ($orderItemsCollection->count() >= 1) {
					$tsItem = null;  
					foreach ($orderItemsCollection->getItems() as $item) {
					  
							$tsItem = $item;
							//print_r($tsItem->getData());
							$this->logger->info('Cart data TS shop=> '.print_r($tsItem->getData(),true));
			   
					}
					//$this->checkIfTsItemIsSet($tsItem);
					$tsSoapDataObject = $this->_soapdata;
					//$tsSoapDataObject = $formatedTsSoapData;
					// have doubt on init funcion here
					$tsSoapDataObject->init($order, $tsItem);
					//print_r($tsSoapDataObject->getData());
					$this->logger->info('SOAP Object request=> '.print_r($tsSoapDataObject->getData(),true));
					if ($tsSoapDataObject->isActive()) {
					
						try {
							//echo "test111"; print_r($tsSoapDataObject->getData());
							$this->_requestV2($tsSoapDataObject);
						   //$this->logger->log(0, 'SOAP return value: '.$this->_requestErrorCode);
							//$this->logger->log(0, 'SOAP request successful.');
							$this->logger->info('SOAP return value: '.print_r($this->_requestErrorCode,true));
							$this->logger->info('SOAP request successful.');
							
						} catch (SoapFault $soapFault) {
							$this->_requestErrorCode = self::TS_SOAP_EXCEPTION_CODE;
							//$this->logger->log(0, 'SOAP request failed! See exception log!');
							$this->logger->info('SOAP request failed! See exception log!');
							$this->logger->critical($soapFault);
						} 
						
						//$this->logger->log(0, implode(" ",$tsSoapDataObject->getTsSoapData()));
						$this->logger->info('SOAP return value: '.print_r(implode(" ",$tsSoapDataObject->getTsSoapData()),true));
					}
				}
				
				$this->logger->info('Cart data TS shop End.');
			}
		
           return true;
        } catch (\Exception $e) {
            $this->logger->error('Error sending  TS SHOP confirmation email: ' . $e->getMessage());
            return false;
        }
    }
}
