<?php
/**
 * Copyright © 2015 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Xtwo\Orderexport\Controller\Adminhtml\Order;

//use Magento\Framework\Model\Resource\Db\Collection\AbstractCollection;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;
use Magento\Backend\App\Action\Context;
use Magento\Sales\Model\ResourceModel\Order\CollectionFactory;
use Magento\Ui\Component\MassAction\Filter;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\App\DeploymentConfig;
use Magento\Framework\Config\ConfigOptionsListConstants;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Sales\Api\CreditmemoRepositoryInterface;
use Magento\Framework\Api\SearchCriteriaBuilder;

class MassExport extends \Magento\Sales\Controller\Adminhtml\Order\AbstractMassAction
{
  const ENCLOSURE = '"';
  const DELIMITER = ',';

  protected $_directoryList;
  public $_resource;
  private $deploymentConfig;
  private $objectManager;
  /**
     * @var CreditmemoRepositoryInterface
     */
    private $creditmemoRepository;

  public function __construct(
    Context $context,
    ResourceConnection $resource,
    Filter $filter,
    CollectionFactory $collectionFactory,
    DeploymentConfig $deploymentConfig,
    DirectoryList $directory_list,
    CreditmemoRepositoryInterface $creditmemoRepository,
    SearchCriteriaBuilder $searchCriteriaBuilder,
    ){

    $this->_resource = $resource;
    parent::__construct($context , $filter);
    $this->deploymentConfig = $deploymentConfig;
    $this->collectionFactory = $collectionFactory;
    $this->_directoryList = $directory_list;
    $this->creditmemoRepository = $creditmemoRepository;
    $this->searchCriteriaBuilder = $searchCriteriaBuilder;
	$this->objectManager = \Magento\Framework\App\ObjectManager::getInstance();

  }
    /**
     * Cancel selected orders
     *
     * @param AbstractCollection $collection
     * @return \Magento\Backend\Model\View\Result\Redirect
     */
    protected function massAction(AbstractCollection $collection)
    {

        if (!file_exists($this->_directoryList->getRoot().'/pub/media/orderexport')) {
            mkdir($this->_directoryList->getRoot().'/pub/media/orderexport', 0777, true);
        }

        $todayDate = date('Y_m_d_H_i_s', time());
        $fileName = $this->_directoryList->getRoot().'/pub/media/orderexport/orderexport'.$todayDate.'.csv';


        $fp = fopen($fileName, 'w');
		$this->writeHeadRow($fp);

		$countOrderExport = 0;
        foreach ($collection->getItems() as $_order) {

          $orderId = $_order->getId();
          if ($orderId) {
			$order = $this->objectManager->create('\Magento\Sales\Model\Order')->load($_order->getId());
            $this->writeOrder($order, $fp);
            $incId = $order->getIncrementId();
			$countOrderExport++;
          }
        }
		fclose($fp);

        $this->downloadCsv($fileName);
        $this->messageManager->addSuccess(__('We Exported %1 order(s).', $countOrderExport));

        //$resultRedirect = $this->resultRedirectFactory->create();
        //$resultRedirect->setPath('sales/*/');
        //return $resultRedirect;
    }


    public function downloadCsv($file)
    {

        if (file_exists($file)) {
            //set appropriate headers
            header('Content-Description: File Transfer');
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename='.basename($file));
            header('Expires: 0');
            header('Cache-Control: must-revalidate');
            header('Pragma: public');
            header('Content-Length: ' . filesize($file));
            ob_clean();flush();
            readfile($file);
        }
    }

	protected function writeHeadRow($fp)
    {
        fputcsv($fp, $this->newHeadValues(), self::DELIMITER, self::ENCLOSURE);
    }
	protected function newHeadValues(){
	 return array_merge(
            array(
                "order_id",
                "email",
                "firstname",
                "lastname",
                "prefix",
                "middlename",
                "suffix",
                "taxvat",
                "created_at",
                "updated_at",
                "invoice_created_at",
                "shipment_created_at",
                "creditmemo_created_at",
                "tax_amount",
                "base_tax_amount",
                "discount_amount",
                "base_discount_amount",
                "shipping_tax_amount",
                "base_shipping_tax_amount",
                "base_to_global_rate",
                "base_to_order_rate",
                "store_to_base_rate",
                "store_to_order_rate",
                "subtotal_incl_tax",
                "base_subtotal_incl_tax",
                "coupon_code",
                "shipping_incl_tax",
                "base_shipping_incl_tax",
                "shipping_method",
                "shipping_amount",
                "subtotal",
                "base_subtotal",
                "grand_total",
                "base_grand_total",
                "base_shipping_amount",
                "adjustment_positive",
                "adjustment_negative",
                "refunded_shipping_amount",
                "base_refunded_shipping_amount",
                "refunded_subtotal",
                "base_refunded_subtotal",
                "refunded_tax_amount",
                "base_refunded_tax_amount",
                "refunded_discount_amount",
                "base_refunded_discount_amount",
                "store_id",
                "order_status",
                "order_state",
                "hold_before_state",
                "hold_before_status",
                "store_currency_code",
                "base_currency_code",
                "order_currency_code",
                "total_paid",
                "base_total_paid",
                "is_virtual",
                "total_qty_ordered",
                "remote_ip",
                "total_refunded",
                "base_total_refunded",
                "total_canceled",
                "total_invoiced",
                "customer_id",
                "billing_prefix",
                "billing_firstname",
                "billing_middlename",
                "billing_lastname",
                "billing_suffix",
                "billing_street_full",
                "billing_city",
                "billing_region",
                "billing_country",
                "billing_postcode",
                "billing_telephone",
                "billing_company",
                "billing_fax",
                "billing_vat_id",
                "customer_id",
                "shipping_prefix",
                "shipping_firstname",
                "shipping_middlename",
                "shipping_lastname",
                "shipping_suffix",
                "shipping_street_full",
                "shipping_city",
                "shipping_region",
                "shipping_country",
                "shipping_postcode",
                "shipping_telephone",
                "shipping_company",
                "shipping_fax",
                "shipping_vat_id",
                "payment_method",
                'payment_multifees_amount',
                'payment_base_multifees_amount',
                'payment_multifees_tax_amount',
                'payment_base_multifees_tax_amount',
            ),
            static::getTaxInfoFields('payment_'),
            array(
                "product_id",
                "product_sku",
                "product_name",
                "qty_ordered",
                "qty_invoiced",
                "qty_shipped",
                "qty_refunded",
                "qty_canceled",
                "product_type",
                "original_price",
                "base_original_price",
                "row_total",
                "base_row_total",
                "row_weight",
                "price_incl_tax",
                "base_price_incl_tax",
                "product_tax_amount",
                "product_base_tax_amount",
                "product_tax_percent",
                "product_discount",
                "product_base_discount",
                "product_discount_percent",
                "is_child",
                "product_option",
            )
        );
	}

	protected function writeOrder($order, $fp)
    {
        $common = $this->getCommonOrderValues($order);
        $blank = $this->getBlankOrderValues($order);
        $orderItems = $order->getAllVisibleItems();
        $itemInc = 0;
		$item = "";
        $count = 0;
        foreach ($orderItems as $item)
        {
            if ($count == 0)  {
                $record = array_merge($common, $this->getOrderItemValues($item, $order, ++$itemInc));
                fputcsv($fp, $record, self::DELIMITER, self::ENCLOSURE);
            }else {
                $record = array_merge($blank, $this->getOrderItemValues($item, $order, ++$itemInc));
                fputcsv($fp, $record, self::DELIMITER, self::ENCLOSURE);
            }
            $count++;
        }

    }

	protected function getCommonOrderValues($order)
    {
		$shippingAddress = !$order->getIsVirtual() ? $order->getShippingAddress() : null;
		$billingAddress = $order->getBillingAddress();
        $credit_detail = $this->getCreditMemoByOrderId($order->getId());
        
		$payment = $order->getPayment();
		$method = $payment->getMethodInstance();
		$methodTitle = $method->getTitle();
		$total_item_qty = $this->getTotalQtyItemsOrdered($order);
        
		$priceHelper = $this->objectManager->create('Magento\Framework\Pricing\Helper\Data');
		$objDate = $this->objectManager->create('Magento\Framework\Stdlib\DateTime\TimezoneInterface');
		$country_name = $this->objectManager->create('\Magento\Directory\Model\Country');

        $connection = $this->_resource->getConnection();  
        $data = array(
            $order->getIncrementId(),
			$order->getData('customer_email'),
			$order->getData('customer_firstname') ?? $order->getBillingAddress()->getData('firstname'),
			$order->getData('customer_lastname') ?? $order->getBillingAddress()->getData('lastname'),
			$order->getData('customer_prefix'),
			$order->getData('customer_middlename'),
			$order->getData('customer_suffix'),
			$order->getData('customer_taxvat'),
            $order->getData('created_at'),
            $order->getData('updated_at'),
            $this->getInvoiceDate($order),
            $this->getShipmentDate($order),
            $this->getCreditmemoDate($order),
			$order->getData('tax_amount'),
			$order->getData('base_tax_amount'),
            $order->getData('discount_amount'),
            $order->getData('base_discount_amount'),
            $order->getData('shipping_tax_amount'),
            $order->getData('base_shipping_tax_amount'),
            $order->getData('base_to_global_rate'),
            $order->getData('base_to_order_rate'),
            $order->getData('store_to_base_rate'),
            $order->getData('store_to_order_rate'),
            $order->getData('subtotal_incl_tax'),
            $order->getData('base_subtotal_incl_tax'),
            $order->getData('coupon_code'),
            $order->getData('shipping_incl_tax'),
            $order->getData('base_shipping_incl_tax'),
			$this->getShippingMethod($order),
			$order->getData('shipping_amount'),
            $order->getData('subtotal'),
            $order->getData('base_subtotal'),
            $order->getData('grand_total'),
            $order->getData('base_grand_total'),
            $order->getData('base_shipping_amount'),
            $credit_detail['adjustment_positive'],
            $credit_detail['adjustment_negative'],
            $credit_detail['shipping_amount'],
            $credit_detail['base_shipping_amount'],
            $credit_detail['subtotal'],
            $credit_detail['base_subtotal'],
            $credit_detail['tax_amount'],
            $credit_detail['base_tax_amount'],
            $credit_detail['discount_amount'],
            $credit_detail['base_discount_amount'],
            $order->getData('store_id'),
            $order->getStatus(),
			$order->getState(),
            $order->getHoldBeforeState(),
            $order->getHoldBeforeStatus(),
			$order->getData('store_currency_code'),
            $order->getData('base_currency_code'),
            $order->getData('order_currency_code'),
            $order->getData('total_paid'),
            $order->getData('base_total_paid'),
            $order->getData('is_virtual'),
            $order->getData('total_qty_ordered'),
            $order->getData('remote_ip'),
            $order->getData('total_refunded'),
            $order->getData('base_total_refunded'),
            $order->getData('total_canceled'),
            $order->getData('total_invoiced'),
            $order->getData('customer_id'),
            //$order->getData('store_name'),
			$order->getBillingAddress()->getData('prefix'),
			$order->getBillingAddress()->getData('firstname'),
			$order->getBillingAddress()->getData('middlename'),
			$order->getBillingAddress()->getData('lastname'),
			$order->getBillingAddress()->getData('suffix'),
			$order->getBillingAddress()->getData('street'),
			$order->getBillingAddress()->getData('city'),
			$order->getBillingAddress()->getData('region'),
			$order->getBillingAddress()->getData('country_id'),
			$order->getBillingAddress()->getData('postcode'),
            $order->getBillingAddress()->getData('telephone'),
			$order->getBillingAddress()->getData('company'),
			$order->getBillingAddress()->getData('fax'),
			$order->getBillingAddress()->getData('vat_id'),
			$order->getData('customer_id'),
			$shippingAddress ? $shippingAddress->getData('prefix') : '',
			$shippingAddress ? $shippingAddress->getData('firstname') : '',
			$shippingAddress ? $shippingAddress->getData('middlename') : '',
			$shippingAddress ? $shippingAddress->getData('lastname') : '',
			$shippingAddress ? $shippingAddress->getData('suffix') : '',
			$shippingAddress ? $shippingAddress->getData('street') : '',
			$shippingAddress ? $shippingAddress->getData('city') : '',
			$shippingAddress ? $shippingAddress->getData('region') : '',
			$shippingAddress ? $shippingAddress->getData('country_id') : '',
			$shippingAddress ? $shippingAddress->getData('postcode') : '',
			$shippingAddress ? $shippingAddress->getData('telephone') : '',
			$shippingAddress ? $shippingAddress->getData('company') : '',
			$shippingAddress ? $shippingAddress->getData('fax') : '',
			$shippingAddress ? $shippingAddress->getData('vat_id') : '',
			$payment->getMethod(),
			$order->getData('multifees_amount'),
            $order->getData('base_multifees_amount'),
            $order->getData('multifees_tax_amount'),
            $order->getData('base_multifees_tax_amount'),
        );

        $taxInfoFields = static::getTaxInfoFields();
        $table   = $connection->getTableName('sales_order_tax');
        $taxInfo = $connection->fetchAll('SELECT * FROM ' . $table . ' WHERE order_id=? LIMIT 1', array($order->getId()));
        foreach ($taxInfoFields as $field) {
            if($field=='hidden'){
                $data[] = 0;
            }else{
                if ('items' !== $field) {
                    $data[] = empty($taxInfo) ? null : $taxInfo[0][$field];
                }
            }
            
        }
        // get tax info items too
        $taxInfoItems = array();
        if (!empty($taxInfo)) {
            $sql = 'SELECT fi.product_id, ti.tax_percent FROM ' . $connection->getTableName('sales_order_item') . ' AS fi ' .
                'LEFT JOIN ' . $connection->getTableName('sales_order_tax_item') . ' AS ti ' .
                'ON fi.item_id = ti.item_id ' .
                'WHERE fi.order_id=? AND ti.tax_id=?';
            $taxInfoItems = $connection->fetchAll($sql, array($order->getId(), $taxInfo[0]['tax_id']));
        }
        $data[] = json_encode($taxInfoItems, JSON_FORCE_OBJECT);

        return $data;

    }

	protected function getOrderItemValues($item, $order, $itemInc=1)
    {
		$custom_option = "";
		if($item->hasProductOptions()){
			if (array_key_exists("options",$item->getData('product_options'))){
				$option_coll = $item->getData('product_options')['options'];
				foreach ($option_coll as $cptions) {
					$custom_option .= strip_tags($cptions['label']).";";
				}
			}
		}
        return array(
            $item->getProduct()->getEntityId(),
            $item->getSku(),
			$item->getName(),
            (int)$item->getQtyOrdered(),
            (int)$item->getQtyInvoiced(),
            (int)$item->getQtyShipped(),
            (int)$item->getQtyRefunded(),
            (int)$item->getQtyCanceled(),
			$item->getProductType(),
            $item->getOriginalPrice(),
            $item->getBaseOriginalPrice(),
            $item->getRowTotal(),
            $item->getBaseRowTotal(),
            $item->getRowWeight(),
            $item->getPriceInclTax(),
            $item->getBasePriceInclTax(),
            $item->getTaxAmount(),
            $item->getBaseTaxAmount(),
            $item->getTaxPercent(),
            $item->getDiscountAmount(),
            $item->getBaseDiscountAmount(),
            $item->getDiscountPercent(),
            $item->getParentItemId()? 'yes': 'no',
            serialize($item->getData('product_options'))


            
        );

    }

	protected function getTotalQtyItemsOrdered($order)
	{

        $qty = 0;

        $orderedItems = $order->getAllVisibleItems();
        foreach ($orderedItems as $qitem)
        {
                $qty += (int)$qitem->getQtyOrdered();
        }

        return $qty;

    }

    public static function getTaxInfoFields($prefix = '')
    {
        $fields = array('code', 'title', 'percent', 'amount', 'priority', 'position', 'base_amount', 'process', 'base_real_amount', 'hidden', 'items');
        $return = array();
        foreach ($fields as $field) {
            $return[] = $prefix . $field;
        }
        return $return;
    }
    protected function getBlankOrderValues($order)
    {
        $blank = array(
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
        );

        $taxInfoFields = static::getTaxInfoFields();
        foreach ($taxInfoFields as $i) {
            $blank[] = '';
        }

        return $blank;
    } 
    public function getCreditMemoByOrderId($orderId)
    {
        $credit_detail['adjustment_positive'] = 0;
	    $credit_detail['adjustment_negative'] = 0;
	    $credit_detail['shipping_amount'] = 0;
	    $credit_detail['base_shipping_amount'] = 0;
	    $credit_detail['subtotal'] = 0;
	    $credit_detail['base_subtotal'] = 0;
	    $credit_detail['tax_amount'] = 0;
	    $credit_detail['base_tax_amount'] = 0;
	    $credit_detail['discount_amount'] = 0;
	    $credit_detail['base_discount_amount'] = 0;
        if ($orderId) {
            $searchCriteria = $this->searchCriteriaBuilder
            ->addFilter('order_id', $orderId)->create();
            try {
                $creditmemos = $this->creditmemoRepository->getList($searchCriteria);
                $creditmemoRecords = $creditmemos->getItems();
                foreach($creditmemoRecords as $data)
                {
                    $credit_detail['adjustment_positive'] += $data->getData('adjustment_positive');
                    $credit_detail['adjustment_negative'] += $data->getData('adjustment_negative');
                    $credit_detail['shipping_amount'] += $data->getData('shipping_amount');
                    $credit_detail['base_shipping_amount'] += $data->getData('base_shipping_amount');
                    $credit_detail['subtotal'] += $data->getData('subtotal');
                    $credit_detail['base_subtotal'] += $data->getData('base_subtotal');
                    $credit_detail['tax_amount'] += $data->getData('tax_amount');
                    $credit_detail['base_tax_amount'] += $data->getData('base_tax_amount');
                    $credit_detail['discount_amount'] += $data->getData('discount_amount');
                    $credit_detail['base_discount_amount'] += $data->getData('base_discount_amount');
                }
            } catch (Exception $exception)  {
                $this->logger->critical($exception->getMessage());
                $credit_detail = null;
            }
        }
        return $credit_detail;
    }
    public function getInvoiceDate($order)
    {
	    $date = '';
        $collection = $order->getInvoiceCollection();
		if(count($collection))
		{
		 foreach($collection as $data)
		 $date = $data->getData('created_at');
		}
		
		return $date;
		
    }
    public function getShipmentDate($order)
    {
	    $date = '';
        $collection = $order->getShipmentsCollection();
		if(count($collection))
		{
		 foreach($collection as $data)
		 $date = $data->getData('created_at');
		}
		
		return $date;
		
    }
	
	public function getCreditmemoDate($order)
    {
	    $date = '';
        $collection = $order->getCreditmemosCollection();
		if(count($collection))
		{
		 foreach($collection as $data)
		 $date = $data->getData('created_at');
		}
		
		return $date;
		
    }
    public function getShippingMethod($order)
    {
        if (!$order->getIsVirtual() && $order->getShippingDescription()) {
            return $order->getShippingDescription();
        }
        else if (!$order->getIsVirtual() && $order->getShippingMethod()) {
        	return $order->getShippingMethod();
        }
        return '';
    }
}
