<?php
namespace Xtwo\NinjaMenus\Model;

use Magezon\NinjaMenus\Block\Menu;
use Magezon\NinjaMenus\Helper\Menu as Helper;
use Magezon\NinjaMenus\Model\ResourceModel\Menu\CollectionFactory as NinjaMenuCollectionFactory;
use Magento\Framework\Serialize\SerializerInterface;
use Magezon\NinjaMenus\Block\Element\Item;
use Magezon\NinjaMenus\Ui\Component\Listing\Columns\Menu\Name;
use Magento\Catalog\Model\CategoryFactory;

class NinjaMenuApi implements \Xtwo\NinjaMenus\Api\MenuApiInterface
{
    protected $menuBlock;
    protected $helper;
    protected $ninjaCollectionFactory;
    private $serializer;
    protected $item;
    protected $name;
    protected $_collectionFactory;
    protected $_categoryFactory;

    public function __construct(
        Menu $menuBlock,
        Helper $helper,
        NinjaMenuCollectionFactory $ninjaCollectionFactory,
        SerializerInterface $serializer,
        Item $item,
        Name $name,
        \Magento\Catalog\Model\ResourceModel\Category\CollectionFactory $collectionFactory,
        CategoryFactory $categoryFactory
    ) {
        $this->menuBlock = $menuBlock;
        $this->helper = $helper;
        $this->ninjaCollectionFactory = $ninjaCollectionFactory;
        $this->serializer = $serializer;
        $this->item = $item;
        $this->name = $name;
        $this->_collectionFactory = $collectionFactory;
        $this->_categoryFactory = $categoryFactory;
    }

    public function getNinjaMenu($storeId)
    {
        $menuCollection = $this->ninjaCollectionFactory->create()
            ->addFieldToSelect('*')
            ->addFieldToFilter('store_id', $storeId);
    
        $categories = [];
        foreach ($menuCollection as $data) {
            if ($data->getIdentifier() === 'top-menu') {
                $serializedProfile = $this->serializer->unserialize($data->getProfile());
                $categories = $this->extractCategories($serializedProfile);
            }
        }
        
        // Directly return the $categories array
        return $categories;
    }    

    private function extractCategories($data)
    {
        $categories = [];

        foreach ($data['elements'] as $item) {
            if ($item['type'] === 'menu_item') {
                $defaultCategoryLink = $this->getCategoryLink($item['category_id'] ?? null);
                
                $category = [
                    'title' => $item['title'],
                    'link' => $defaultCategoryLink,
                    'subcategories' => []
                ];

                if (isset($item['elements']) && is_array($item['elements'])) {
                    foreach ($item['elements'] as $element) {
                        if ($element['type'] === 'row') {
                            $this->processRowElements($element, $category);
                        }
                    }
                }

                if (empty($category['subcategories'])) {
                    if (!empty($this->getManufacturerImages($item['elements']))) {
                        $category['brand_images'] = $this->getManufacturerImages($item['elements']);
                    } else {
                        $category = $this->getOuterCatData($item);
                    }
                }

                $categories[] = $category;
            }
        }

        return $categories;
    }

    private function processRowElements($element, &$category)
    {
        foreach ($element['elements'] as $item2) {
            if (isset($item2['elements']) && is_array($item2['elements'])) {
                foreach ($item2['elements'] as $item3) {
                    if ($item3['type'] === 'row') {
                        foreach ($item3['elements'] as $item4) {
                            foreach ($item4['elements'] as $item5) {
                                if (isset($item5['type']) && $item5['type'] === 'menu_item') {
                                    $this->addSubcategory($item5, $category);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private function getCategoryLink($categoryId)
    {
        if ($categoryId) {
            $category = $this->_collectionFactory->create()
                ->addAttributeToSelect(['url_key', 'level', 'parent_id'])
                ->addAttributeToFilter('entity_id', $categoryId)
                ->getFirstItem();

            if ($category) {
                $url = $this->buildUrlByLevel($category->getUrlKey(), $category->getParentId(), $category->getLevel());
                return str_replace('default-category/', '', $url);
            }
        }
        return '#';
    }

    private function buildUrlByLevel($urlKey, $parentId, $level)
    {
        $urlSegments = [];
        $existingKeys = [];
        if ($level >= 4) {
            $level3Cat = $this->getCategoryLevelData($parentId);
            if ($level3Cat) {
                $level2Cat = $this->getCategoryLevelData($level3Cat->getParentId());
                if ($level2Cat && !isset($existingKeys[$level2Cat->getUrlKey()])) {
                    $urlSegments[] = $level2Cat->getUrlKey();
                    $existingKeys[$level2Cat->getUrlKey()] = true;
                }
                if (!isset($existingKeys[$level3Cat->getUrlKey()])) {
                    $urlSegments[] = $level3Cat->getUrlKey();
                    $existingKeys[$level3Cat->getUrlKey()] = true;
                }
            }
        } elseif ($level == 3) {
            $level2Cat = $this->getCategoryLevelData($parentId);
            if ($level2Cat && !isset($existingKeys[$level2Cat->getUrlKey()])) {
                $urlSegments[] = $level2Cat->getUrlKey();
                $existingKeys[$level2Cat->getUrlKey()] = true;
            }
        }

        if (!isset($existingKeys[$urlKey])) {
            $urlSegments[] = $urlKey;
            $existingKeys[$urlKey] = true;
        }
        $fullUrl = implode('/', $urlSegments);
        return str_replace('default-category/', '', $fullUrl);
    }


    private function getCategoryLevelData($categoryId)
    {
        return $this->_collectionFactory->create()
            ->addAttributeToSelect('url_key', 'level', 'parent_id')
            ->addAttributeToFilter('entity_id', $categoryId)
            ->getFirstItem();
    }

    private function addSubcategory($item5, &$category)
    {
        if (!isset($item5['category_id'])) {
            return; 
        }

        $subcategory = [
            'title' => $item5['title'] ?? '',
            'link' => $this->getCategoryLink($item5['category_id']),
            'childcategories' => []
        ];

        foreach ($item5['elements'] ?? [] as $item6) {
            if (isset($item6['type']) && $item6['type'] === 'menu_item' && isset($item6['item_type']) && $item6['item_type'] === 'category') {
                $this->addChildCategory($item6, $subcategory);
            }
        }

        $category['subcategories'][] = $subcategory;
    }

    private function addChildCategory($item6, &$subcategory)
    {
        if (!isset($item6['category_id'])) {
            return; 
        }

        $childCatLink = $this->getCategoryLink($item6['category_id']);

        if ($childCatLink !== '#') {
            $subcategory['childcategories'][] = [
                'title' => $item6['title'] ?? '',
                'link' => $childCatLink,
            ];
        }
    }

    private function getOuterCatData($item)
    {
        $categoryId = $item['category_id'] ?? null;
        $categoryName = $item['title'] ?? '';
        $category = $this->_categoryFactory->create()->loadByAttribute('entity_id', $categoryId);
        $mainCatUrlKey = str_replace('default-category/', '', $category->getUrlKey() ?: '');
    
        $outsubcategories = [];
        foreach ($item['elements'] ?? [] as $outerCat) {
            $outsubCatLink = $this->getCategoryLink($outerCat['category_id'] ?? null);
            if (strpos($outsubCatLink, $mainCatUrlKey) === 0) {
                $outsubCatLink = ltrim($outsubCatLink, '/');
            } else {
                $outsubCatLink = $mainCatUrlKey . '/' . ltrim($outsubCatLink, '/');
            }
    
            $outsubcategories[] = [
                'title' => $outerCat['title'] ?? '',
                'link' => $outsubCatLink,
            ];
        }
    
        return [
            'title' => $categoryName,
            'link' => ltrim($mainCatUrlKey, '/'),
            'subcategories' => $outsubcategories,
        ];
    }    

    private function getManufacturerImages($elements)
    {
        $manufacturerContent = [];
        foreach ($elements as $element) {
            foreach ($element['elements'] as $item) {
                foreach ($item['elements'] as $item1) {
                    $manufacturerItem = [];
                    if (isset($item1['custom_link'])) {
                        preg_match('/id="([^"]+)"/', $item1['custom_link'], $matches);
                    }

                    if (isset($item1['image'])) {
                        $manufacturerItem['image'] = $item1['image'];
                        if (!empty($matches[1])) {
                            $categoryUrlKey = $this->_collectionFactory->create()
                                ->addAttributeToSelect('url_key')
                                ->addFieldToFilter('entity_id', $matches[1])
                                ->getFirstItem()
                                ->getUrlKey();
                            $manufacturerItem['link'] = @str_replace('default-category/', '', $categoryUrlKey) ?: '#';
                        }
                    }

                    if (!empty($manufacturerItem)) {
                        $manufacturerContent[] = $manufacturerItem;
                    }
                }
            }
        }

        return $manufacturerContent;
    }
}