<?php

namespace Xtwo\Navsync\Ui\Component\Product\Listing\Column;

use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Ui\Component\Listing\Columns\Column;

class ProductSyncStatus extends Column
{
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        array $components = [],
        array $data = []
    ) {
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }

    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$items) {
                // $items['instock'] is column value
                if ($items['status'] == 1) {
                    $items[$this->getData('name')] = 1;
                } else if ($items['status'] == 2 ){
                    $items[$this->getData('name')] = 2;
                } else if ($items['status'] == 3){
                    $items[$this->getData('name')] = 3;
                } else if ($items['status'] == 4 ){
                    $items[$this->getData('name')] = 4;
                } 
            }
        }
        return $dataSource;
    }
}