<?php
namespace Xtwo\Navsync\Setup;
use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
/**
 * @codeCoverageIgnore
 */
class InstallSchema implements InstallSchemaInterface
{
    /**
     * {@inheritdoc}
     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
     */
    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;
        $installer->startSetup();
        /**
         * Create table 'md_blog'
         */
        if (!$installer->tableExists('xtwo_productsync')) {
            $table = $installer->getConnection()->newTable(
                $installer->getTable('xtwo_productsync')
            )->addColumn(
                'sync_id',
                Table::TYPE_INTEGER,
                null,
                [
                    'identity' => true,
                    'nullable' => false,
                    'primary' => true,
                    'unsigned' => true,
                ],
                'Sync ID'
            )->addColumn(
                'sync_title',
                Table::TYPE_TEXT,
                255,
                [
                    'nullable => false',
                ],
                'Sync Title'
            )->addColumn(
                'last_sync_at',
                Table::TYPE_TIMESTAMP,
                null,
                [
                    'nullable' => false,
                    'default' => Table::TIMESTAMP_INIT,
                ],
                'Last sync at'
            )->addColumn(
                'status',
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                1,
                ['default'=>1],
                'Status'
            )->addColumn(
                'imported_at',
                Table::TYPE_TIMESTAMP,
                null,
                [
                    'nullable' => true,
                ],
                'Imported At'
            )->addColumn(
                'exported_at',
                Table::TYPE_TIMESTAMP,
                null,
                [
                    'nullable' => true,
                ],
                'Exported At'
            )->addColumn(
                'file_name',
                Table::TYPE_TEXT,
                255,
                [
                    'nullable => false',
                ],
                'export file'
            )->addColumn(
                'created_at',
                Table::TYPE_TIMESTAMP,
                null,
                [
                    'nullable' => false,
                    'default' => Table::TIMESTAMP_INIT,
                ],
                'Created At'
            )->setComment('Nav product sync Table');
            $installer->getConnection()->createTable($table);
        }
        $installer->endSetup();
    }
}