<?php

namespace Xtwo\Navsync\Controller\Adminhtml\Product;
use Magento\Framework\App\Filesystem\DirectoryList;
//set_time_limit (0);
ini_set("max_execution_time", 7200);
ini_set("max_input_time", 7200);
class Save extends \Magento\Backend\App\Action
{
    protected $_navSyncLogger;
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Xtwo\Navsync\Model\ProductFactory $productFactory,
        \Magento\Backend\Model\Auth\Session $authSession,
        \Magento\Framework\App\Response\Http\FileFactory $fileFactory,
        \Magento\Framework\Filesystem $filesystem,
        \Magento\Framework\App\Filesystem\DirectoryList $directoryList,
        \Magento\Framework\File\Csv $csvProcessor,
        \Magento\Framework\File\Csv $csvParser,
        \Magento\Catalog\Api\Data\ProductInterfaceFactory $mageProductFactory,
        \Magento\Catalog\Api\ProductRepositoryInterface $productRepository,
        \Magento\Catalog\Model\ResourceModel\Product\Action $action,
        \Magento\Eav\Model\Entity\Attribute $entityAttribute,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Eav\Setup\EavSetupFactory $eavSetupFactory,
        \Magento\Catalog\Model\Product $productModel,
        \Magento\Framework\App\ResourceConnection $resourceConnection,
        \Xtwo\Navsync\Logger\Logger $navSyncLogger,
		\Magento\Eav\Model\Entity\Attribute\SetFactory $attributeSetFactory,
        \Magento\Eav\Model\ResourceModel\Entity\Attribute\Set\CollectionFactory $attributeSetCollection,
        \Magento\Catalog\Model\ResourceModel\Product $productResourceModel,
        \Magento\Catalog\Setup\CategorySetupFactory $categorySetupFactory															
    ){
       $this->authSession = $authSession;
       $this->productFactory = $productFactory;
       $this->_fileFactory = $fileFactory;
       $this->directory = $filesystem->getDirectoryWrite(DirectoryList::MEDIA);
       $this->csvProcessor = $csvProcessor;
       $this->csvParser = $csvParser;
       $this->directoryList = $directoryList;
       $this->productRepository = $productRepository;
       $this->mageProductFactory = $mageProductFactory;
       $this->productAction = $action;
       $this->entityAttribute = $entityAttribute;
       $this->_storeManager = $storeManager;
       $this->_eavSetupFactory = $eavSetupFactory;
       $this->productModel = $productModel;
       $this->resourceConnection = $resourceConnection;
       $this->_navSyncLogger = $navSyncLogger;
	   $this->attributeSetFactory = $attributeSetFactory;
       $this->_attributeSetCollection = $attributeSetCollection;
       $this->productResourceModel = $productResourceModel;
       $this->categorySetupFactory = $categorySetupFactory;							
       parent::__construct($context);        
       
    }
    public function execute()
    {
        $data = $this->getRequest()->getPostValue();

        $request = $this->getRequest();
        $is_execute = $request->getParam('is_export');
        $is_import = $request->getParam('is_import');
        if(isset($data['sync_title'])){
            $data['sync_title'] = $data['sync_title'];
        }
        $data['status'] = 1;
        $syncId = isset($data['sync_id']) ? $data['sync_id'] : '';
        $rowData = $this->productFactory->create()->load($syncId);

       if($is_execute){
            $dbConnection = $this->m1DbConnection();
            $lastExportQuery = 'SELECT exported_at FROM xtwo_productsync order by exported_at DESC LIMIT 1;';
			$M2Connection = $this->resourceConnection->getConnection();
			$lastExported= $M2Connection->fetchOne($lastExportQuery);
			$lastExportedDate = $lastExported;
			if(empty($lastExportedDate)){
				//$lastExportedDate = date('Y-m-d H:i:s');
				$lastExportedDate = '2023-01-05 02:31:07';
			}
            $startdate='2023-01-31 00:00:00';
            $enddate='2023-02-01 00:00:00';
            $dbSelect = "SELECT * from catalog_product_entity WHERE updated_at > '" . $startdate . "' and updated_at <'".$enddate."'  LIMIT 300,400 ";
            //$dbSelect = $dbConnection->select()->from('catalog_product_entity', '*')->limit(10);
            //dd($dbSelect);
            if ($results = $dbConnection->fetchAll($dbSelect)) {
                $data['exported_at'] = date('Y-M-d h:i:s');
                $data['status'] = 2;
                $rowData->setData($data);
                $this->_navSyncLogger->info('navsync Exported at '.date('Y-M-d h:i:s'));
                $rowData->save();
                return $this->getM1Product($results);
            }
            
       }
        if ($is_import) {
            
            if($_FILES['import_file']['size']==0){
                $this->messageManager->addErrorMessage(__('Please upload csv file'));
                return $this->_redirect('navsync/product/index');
            }
            $ext = pathinfo($_FILES['import_file']['name'], PATHINFO_EXTENSION);
            if($ext !='csv'){
                $this->messageManager->addErrorMessage(__('Invalid File, Only csv file allowed'));
                return $this->_redirect('navsync/product/index');

            }
            $this->csvParser->setDelimiter(",");
            $dataCsv = $this->csvParser->getData($_FILES['import_file']['tmp_name']);
            if (!empty($dataCsv)) {
                // ignore first header column and read data
                foreach (array_slice($dataCsv, 1) as $key => $value) {
								 
                    $this->addUpdateProductCsv($value);
                    //and so on.
                }
                $data['imported_at'] = date('Y-M-d h:i:s');
            }
            $this->_navSyncLogger->info('navsync imported at '.date('Y-M-d h:i:s'));
            $data['status'] = 3;
       }
       
        if (!$data) {
            $this->_redirect('navsync/product/index');
        }
        try {
           
            if (!$rowData->getSyncId() && $syncId) {
                $this->messageManager->addError(__('sync data no longer exist.'));
                $this->_redirect('navsync/product/index');
            }
            
            
            $rowData->setData($data);
            $rowData->save();
            $this->_navSyncLogger->info('navsync created');
            $this->messageManager->addSuccess(__('Product sync data has been successfully saved.'));
        } catch (\Exception $e) {
            $this->messageManager->addError(__($e->getMessage()));
        }
        $this->_redirect('navsync/product/index');
    }
    /**
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Xtwo_Navsync::productsync');
    }
    /**
     * Function to get m1 database connection and product
     */
    public function getM1Product($results){
        /*
        * Create DB connection and save in $dbConnection
        */
        $dbConnection = $this->m1DbConnection();

         /** Add yout header name here */
         $content[] = [
              'entity_id',
              'sku',
              'attribute_set',
              'nav_id',
              'name',
              'manufacturer',
              'series',
              'shipping_forwarding',
              'weight',
              'price',
              'visibility',
              'status',
              'order_confirmation',
              'tax_class_id',
              'msrp',
              'barcode',
              'delivery_time'
        ];
        $name = date('Y_m_d__H_i_s');
        $fileName = $name.'.csv';
        $newDirectory = $this->directory->create(DIRECTORY_SEPARATOR.'navexport'.DIRECTORY_SEPARATOR);
        
        $filePath =  $this->directoryList->getPath(DirectoryList::MEDIA) ."/"  . $fileName;

        if ($results ) {
            $productArray=[];
            
            foreach($results as $pKey=> $product){
							   
                $productArray[$product['entity_id']] = [
                    'entity_id'=> $product['entity_id'],
                    'sku'=> $product['sku'],
                    'attribute_set_id'=> $this->getProductAttributeSetName($dbConnection,$product['entity_id'],$product['attribute_set_id']), //$product['attribute_set_id'],
                    //'nav_no'=>  $product['nav_no']
                ];
                foreach($this->getAttributes() as $attr){
                    $attributeId = $this->GetAttributeByCode($dbConnection, $attr);
                    $this->_navSyncLogger->info('navsync product Sku :'.$product['sku']);
					
                    if($attr=='name'){
                        $productName = $this->getProductName($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productName;
                        $this->_navSyncLogger->info('navsync product name:'.$productName);
					}else if($attr=='nav_id'){
                        if ($attributeId) {
                            $productNavId = $this->getProductNavId($dbConnection, $product['entity_id'], $attributeId);

                            $productArray[$product['entity_id']][$attr] = $productNavId;
                            $this->_navSyncLogger->info('navsync product nav_id:' . $attributeId);
                        }else{
                           // $productArray[$product['entity_id']][$attr] = '';
                        }						   
                    }else if($attr=='manufacturer'){
                        $productManufacturer = $this->getProductManufacturer($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productManufacturer;
                        $this->_navSyncLogger->info('navsync product manufacturer:'.$productManufacturer);
                    }else if($attr=='series'){
                        $productSeries = $this->getProductSeries($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productSeries;
                        $this->_navSyncLogger->info('navsync product series :'.$productSeries);
                    }else if($attr=='shipping_forwarding'){
                        $productShipingForward = $this->getProductShippingForward($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productShipingForward;
                        $this->_navSyncLogger->info('navsync product shipping_forwarding :'.$productShipingForward);
                    }else if($attr=='weight'){
                        $productWeight = $this->getProductWeight($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productWeight;
                        $this->_navSyncLogger->info('navsync product weight :'.$productWeight);
                    }else if($attr=='price'){
                        $productPrice = $this->getProductPrice($dbConnection,$product['entity_id'],$attributeId);
                       $productArray[$product['entity_id']][$attr] = $productPrice;
                       $this->_navSyncLogger->info('navsync product price :'.$productPrice);
                    } else if($attr=='visibility'){
                        $productVisibility = $this->getProductVisibility($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productVisibility;
                        $this->_navSyncLogger->info('navsync product visibility :'.$productVisibility);
                    } else  if($attr =='status') {
                        $productStatus = $this->getProductStatus($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productStatus;
                        $this->_navSyncLogger->info('navsync product status :'.$productStatus);
                    }else if($attr =='order_confirmation') {
                        $productOrderConfirm = $this->getProductOrderConfirm($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productOrderConfirm;
                        $this->_navSyncLogger->info('navsync product order_confirmation :'.$productOrderConfirm);
                    }else if($attr =='tax_class_id') {
                        $productTaxClass = $this->getProductTaxClass($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productTaxClass;
                        $this->_navSyncLogger->info('navsync product tax_class_id :'.$productTaxClass);
                        
                    }else if($attr =='msrp') {
                        $productMsrp = $this->getProductMsrp($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productMsrp;
                        $this->_navSyncLogger->info('navsync product msrp :'.$productMsrp);
                        
                    }else if($attr =='barcode') {
                        $productBarcode = $this->getProductBarcode($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productBarcode;
                        $this->_navSyncLogger->info('navsync product barcode :'.$productBarcode);
                        
                    }
                    else if ($attr=='delivery_time'){
                        $productDeliveryTime = $this->getProductDeliveryTime($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productDeliveryTime;
                        $this->_navSyncLogger->info('navsync product delivery_time :'.$productDeliveryTime);
                    }
                }
            }
            
            //dd($productArray);
            foreach ($productArray as $item) {
                $content[] = [
                    $item['entity_id'],
                    $item['sku'],
                    $item['attribute_set_id'],
                    $item['nav_id'],
                    $item['name'],
                    $item['manufacturer'],
                    $item['series'],
                    $item['shipping_forwarding'],
                    $item['weight'],
                    $item['price'],
                    $item['visibility'],
                    $item['status'],
                    $item['order_confirmation'],
                    $item['tax_class_id'],
                    $item['msrp'],
                    $item['barcode'],
                    $item['delivery_time'],
                    
                ];
            }
            
            $this->csvProcessor->setEnclosure('"')->setDelimiter(',')->saveData($filePath, $content);
            return $this->_fileFactory->create(
                $fileName,
                [
                    'type'  => "filename",
                    'value' => $fileName,
                    'rm'    => false, // True => File will be remove from directory after download.
                ],
                DirectoryList::MEDIA,
                'text/csv',
                null
            );
        }else{
            return null;
        }
        
    }
    /* Header Columns */
    public function getColumnHeader() {
        $headers = ['Id','created_at','attribute_set_id','children_count'];
        return $headers;
    }
    public function getAttributes(){
        $attributeList=[
           // 'sku',
            'name',
			'nav_id',		 
           // 'attribute_set',
            'weight',
            'price',
            'manufacturer',
            'series',
            'shipping_forwarding',
            'visibility',
            'status',
            'order_confirmation',
            'tax_class_id',
            'msrp',
            'barcode',
            'delivery_time'
        ];
        return $attributeList; 
    }
    public function GetAttributeByCode($dbConnection,$code){
        if($code){
            $dbSelect = 'SELECT attribute_id FROM eav_attribute WHERE entity_type_id=4 and attribute_code="'.$code.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductWeight($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_decimal  WHERE attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductPrice($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_decimal  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductVisibility($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_int  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductStatus($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_int  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductOrderConfirm($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_int  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductTaxClass($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_int  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductMsrp($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_decimal  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductBarcode($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_varchar  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductShippingForward($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_int  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }

    public function getProductManufacturer($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = "select ao.value from catalog_product_entity p 
            left join catalog_product_entity_int av on p.entity_id = av.entity_id 
            left join eav_attribute a on av.attribute_id = a.attribute_id 
            left join eav_attribute_option_value ao on av.value = ao.option_id 
            where p.entity_id = '" . $entityId . "' and a.attribute_id='" . $attributeId . "'";
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductSeries($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = "select ao.value from catalog_product_entity p 
            left join catalog_product_entity_int av on p.entity_id = av.entity_id 
            left join eav_attribute a on av.attribute_id = a.attribute_id 
            left join eav_attribute_option_value ao on av.value = ao.option_id 
            where p.entity_id = '" . $entityId . "' and a.attribute_id='" . $attributeId . "'";
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductDeliveryTime($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect =  "select ao.value from catalog_product_entity p 
            left join catalog_product_entity_int av on p.entity_id = av.entity_id 
            left join eav_attribute a on av.attribute_id = a.attribute_id 
            left join eav_attribute_option_value ao on av.value = ao.option_id 
            where ao.store_id=0 and p.entity_id = '" . $entityId . "' and a.attribute_id='" . $attributeId . "'";
            $results= $dbConnection->fetchone($dbSelect);
            if($results){
                return $results;
            }
        }
    }
    public function getProductNavId($dbConnection,$entityId,$navId){
        $dbSelect = 'SELECT value FROM catalog_product_entity_varchar  WHERE 
        store_id="0" and attribute_id="'.$navId.'" and entity_id="'.$entityId.'"';
        $result= $dbConnection->fetchOne($dbSelect);
        
        if($result){
            return $result;
        }else{
            return NULL;
        }
    } 

    public function getProductName($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_varchar  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
	  public function getProductAttributeSetName($dbConnection,$entityId,$attributeSetId){
        if($entityId && $attributeSetId){
            $dbSelect = "SELECT attribute_set_name FROM eav_attribute_set eas 
            INNER JOIN catalog_product_entity cpn ON 
            cpn.attribute_set_id= eas.attribute_set_id 
            WHERE eas.attribute_set_id='".$attributeSetId."' AND cpn.entity_id = '" . $entityId . "'";
            $results= $dbConnection->fetchone($dbSelect);
            if($results){
                return $results;
            }
        }
    }
    /**
     * Function to update product if existing or add new
     */
    public function addUpdateProductCsv($product){
        $entity_id = trim($product['0']);
        $sku = trim($product['1']);
        $attribute_set = trim($product['2']);
        $nav_id = trim($product['3']);
        $name  = trim($product['4']);
        $manufacturer = trim($product['5']);
        $series = trim($product['6']);
        $shipping_forwarding = trim($product['7']);
        $weight = trim($product['8']);
        $price = trim($product['9']);
        $visibility = trim($product['10']);
        $status = trim($product['11']);
        $order_confirmation = trim($product['12']);
        $tax_class_id = trim($product['13']);
        $msrp = trim($product['14']);
        $barcode = trim($product['15']);
        $delivery_time = trim($product['16']);

        $attributeSetId = 0;
        $attributeSetData = $this->_attributeSetCollection->create()
        ->addFieldToSelect('attribute_set_id')
        ->addFieldToFilter('attribute_set_name', $attribute_set)
        ->getFirstItem()
        ->toArray();
       
        if(!empty($attributeSetData) && !empty($attributeSetData['attribute_set_id'])){
            $attributeSetId = $attributeSetData['attribute_set_id'];
        }else{
            //adding attriubte set
            $categorySetup = $this->categorySetupFactory->create();

            $attributeSet = $this->attributeSetFactory->create();
            $entityTypeId = $categorySetup->getEntityTypeId(\Magento\Catalog\Model\Product::ENTITY);
            $attributeSetId = $categorySetup->getDefaultAttributeSetId($entityTypeId);
            $data = [
            'attribute_set_name' => $attribute_set,
            'entity_type_id' => $entityTypeId,
            'sort_order' => 100,
            ];
            $attributeSet->setData($data);
            $attributeSet->validate();
            $attributeSet->save();
            $attributeSet->initFromSkeleton($attributeSetId);
            $attributeSet->save();
            $attributeSetId = $attributeSet->getId();
            
        }

        $productExist =$this->productModel->getIdBySku($sku);
        if($productExist){
            $this->_navSyncLogger->info('navsync product Sku exist:'.$sku);
            $productResult= $this->productRepository->get($sku);
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['name' => $name], 0);
            $manufacturerOptionId = $this->getOptionIdByLabel($productResult,'manufacturer',$manufacturer);
            if(empty($manufacturerOptionId)){
                $this->addAttributeOption('manufacturer',$manufacturer);
                $this->_navSyncLogger->info('navsync product manufacturer not exist create new:'.$manufacturer);
            }
            $manufacturerOptionId = $this->getOptionIdByLabel($productResult,'manufacturer',$manufacturer);
            $this->_navSyncLogger->info('navsync product manufacturer updated:'.$manufacturer);
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['manufacturer' => $manufacturerOptionId], 0);

            $seriesId = $this->getOptionIdByLabel($productResult,'series',$series);
            if(empty($seriesId)){
                $this->addAttributeOption('series',$series);
                $this->_navSyncLogger->info('navsync product series not exist create new:'.$series);
            }
            $seriesId = $this->getOptionIdByLabel($productResult,'series',$series);
            
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['series' => $seriesId], 0);
            $this->_navSyncLogger->info('navsync product series updated:'.$series);
			$pp = $this->productAction->updateAttributes([$productResult->getId()], ['nav_id' => $nav_id], 0);
            $this->_navSyncLogger->info('navsync product nav_id updated:'.$nav_id);																				  
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['shipping_forwarding' => $shipping_forwarding], 0);
            $this->_navSyncLogger->info('navsync product shipping_forwarding updated:'.$shipping_forwarding);
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['weight' => $weight], 0);
            $this->_navSyncLogger->info('navsync product weight updated:'.$weight);
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['price' => $price], 0);
            $this->_navSyncLogger->info('navsync product price updated:'.$price);
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['visibility' => $visibility], 0);
            $this->_navSyncLogger->info('navsync product visibility updated:'.$visibility);
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['status' => $status], 0);
            $this->_navSyncLogger->info('navsync product status updated:'.$status);
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['order_confirmation' => $order_confirmation], 0);
            $this->_navSyncLogger->info('navsync product order_confirmation updated:'.$order_confirmation);
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['tax_class_id' => $tax_class_id], 0);
            $this->_navSyncLogger->info('navsync product tax_class_id updated:'.$tax_class_id);
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['msrp' => $msrp], 0);
            $this->_navSyncLogger->info('navsync product msrp updated:'.$msrp);
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['barcode' => $barcode], 0);
            $this->_navSyncLogger->info('navsync product barcode updated:'.$barcode);
            
			$deliveryTimeId = $this->getOptionIdByLabel($productResult,'delivery_time',$delivery_time);
            if(empty($deliveryTimeId)){
                $this->addAttributeOption('delivery_time',$delivery_time);
                $this->_navSyncLogger->info('navsync product delivery_time not exist create new:'.$delivery_time);
            }
            
            $deliveryTimeId = $this->getOptionIdByLabel($productResult,'delivery_time',$delivery_time);
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['delivery_time' => $deliveryTimeId], 0);
            $this->_navSyncLogger->info('navsync product delivery_time updated:'.$delivery_time);
			//attribute set
            $product = $this->productModel->load($productResult->getId());
            $product->setAttributeSetId($attributeSetId);
            if($product->save()){
                $this->_navSyncLogger->info('navsync product attribute updated id:'.$attributeSetId.' name:'.$attribute_set);
            }
            
        }else{
            $this->_navSyncLogger->info('navsync product sku not exist created:'.$sku);
            $product = $this->mageProductFactory->create();
            $product->setSku($sku); 
            $product->setName($name ); 
            $product->setAttributeSetId($attributeSetId);
            $product->setStatus($status); 
            $product->setWeight($weight);
            $product->setVisibility($visibility); // visibilty of product (catalog / search / catalog, search / Not visible individually)
            $product->setTaxClassId($tax_class_id); 
            $product->setTypeId('simple'); 
            $product->setPrice($price);
            $product->setStockData(
                array(
                    'use_config_manage_stock' => 0,
                    'manage_stock' => 0,
                    'is_in_stock' => 0,
                    'qty' => 0
                )
            );
            $this->_navSyncLogger->info('navsync product attribute updated id:'.$attributeSetId.' name:'.$attribute_set);
            try {
                $this->productRepository->save($product);

                $productResult = $this->productRepository->get($sku);
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['name' => $name], 0);
				
                $manufacturerOptionId = $this->getOptionIdByLabel($productResult,'manufacturer',$manufacturer);
                if(empty($manufacturerOptionId)){
                    $this->addAttributeOption('manufacturer',$manufacturer);
                    $this->_navSyncLogger->info('navsync product manufacturer not exist create new:'.$manufacturer);
                }
                $manufacturerOptionId = $this->getOptionIdByLabel($productResult,'manufacturer',$manufacturer);
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['manufacturer' => $manufacturerOptionId], 0);
                $this->_navSyncLogger->info('navsync product manufacturer updated:'.$manufacturer);
                $seriesId = $this->getOptionIdByLabel($productResult,'series',$series);
                if(empty($seriesId)){
                    $this->addAttributeOption('series',$series);
                    $this->_navSyncLogger->info('navsync product series not exist create new:'.$series);
                }
                $seriesId = $this->getOptionIdByLabel($productResult,'series',$series);
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['series' => $seriesId], 0);
                $this->_navSyncLogger->info('navsync product series updated:'.$series);
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['shipping_forwarding' => $shipping_forwarding], 0);
                $this->_navSyncLogger->info('navsync product shipping_forwarding updated:'.$shipping_forwarding);
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['weight' => $weight], 0);
                $this->_navSyncLogger->info('navsync product weight updated:'.$weight);
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['price' => $price], 0);
                $this->_navSyncLogger->info('navsync product price updated:'.$price);
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['visibility' => $visibility], 0);
                $this->_navSyncLogger->info('navsync product visibility updated:'.$visibility);
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['status' => $status], 0);
                $this->_navSyncLogger->info('navsync product status updated:'.$status);
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['order_confirmation' => $order_confirmation], 0);
                $this->_navSyncLogger->info('navsync product order_confirmation updated:'.$order_confirmation);
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['tax_class_id' => $tax_class_id], 0);
                $this->_navSyncLogger->info('navsync product tax_class_id updated:'.$tax_class_id);
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['msrp' => $msrp], 0);
                $this->_navSyncLogger->info('navsync product msrp updated:'.$msrp);
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['barcode' => $barcode], 0);
                $this->_navSyncLogger->info('navsync product barcode updated:'.$barcode);
                $deliveryTimeId = $this->getOptionIdByLabel($productResult,'delivery_time',$delivery_time);
                if(empty($deliveryTimeId)){
                    $this->addAttributeOption('delivery_time',$delivery_time);
                    $this->_navSyncLogger->info('navsync product delivery_time not exist create new:'.$delivery_time);
                }
                $deliveryTimeId = $this->getOptionIdByLabel($productResult,'delivery_time',$delivery_time);
                $this->_navSyncLogger->info('navsync product delivery_time updated:'.$delivery_time);
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['delivery_time' => $deliveryTimeId], 0);
                
            }catch (\Exception $e) {
                $this->_navSyncLogger->info('navsync product not created due to this:'.$e->getMessage());
                $this->messageManager->addError(__($e->getMessage()));
            }
        }
    }
    public function getProductBySku($sku){
        $dbSelect = 'SELECT * FROM catalog_product_entity  WHERE sku="'.$sku.'"';
        $result= $this->m1DbConnection()->fetchOne($dbSelect);
        return $result;

    }

    public function m1DbConnection(){
        $objMgr = \Magento\Framework\App\ObjectManager::getInstance();
        $connectionFactory = $objMgr->get('Magento\Framework\App\ResourceConnection\ConnectionFactory');
        $dbConnection= $connectionFactory->create([
            'host'     => '94.130.217.28',
            'dbname'   => 'c19655655',
            'username' => 'c19655655',
            'password' => 'NbshGshg3#93873j',
            'active' => '1',
        ]);
        return $dbConnection;
    }
    /* Get Option id by Option Label */
    public function getOptionIdByLabel($product,$attributeCode,$optionLabel){
        $isAttributeExist = $product->getResource()->getAttribute($attributeCode);
        $optionId = '';
        if ($isAttributeExist && $isAttributeExist->usesSource()) {
            $optionId = $isAttributeExist->getSource()->getOptionId($optionLabel);
        }
        return $optionId;
    }
    public function addAttributeOption($attirbuteCode,$optionValue){
        $attribute = $this->entityAttribute->loadByCode('catalog_product', $attirbuteCode);
        $alloptions=$attribute->getSource()->getAllOptions();
        $optionExist = false;
        foreach($alloptions as $option) {
            if($option['label']==$optionValue){
                $optionExist = true;
            }
        }

        if($optionExist==false){
            $option = [$optionValue];
            $allStores = $this->_storeManager->getStores();
            $option['attribute_id'] = $attribute->getAttributeId();

            foreach($option as $key=>$value){
                $option['value'][$value][0]=$value;
                    foreach($allStores as $store){
                        $option['value'][$value][$store->getId()] = $value;
                    }
                }
                $eavSetup = $this->_eavSetupFactory->create();
                $eavSetup->addAttributeOption($option);
        }
    }
}