<?php

namespace Xtwo\Navsync\Controller\Adminhtml\Product;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\View\Result\Page;
use Magento\Framework\View\Result\PageFactory;

use Xtwo\Navsync\Model\ProductFactory;

class NewAction extends Action
{
    /**
     * @var PageFactory
     */
    private $pageFactory;


    /**
     * @var \Magento\Framework\Registry
     */
    private $coreRegistry;

   
    public function __construct(
        Context $context,
        PageFactory $rawFactory,
        \Magento\Framework\Registry $coreRegistry
    )
    {
        $this->pageFactory = $rawFactory;
        $this->coreRegistry = $coreRegistry;
        parent::__construct($context);
    }


    /**
     * execute function
     * return redirect
     * @return Page
     */
    public function execute(): Page
    {
        $resultPage = $this->pageFactory->create();
        $resultPage->setActiveMenu('Magento_Catalog::catalog_products');
        $title = __('Add Product Sync');
        $resultPage->getConfig()->getTitle()->prepend($title);
        return $resultPage;
    }

    /**
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Xtwo_Naysync::productsync');
    }
}
