<?php

namespace Xtwo\Navsync\Controller\Adminhtml\Product;
use Magento\Ui\Component\MassAction\Filter;
use Xtwo\Navsync\Model\ResourceModel\Product\CollectionFactory;

/** 
 * MassDelete function 
 * 
*/

class MassDelete extends \Magento\Backend\App\Action
{

    protected $productFactory;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Xtwo\Navsync\Model\ProductFactory $productFactory,
        \Magento\Ui\Component\MassAction\Filter $filter,
        CollectionFactory $collectionFactory
        
    ){
       $this->productFactory = $productFactory;
       $this->filter = $filter;
       $this->collectionFactory = $collectionFactory;
       parent::__construct($context);
    }
    public function execute()
    {
        $data = $this->getRequest()->getPostValue();
        $collection = $this->filter->getCollection($this->collectionFactory->create());
        try {
            $count = 0;
            foreach ($collection as $item) {
                $item->delete();
                $count++;
            }
            $this->messageManager->addSuccess(__('A total of %1 record(s) have been deleted.', $count));
        } catch (\Exception $e) {
            $this->messageManager->addError(__($e->getMessage()));
        }
        $this->_redirect('navsync/product/index');
    }

    /**
     * @authorisation
     * return allowed | bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Xtwo_Navsync::productsync');
    }
}
