<?php

namespace Xtwo\Navsync\Controller\Adminhtml\Product;
use Magento\Backend\App\Action;
class Delete extends Action
{
    /**
     * @var Xtwo\Navsync\Model\Product
     */
    protected $modelProduct;
    /**
     * @param \Magento\Backend\App\Action\Context $context
     * @param Xtwo\Navsync\Model\Product $productFactory
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Xtwo\Navsync\Model\ProductFactory $productFactory
    ) {
        parent::__construct($context);
        $this->modelProduct = $model;
    }
    /**
     * {@inheritdoc}
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Xtwo_Navsync::index_delete');
    }
    /**
     * Delete action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam('id');
        /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        if ($id) {
            try {
                $model = $this->modelProduct;
                $model->load($id);
                $model->delete();
                $this->messageManager->addSuccess(__('Record deleted successfully.'));
                return $resultRedirect->setPath('*/*/');
            } catch (\Exception $e) {
                $this->messageManager->addError($e->getMessage());
                return $resultRedirect->setPath('*/*/edit', ['id' => $id]);
            }
        }
        $this->messageManager->addError(__('Record does not exist.'));
        return $resultRedirect->setPath('*/*/');
    }
}