<?php
namespace Xtwo\Navsync\Console;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Input\InputArgument;
use Magento\Framework\File\Csv;
use Magento\Framework\App\State;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Exception\FileSystemException;
use Magento\Eav\Model\Entity\Attribute\OptionLabel;
use Magento\Eav\Model\Entity\Attribute\OptionManagement;
use Magento\Eav\Api\AttributeRepositoryInterface;
use Magento\Eav\Model\ResourceModel\Entity\Attribute\Option\CollectionFactory;
use Magento\Eav\Api\Data\AttributeOptionInterface;

class M1Import extends Command{
	public function __construct(
        \Magento\Framework\App\Response\Http\FileFactory $fileFactory,
        \Magento\Framework\App\Filesystem\DirectoryList $directoryList,
        \Magento\Framework\Filesystem\Driver\File $file,
		Csv $csv,
        \Psr\Log\LoggerInterface $logger,
		\Magento\Framework\Filesystem $filesystem,
        \Magento\Catalog\Api\Data\ProductInterfaceFactory $mageProductFactory,
        \Magento\Catalog\Api\ProductRepositoryInterface $productRepository,
        \Magento\Catalog\Model\ResourceModel\Product\Action $action,
        \Magento\Eav\Model\Entity\Attribute $entityAttribute,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Eav\Setup\EavSetupFactory $eavSetupFactory,
        \Magento\Catalog\Model\Product $productModel,
        \Magento\Framework\App\ResourceConnection $resourceConnection,
        \Magento\Eav\Model\Entity\Attribute\SetFactory $attributeSetFactory,
        \Magento\Eav\Model\ResourceModel\Entity\Attribute\Set\CollectionFactory $attributeSetCollection,
        \Magento\Catalog\Model\ResourceModel\Product $productResourceModel,
        \Magento\Catalog\Setup\CategorySetupFactory $categorySetupFactory,
        \Xtwo\Navsync\Logger\Logger $navSyncLogger,
    ) {
        $this->_fileFactory = $fileFactory;
        $this->directoryList = $directoryList;
        $this->csv = $csv;
        $this->file = $file;
        $this->logger = $logger;
		//$this->directory = $filesystem->getDirectoryWrite(DirectoryList::MEDIA);
        $this->productRepository = $productRepository;
        $this->mageProductFactory = $mageProductFactory;
        $this->productAction = $action;
        $this->entityAttribute = $entityAttribute;
        $this->_storeManager = $storeManager;
        $this->_eavSetupFactory = $eavSetupFactory;
        $this->productModel = $productModel;
        $this->resourceConnection = $resourceConnection;
        $this->attributeSetFactory = $attributeSetFactory;
        $this->_attributeSetCollection = $attributeSetCollection;
        $this->productResourceModel = $productResourceModel;
        $this->categorySetupFactory = $categorySetupFactory;
        $this->_navSyncLogger = $navSyncLogger;	
        parent::__construct();
    }
   protected function configure(){
	   $options = [
			new InputOption(
				'filename',
				null,
				InputOption::VALUE_REQUIRED,
				'File/csv file name'
			)
		];
		
       $this->setName('navsync:m1productimport');
       $this->setDescription('Import product from m1 exported file using command line');
	   $this->setDefinition($options);
       
       parent::configure();
   }
   protected function execute(InputInterface $input, OutputInterface $output){
	   //$objectManager = \Magento\Framework\App\ObjectManager::getInstance();
	    $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
		
    $objectManager->get('Magento\Framework\App\State')->setAreaCode('frontend');
	  $filename = $input->getOption('filename');
      if(empty($filename)){
        $output->writeln("Please provide filename which need to import");
      }else{
        if(!strpos($filename, ".csv",-4)){
            $output->writeln('Invalid file, only csv file allow');
            die();
        }
        $csvFile = $this->directoryList->getPath('var').'/'.$filename;
        try {
            if ($this->file->isExists($csvFile)) {
                $this->csv->setDelimiter(",");
                $data = $this->csv->getData($csvFile);
                unset($data[0]);
                foreach($data as $k=>$product){
                    $this->addUpdateProductCsv($product);
                    $output->writeln('<comment>SKU:</comment> <info>'.$product[1].'</info> product attribute value has been updated.');
                }
            }else{
                $output->writeln('file not exists in folder.');
            }
        } catch (FileSystemException $e) {
            $this->logger->info($e->getMessage());
            $output->writeln('file not exists in folder.');
            return false;
        }
      }
   }
   private function addUpdateProductCsv($product){

        $entity_id = trim($product['0']);
        $sku = trim($product['1']);
        $attribute_set = trim($product['2']);
        $nav_id = trim($product['3']);
        $name  = trim($product['4']);
        $manufacturer = trim($product['5']);
        $series = trim($product['6']);
        $shipping_forwarding = trim($product['7']);
        $weight = trim($product['8']);
        $price = trim($product['9']);
        $visibility = trim($product['10']);
        $status = trim($product['11']);
        $order_confirmation = trim($product['12']);
        $tax_class_id = trim($product['13']);
        $msrp = trim($product['14']);
        $barcode = trim($product['15']);
        $delivery_time = trim($product['16']);
		$nav_no = trim($product['17']);

        $attributeSetId = 0;
        $attributeSetData = $this->_attributeSetCollection->create()
        ->addFieldToSelect('attribute_set_id')
        ->addFieldToFilter('attribute_set_name', $attribute_set)
        ->getFirstItem()
        ->toArray();
    
        if(!empty($attributeSetData) && !empty($attributeSetData['attribute_set_id'])){
            $attributeSetId = $attributeSetData['attribute_set_id'];
        }else{
            //adding attriubte set
            $categorySetup = $this->categorySetupFactory->create();

            $attributeSet = $this->attributeSetFactory->create();
            $entityTypeId = $categorySetup->getEntityTypeId(\Magento\Catalog\Model\Product::ENTITY);
            $attributeSetId = $categorySetup->getDefaultAttributeSetId($entityTypeId);
            $data = [
            'attribute_set_name' => $attribute_set,
            'entity_type_id' => $entityTypeId,
            'sort_order' => 100,
            ];
            $attributeSet->setData($data);
            $attributeSet->validate();
            $attributeSet->save();
            $attributeSet->initFromSkeleton($attributeSetId);
            $attributeSet->save();
            $attributeSetId = $attributeSet->getId();
            
        }

        $productExist =$this->productModel->getIdBySku($sku);
        

        if($productExist){
            $this->_navSyncLogger->info('navsync product Sku exist:'.$sku);
            $productResult= $this->productRepository->get($sku);
            if(!empty($name)){
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['name' => $name], 0);

            }
            if(!empty($manufacturer)){
                $manufacturerOptionId = $this->getOptionIdByLabel($productResult,'manufacturer',$manufacturer);
                if(empty($manufacturerOptionId)){
                    //$this->addAttributeOption('manufacturer',$manufacturer);
					$this->CheckAttrOptionValue('manufacturer',$manufacturer);
                    $this->_navSyncLogger->info('navsync product manufacturer not exist create new:'.$manufacturer);
                }
                $manufacturerOptionId = $this->getOptionIdByLabel($productResult,'manufacturer',$manufacturer);
                $this->_navSyncLogger->info('navsync product manufacturer updated:'.$manufacturer);
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['manufacturer' => $manufacturerOptionId], 0);
            }
            if(!empty($series)){
                $seriesId = $this->getOptionIdByLabel($productResult,'series',$series);
                if(empty($seriesId)){
                    //$this->addAttributeOption('series',$series);
					$this->CheckAttrOptionValue('series',$series);
                    $this->_navSyncLogger->info('navsync product series not exist create new:'.$series);
                }
                $seriesId = $this->getOptionIdByLabel($productResult,'series',$series);
                
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['series' => $seriesId], 0);
                $this->_navSyncLogger->info('navsync product series updated:'.$series);
            }
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['nav_id' => $nav_id], 0);
            $this->_navSyncLogger->info('navsync product nav_id updated:'.$nav_id);	
            $shipping_forwarding = ($shipping_forwarding &&$shipping_forwarding==1)?1:0;																		  
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['shipping_forwarding' => $shipping_forwarding], 0);
            $this->_navSyncLogger->info('navsync product shipping_forwarding updated:'.$shipping_forwarding);
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['weight' => $weight], 0);
            $this->_navSyncLogger->info('navsync product weight updated:'.$weight);
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['price' => $price], 0);
            $this->_navSyncLogger->info('navsync product price updated:'.$price);
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['visibility' => $visibility], 0);
            $this->_navSyncLogger->info('navsync product visibility updated:'.$visibility);
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['status' => $status], 0);
            $this->_navSyncLogger->info('navsync product status updated:'.$status);
            if(!empty($order_confirmation)){
                $orderConfirmation = ($order_confirmation &&$order_confirmation==1)?1:0;
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['order_confirmation' => $order_confirmation], 0);
                $this->_navSyncLogger->info('navsync product order_confirmation updated:'.$order_confirmation);
            }
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['tax_class_id' => $tax_class_id], 0);
            $this->_navSyncLogger->info('navsync product tax_class_id updated:'.$tax_class_id);
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['msrp' => $msrp], 0);
            $this->_navSyncLogger->info('navsync product msrp updated:'.$msrp);
            if(!empty($barcode)){
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['barcode' => $barcode], 0);
                $this->_navSyncLogger->info('navsync product barcode updated:'.$barcode);
            }
            
            $deliveryTimeId = $this->getOptionIdByLabel($productResult,'delivery_time',$delivery_time);
            if(empty($deliveryTimeId)){
                //$this->addAttributeOption('delivery_time',$delivery_time);
				$this->CheckAttrOptionValue('delivery_time',$delivery_time);
                $this->_navSyncLogger->info('navsync product delivery_time not exist create new:'.$delivery_time);
            }
            
            $deliveryTimeId = $this->getOptionIdByLabel($productResult,'delivery_time',$delivery_time);
            $pp = $this->productAction->updateAttributes([$productResult->getId()], ['delivery_time' => $deliveryTimeId], 0);
            $this->_navSyncLogger->info('navsync product delivery_time updated:'.$delivery_time);
            //attribute set
            $product = $this->productModel->load($productResult->getId());
            $product->setAttributeSetId($attributeSetId);
            if(!empty($attributeSetId)){
                $connection = $this->resourceConnection->getConnection();
                $table = $connection->getTableName('catalog_product_entity');
            
                //$product->setNavNo($nav_no);
                $query = "UPDATE " . $table . " SET attribute_set_id ='".$attributeSetId."' WHERE entity_id ='".$productResult->getId()."' and sku='".$sku."' ";
                $connection->query($query);
                $connection->closeConnection();
            }
			if(!empty($nav_no)){
				$connection = $this->resourceConnection->getConnection();
				$table = $connection->getTableName('catalog_product_entity');
			
				//$product->setNavNo($nav_no);
				$query = "UPDATE " . $table . " SET nav_no='".$nav_no."' WHERE entity_id ='".$productResult->getId()."' and sku='".$sku."' ";
				$connection->query($query);
				$connection->closeConnection();
				//$this->productAction->updateAttributes([$productResult->getId()], ['nav_no' => $nav_no], 0);
				//$product->save();
			}
            //if($product->save()){
              //  $this->_navSyncLogger->info('navsync product attribute updated id:'.$attributeSetId.' name:'.$attribute_set);
            //}
        }else{
            //$objectManager = \Magento\Framework\App\ObjectManager::getInstance();
            //$objectManager->get('Magento\Framework\App\State')->setAreaCode('frontend');
            $this->_navSyncLogger->info('navsync product sku not exist created:'.$sku);
            $product = $this->mageProductFactory->create();
            $product->setSku($sku); 
            $product->setName($name ); 
            $product->setUrlKey(strtolower(preg_replace('/\s+/', '-', $name)).'-'.$sku);
            $product->setAttributeSetId($attributeSetId);
            $product->setStatus($status); 
            $product->setWeight($weight);
            $product->setVisibility($visibility); // visibilty of product (catalog / search / catalog, search / Not visible individually)
            $product->setTaxClassId($tax_class_id); 
            $product->setTypeId('simple'); 
            $product->setPrice($price);
			if(!empty($nav_no)){
				$connection = $this->resourceConnection->getConnection();
				$table = $connection->getTableName('catalog_product_entity');
			
				//$product->setNavNo($nav_no);
				//$query = "UPDATE " . $table . " SET nav_no='".$nav_no."' WHERE entity_id ='".$productResult->getId()."' and sku='".$sku."' ";
				//$connection->query($query);
				//$connection->closeConnection();
				//$this->productAction->updateAttributes([$productResult->getId()], ['nav_no' => $nav_no], 0);
				//$product->save();
			}
            $product->setStockData(
                array(
                    'use_config_manage_stock' => 0,
                    'manage_stock' => 0,
                    'is_in_stock' => 0,
                    'qty' => 0
                )
            );
            $this->_navSyncLogger->info('navsync product attribute updated id:'.$attributeSetId.' name:'.$attribute_set);
            try {
                $this->productRepository->save($product);

                $productResult = $this->productRepository->get($sku);
                if(!empty($name)){
                    $pp = $this->productAction->updateAttributes([$productResult->getId()], ['name' => $name], 0);
                }
                if(!empty($manufacturer)){
                    $manufacturerOptionId = $this->getOptionIdByLabel($productResult,'manufacturer',$manufacturer);
                    if(empty($manufacturerOptionId)){
                        //$this->addAttributeOption('manufacturer',$manufacturer);
						$this->CheckAttrOptionValue('manufacturer',$manufacturer);
                        $this->_navSyncLogger->info('navsync product manufacturer not exist create new:'.$manufacturer);
                    }
                    $manufacturerOptionId = $this->getOptionIdByLabel($productResult,'manufacturer',$manufacturer);
                    $pp = $this->productAction->updateAttributes([$productResult->getId()], ['manufacturer' => $manufacturerOptionId], 0);
                    $this->_navSyncLogger->info('navsync product manufacturer updated:'.$manufacturer);
                }
                if(!empty($series)){
                    $seriesId = $this->getOptionIdByLabel($productResult,'series',$series);
                    if(empty($seriesId)){
                        //$this->addAttributeOption('series',$series);
						$this->CheckAttrOptionValue('series',$series);
                        $this->_navSyncLogger->info('navsync product series not exist create new:'.$series);
                    }
                    $seriesId = $this->getOptionIdByLabel($productResult,'series',$series);
                    $pp = $this->productAction->updateAttributes([$productResult->getId()], ['series' => $seriesId], 0);
                    $this->_navSyncLogger->info('navsync product series updated:'.$series);
                }
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['shipping_forwarding' => $shipping_forwarding], 0);
                $this->_navSyncLogger->info('navsync product shipping_forwarding updated:'.$shipping_forwarding);
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['weight' => $weight], 0);
                $this->_navSyncLogger->info('navsync product weight updated:'.$weight);
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['price' => $price], 0);
                $this->_navSyncLogger->info('navsync product price updated:'.$price);
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['visibility' => $visibility], 0);
                $this->_navSyncLogger->info('navsync product visibility updated:'.$visibility);
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['status' => $status], 0);
                $this->_navSyncLogger->info('navsync product status updated:'.$status);
                if(!empty($order_confirmation)){
                    $pp = $this->productAction->updateAttributes([$productResult->getId()], ['order_confirmation' => $order_confirmation], 0);
                    $this->_navSyncLogger->info('navsync product order_confirmation updated:'.$order_confirmation);
                }
                
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['tax_class_id' => $tax_class_id], 0);
                $this->_navSyncLogger->info('navsync product tax_class_id updated:'.$tax_class_id);
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['msrp' => $msrp], 0);
                $this->_navSyncLogger->info('navsync product msrp updated:'.$msrp);
                if(!empty($barcode)){
                    $pp = $this->productAction->updateAttributes([$productResult->getId()], ['barcode' => $barcode], 0);
                    $this->_navSyncLogger->info('navsync product barcode updated:'.$barcode);
                }
                
                $deliveryTimeId = $this->getOptionIdByLabel($productResult,'delivery_time',$delivery_time);
                if(empty($deliveryTimeId)){
                    //$this->addAttributeOption('delivery_time',$delivery_time);
					$this->CheckAttrOptionValue('delivery_time',$delivery_time);
                    $this->_navSyncLogger->info('navsync product delivery_time not exist create new:'.$delivery_time);
                }
                $deliveryTimeId = $this->getOptionIdByLabel($productResult,'delivery_time',$delivery_time);
                $this->_navSyncLogger->info('navsync product delivery_time updated:'.$delivery_time);
                $pp = $this->productAction->updateAttributes([$productResult->getId()], ['delivery_time' => $deliveryTimeId], 0);
                
            }catch (\Exception $e) {
                $this->_navSyncLogger->info('navsync product not created due to this:'.$e->getMessage());
            }
        }
    }
   public function getColumnHeader() {
        $headers = [
              'entity_id',
              'sku',
              'attribute_set',
              'nav_id',
              'name',
              'manufacturer',
              'series',
              'shipping_forwarding',
              'weight',
              'price',
              'visibility',
              'status',
              'order_confirmation',
              'tax_class_id',
              'msrp',
              'barcode',
              'delivery_time',
			  'nav_no'
        ];;
        return $headers;
    }
	
	public function getAttributes(){
        $attributeList=[
           // 'sku',
            'name',
			'nav_id',		 
           // 'attribute_set',
            'weight',
            'price',
            'manufacturer',
            'series',
            'shipping_forwarding',
            'visibility',
            'status',
            'order_confirmation',
            'tax_class_id',
            'msrp',
            'barcode',
            'delivery_time',
			'nav_no'
        ];
        return $attributeList; 
    }
    /* Get Option id by Option Label */
    public function getOptionIdByLabel($product,$attributeCode,$optionLabel){
        $isAttributeExist = $product->getResource()->getAttribute($attributeCode);
        $optionId = '';
        $isAttributeExist->setStoreId(0);
        if ($isAttributeExist && $isAttributeExist->usesSource()) {
            $optionId = $isAttributeExist->getSource()->getOptionId($optionLabel);
        }
        return $optionId;
    }
    public function addAttributeOption($attirbuteCode,$optionValue){
        $attribute = $this->entityAttribute->loadByCode('catalog_product', $attirbuteCode);
        $alloptions=$attribute->getSource()->getAllOptions();
        $optionExist = false;
        foreach($alloptions as $option) {
            if($option['label']==$optionValue){
                $optionExist = true;
            }
        }

        if($optionExist==false){
            $option = [$optionValue];
            $allStores = $this->_storeManager->getStores();
            $option['attribute_id'] = $attribute->getAttributeId();

            foreach($option as $key=>$value){
                $option['value'][$value][0]=$value;
                    foreach($allStores as $store){
                        $option['value'][$value][$store->getId()] = $value;
                    }
                }
                $eavSetup = $this->_eavSetupFactory->create();
                $eavSetup->addAttributeOption($option);
        }
    }
	/*
	 check option value if exists send id if not create and send id
	 */
	public function CheckAttrOptionValue($attributeCode,$optionLabel){
		 //$objectManager = \Magento\Framework\App\ObjectManager::getInstance();
	    $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
		$attributeRepository = $objectManager->get(AttributeRepositoryInterface::class);
		/** @var CollectionFactory $optionCollectionFactory */
		$optionCollectionFactory = $objectManager->get(CollectionFactory::class);
		/** @var OptionManagement $optionManagement */
		$optionManagement = $objectManager->get(OptionManagement::class);
		try {
			$attribute = $attributeRepository->get('catalog_product', $attributeCode);
		} catch (\Exception $e) {
			echo "Attribute not found: " . $e->getMessage();
			exit;
		}

		// Fetch existing options
		$existingOptions = $optionCollectionFactory->create()
			->setAttributeFilter($attribute->getAttributeId())
			->getItems();
		// Check if option exists
		$optionExists = false;
		foreach ($existingOptions as $option) {
			if ($option->getValue()=== $optionLabel) {
				$optionExists = true;
				break;
			}
		}

		// Add new option if not exists
		if (!$optionExists) {
			try {
			/** @var AttributeOptionInterface $option */
			$option = $objectManager->create(AttributeOptionInterface::class);
			$option->setLabel($optionLabel);
			$option->setSortOrder(0);
			$option->setIsDefault(false);

			$optionManagement->add(
				\Magento\Catalog\Model\Product::ENTITY,
				$attributeCode,
				$option
			);
			} catch (\Exception $e) {
			echo "Error adding option: " . $e->getMessage();
			}
		}
	}
}