<?php
namespace Xtwo\Navsync\Console;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Input\InputArgument;
use Magento\Framework\File\Csv;
use Magento\Framework\App\State;
use Magento\Framework\App\Filesystem\DirectoryList;

class M1Export extends Command{
	public function __construct(
        \Magento\Framework\App\Response\Http\FileFactory $fileFactory,
        \Magento\Framework\App\Filesystem\DirectoryList $directoryList,
		Csv $csv,
		\Magento\Framework\Filesystem $filesystem,
    ) {
        $this->_fileFactory = $fileFactory;
        $this->directoryList = $directoryList;
		$this->directory = $filesystem->getDirectoryWrite(DirectoryList::MEDIA);
		$this->csv = $csv;
        parent::__construct();
    }
   protected function configure(){
	   $options = [
			new InputOption(
				'startdate',
				null,
				InputOption::VALUE_REQUIRED,
				'start date'
			),
			new InputOption(
				'enddate',
				null,
				InputOption::VALUE_REQUIRED,
				'end date'
			),
			new InputOption(
				'limit',
				null,
				InputOption::VALUE_REQUIRED,
				'limit'
			),
            new InputOption(
                'entity_id',
                null,
                InputOption::VALUE_REQUIRED,
                'entity_id'
            )
		];
		
       $this->setName('navsync:m1productexport');
       $this->setDescription('Export m1 product with limited attributes vaules in csv format');
	   $this->setDefinition($options);
       
       parent::configure();
   }
   protected function execute(InputInterface $input, OutputInterface $output){
	  $startdate = $input->getOption('startdate');
	  $enddate = $input->getOption('enddate');
	  $limit = $input->getOption('limit');
      $entity_id = $input->getOption('entity_id');
      $response = $this->exportCsvFile($startdate,$enddate,$limit,$entity_id);
      if(!empty($response)){
        $output->writeln("<info>".$response['file']."</info> has been exported <comment>".$response['records']."</comment> products successfully");
      }else{
        $output->writeln("<comment>No Records founds</comment>");
      }
      
   }
   public function getColumnHeader() {
        $headers = [
              'entity_id',
              'sku',
              'attribute_set',
              'nav_id',
              'name',
              'manufacturer',
              'series',
              'shipping_forwarding',
              'weight',
              'price',
              'visibility',
              'status',
              'order_confirmation',
              'tax_class_id',
              'msrp',
              'barcode',
              'delivery_time',
			  'nav_no'
        ];;
        return $headers;
    }
	private function exportCsvFile($startdate='',$enddate='',$limit='',$entity_id=''){
        $exportData = [];
        $content[] = $this->getColumnHeader();
        $dbConnection = $this->m1DbConnection();
		if(isset($startdate) && !empty($startdate)){
            //$startdate= $startdate.' 00:00:00';
            $startdate= $startdate;
        }
        if(isset($enddate) && !empty($enddate)){
            //$enddate= $enddate.' 00:00:00';
            $enddate= $enddate;
        }
        if(isset($limit) && !empty($limit)){
            $limit= "LIMIT ".$limit;
        }
		$dbSelect = "SELECT * from catalog_product_entity ";
        if(isset($startdate) && isset($enddate)){
			//$dbSelect.= " WHERE type_id ='simple' and updated_at >= '" . $startdate . "' and updated_at <= '".$enddate."'";
            $dbSelect.= " WHERE type_id ='simple' and updated_at BETWEEN '" . $startdate . "' and '".$enddate."'";
		}
        if(isset($entity_id) && !empty($entity_id)){
            $dbSelect.= " WHERE entity_id>=".$entity_id;
        }
		$dbSelect.= " ".$limit;

//dd($dbSelect);
        if ($results = $dbConnection->fetchAll($dbSelect)) {
		    foreach($results as $pKey=> $product){
                $productArray[$product['entity_id']] = [
                    'entity_id'=> $product['entity_id'],
                    'sku'=> $product['sku'],
                    'attribute_set_id'=> $this->getProductAttributeSetName($dbConnection,$product['entity_id'],$product['attribute_set_id']), //$product['attribute_set_id'],
                    //'nav_no'=>  $product['nav_no']
                ];
                foreach($this->getAttributes() as $attr){
                    $attributeId = $this->GetAttributeByCode($dbConnection, $attr);
                    //$this->_navSyncLogger->info('navsync product Sku :'.$product['sku']);
					
                    if($attr=='name'){
                        $productName = $this->getProductName($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productName;
                        //$this->_navSyncLogger->info('navsync product name:'.$productName);
					}else if($attr=='nav_id'){
                        if ($attributeId) {
                            $productNavId = $this->getProductNavId($dbConnection, $product['entity_id'], $attributeId);

                            $productArray[$product['entity_id']][$attr] = $productNavId;
                            //$this->_navSyncLogger->info('navsync product nav_id:' . $attributeId);
                        }else{
                           // $productArray[$product['entity_id']][$attr] = '';
                        }						   
                    }else if($attr=='manufacturer'){
                        $productManufacturer = $this->getProductManufacturer($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productManufacturer;
                       // $this->_navSyncLogger->info('navsync product manufacturer:'.$productManufacturer);
                    }else if($attr=='series'){
                        $productSeries = $this->getProductSeries($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productSeries;
                       // $this->_navSyncLogger->info('navsync product series :'.$productSeries);
                    }else if($attr=='shipping_forwarding'){
                        $productShipingForward = $this->getProductShippingForward($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productShipingForward;
                       // $this->_navSyncLogger->info('navsync product shipping_forwarding :'.$productShipingForward);
                    }else if($attr=='weight'){
                        $productWeight = $this->getProductWeight($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productWeight;
                        //$this->_navSyncLogger->info('navsync product weight :'.$productWeight);
                    }else if($attr=='price'){
                        $productPrice = $this->getProductPrice($dbConnection,$product['entity_id'],$attributeId);
                       $productArray[$product['entity_id']][$attr] = $productPrice;
                       //$this->_navSyncLogger->info('navsync product price :'.$productPrice);
                    } else if($attr=='visibility'){
                        $productVisibility = $this->getProductVisibility($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productVisibility;
                       // $this->_navSyncLogger->info('navsync product visibility :'.$productVisibility);
                    } else  if($attr =='status') {
                        $productStatus = $this->getProductStatus($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productStatus;
                       // $this->_navSyncLogger->info('navsync product status :'.$productStatus);
                    }else if($attr =='order_confirmation') {
                        $productOrderConfirm = $this->getProductOrderConfirm($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productOrderConfirm;
                       // $this->_navSyncLogger->info('navsync product order_confirmation :'.$productOrderConfirm);
                    }else if($attr =='tax_class_id') {
                        $productTaxClass = $this->getProductTaxClass($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productTaxClass;
                       // $this->_navSyncLogger->info('navsync product tax_class_id :'.$productTaxClass);
                        
                    }else if($attr =='msrp') {
                        $productMsrp = $this->getProductMsrp($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productMsrp;
                       // $this->_navSyncLogger->info('navsync product msrp :'.$productMsrp);
                        
                    }else if($attr =='barcode') {
                        $productBarcode = $this->getProductBarcode($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productBarcode;
                      //  $this->_navSyncLogger->info('navsync product barcode :'.$productBarcode);
                        
                    }
                    else if ($attr=='delivery_time'){
                        $productDeliveryTime = $this->getProductDeliveryTime($dbConnection,$product['entity_id'],$attributeId);
                        $productArray[$product['entity_id']][$attr] = $productDeliveryTime;
                        //$this->_navSyncLogger->info('navsync product delivery_time :'.$productDeliveryTime);
                    }
					else if ($attr=='nav_no'){
                        
                        $productArray[$product['entity_id']][$attr] = $product['nav_no'];
                        //$this->_navSyncLogger->info('navsync product delivery_time :'.$productDeliveryTime);
                    }		   
                }
            }
			foreach ($productArray as $item) {
                $content[] = [
                    $item['entity_id'],
                    $item['sku'],
                    $item['attribute_set_id'],
                    $item['nav_id'],
                    $item['name'],
                    $item['manufacturer'],
                    $item['series'],
                    $item['shipping_forwarding'],
                    $item['weight'],
                    $item['price'],
                    $item['visibility'],
                    $item['status'],
                    $item['order_confirmation'],
                    $item['tax_class_id'],
                    $item['msrp'],
                    $item['barcode'],
                    $item['delivery_time'],
					$item['nav_no'],				
                    
                ];
            }
          
          $date = (new \DateTime())->format('Y-m-d_H_i_s');
          $filename = 'export-m1-products'. "_{$date}.csv";
          $path = $this->directoryList->getPath('var') . DIRECTORY_SEPARATOR . $filename ;
          $this->csv->saveData($path , $content);
            return ['records'=>count($results),'file'=> $filename];
		}else{
            return 0;
		}
      }
	  
	public function m1DbConnection(){
        $objMgr = \Magento\Framework\App\ObjectManager::getInstance();
        $connectionFactory = $objMgr->get('Magento\Framework\App\ResourceConnection\ConnectionFactory');
        $dbConnection= $connectionFactory->create([
            'host'     => '94.130.217.28',
            'dbname'   => 'c19655655',
            'username' => 'c19655655',
            'password' => 'NbshGshg3#93873j',
            'active' => '1',
        ]);
        return $dbConnection;
    }
	public function GetAttributeByCode($dbConnection,$code){
        if($code){
            $dbSelect = 'SELECT attribute_id FROM eav_attribute WHERE entity_type_id=4 and attribute_code="'.$code.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductWeight($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_decimal  WHERE attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductPrice($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_decimal  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductVisibility($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_int  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductStatus($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_int  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductOrderConfirm($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_int  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductTaxClass($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_int  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductMsrp($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_decimal  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductBarcode($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_varchar  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductShippingForward($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_int  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }

    public function getProductManufacturer($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = "select ao.value from catalog_product_entity p 
            left join catalog_product_entity_int av on p.entity_id = av.entity_id 
            left join eav_attribute a on av.attribute_id = a.attribute_id 
            left join eav_attribute_option_value ao on av.value = ao.option_id 
            where p.entity_id = '" . $entityId . "' and a.attribute_id='" . $attributeId . "'";
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductSeries($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = "select ao.value from catalog_product_entity p 
            left join catalog_product_entity_int av on p.entity_id = av.entity_id 
            left join eav_attribute a on av.attribute_id = a.attribute_id 
            left join eav_attribute_option_value ao on av.value = ao.option_id 
            where p.entity_id = '" . $entityId . "' and a.attribute_id='" . $attributeId . "'";
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductDeliveryTime($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect =  "select ao.value from catalog_product_entity p 
            left join catalog_product_entity_int av on p.entity_id = av.entity_id 
            left join eav_attribute a on av.attribute_id = a.attribute_id 
            left join eav_attribute_option_value ao on av.value = ao.option_id 
            where ao.store_id=0 and p.entity_id = '" . $entityId . "' and a.attribute_id='" . $attributeId . "'";
            $results= $dbConnection->fetchone($dbSelect);
            if($results){
                return $results;
            }
        }
    }
    public function getProductNavId($dbConnection,$entityId,$navId){
        $dbSelect = 'SELECT value FROM catalog_product_entity_varchar  WHERE 
        store_id="0" and attribute_id="'.$navId.'" and entity_id="'.$entityId.'"';
        $result= $dbConnection->fetchOne($dbSelect);
        
        if($result){
            return $result;
        }else{
            return NULL;
        }
    } 

    public function getProductName($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_varchar  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
	  public function getProductAttributeSetName($dbConnection,$entityId,$attributeSetId){
        if($entityId && $attributeSetId){
            $dbSelect = "SELECT attribute_set_name FROM eav_attribute_set eas 
            INNER JOIN catalog_product_entity cpn ON 
            cpn.attribute_set_id= eas.attribute_set_id 
            WHERE eas.attribute_set_id='".$attributeSetId."' AND cpn.entity_id = '" . $entityId . "'";
            $results= $dbConnection->fetchone($dbSelect);
            if($results){
                return $results;
            }
        }
    }
	public function getAttributes(){
        $attributeList=[
           // 'sku',
            'name',
			'nav_id',		 
           // 'attribute_set',
            'weight',
            'price',
            'manufacturer',
            'series',
            'shipping_forwarding',
            'visibility',
            'status',
            'order_confirmation',
            'tax_class_id',
            'msrp',
            'barcode',
            'delivery_time',
			'nav_no'
        ];
        return $attributeList; 
    }
}