<?php

namespace Xtwo\Navsync\Block\Adminhtml\Product\Edit;

use Magento\Store\Model\System\Store;
class Form extends \Magento\Backend\Block\Widget\Form\Generic{


    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Data\FormFactory $formFactory,
        \Magento\Cms\Model\Wysiwyg\Config $wysiwygConfig,
        \Xtwo\Navsync\Model\Source\Status $status,
        Store $systemStore,
        array $data = []
    )
    {
        $this->_wysiwygConfig = $wysiwygConfig;
        $this->_status = $status;
        $this->systemStore = $systemStore;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    /**
     * @return Form
     * @throws \Magento\Framework\Exception\LocalizedException
     */

    protected function _prepareForm(){
        $model = $this->_coreRegistry->registry('row_data');

        $form = $this->_formFactory->create([
            'data' => [
                'id' => 'edit_form', 
                'enctype' => 'multipart/form-data', 
                'action' => $this->getData('action'), 
                'method' => 'post'
            ]
        ]);
        if ($model) {
            $fieldset = $form->addFieldset('base_fieldset', [
                'legend' => __('Nav: Product Sync Details'), 
                'class' => 'fieldset-wide']
            );
            $fieldset->addField('sync_id', 'hidden', [
                'name' => 'sync_id',
                "value" => 1]);
        } else {
            $fieldset = $form->addFieldset('base_fieldset', [
                'legend' => __('Nav: Product Sync Details'), 
                'class' => 'fieldset-wide']);
        }

        $fieldset->addField('sync_title', 'text', [
            'name'     => 'sync_title',
            'label'    => __('Sync title'),
            'title'    => __('Sync title'),
            'value'    => '',
            'required' => true
        ]);


        $fieldset->addField(
            'import_file',
            'file',
            [
                'name' => 'import_file',
                'label' => __('Csv File to Import'),
                'title' => __('Csv File to Import'),
                'required' => false,
                'class' => 'input-file',
            ]
        );
       
        $form->setValues($model ? $model->getData() : '');
        $form->setUseContainer(true);
        $this->setForm($form);
        return parent::_prepareForm();
    }
    
}