<?php
declare(strict_types=1);
namespace Xtwo\NavConnector\Model;

use Xtwo\NavConnector\Api\ProductUpdateInterface;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Catalog\Api\Data\ProductInterfaceFactory;
use Magento\Catalog\Setup\CategorySetupFactory;
use Magento\Eav\Model\Entity\Attribute\SetFactory as AttributeSetFactory;
use Magento\Catalog\Model\ResourceModel\Product\Action as ProductAction;
use Magento\Catalog\Model\Product;
use Magento\Eav\Model\Entity\Attribute as EntityAttribute;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Eav\Model\ResourceModel\Entity\Attribute\Set\CollectionFactory as AttributeCollection;
use Xtwo\NavConnector\Publisher\ProductImport as Publisher;
use Magento\Eav\Model\Config as EavConfig;
use Magento\Eav\Setup\EavSetup;
class ProductUpdate implements ProductUpdateInterface
{
    /**
     * @var ProductRepositoryInterface
     */
    private $productRepository;
	/**
     * @var productModel
     */
    private $productModel;
	/**
     * @var ProductInterfaceFactory
     */
	private $productFactory;
	/**
     * @var CategorySetupFactory
     */
	private $categorySetupFactory;
	/**
     * @var productAction
     */
	private $productAction;
	/**
     * @var entityAttribute
     */
	private $entityAttribute;
	/**
     * @var eavSetupFactory
     */
	private $eavSetupFactory;
	/**
     * @var attributeSetFactory
     */
	private $attributeSetFactory;
	/**
     * @var storeManager
     */
	private $storeManager;
	/**
     * @var attributeSetCollection
     */
	private $attributeSetCollection;
    /**
     * ProductUpdater constructor.
     * @param ProductRepositoryInterface $productRepository
     */
	/**
		 * {@inheritdoc}
		 */
		 /** 
		* @var Publisher
		*/
		private $publisher;
		private $eavConfig;
		private $eavSetup;
    public function __construct(
		ProductRepositoryInterface $productRepository,
		Product $productModel,
		ProductInterfaceFactory $productFactory,
		CategorySetupFactory $categorySetupFactory,
		AttributeSetFactory $attributeSetFactory,
		ProductAction $productAction,
		EntityAttribute $entityAttribute,
		EavSetupFactory $eavSetupFactory,
		StoreManagerInterface $storeManager,
		AttributeCollection $attributeSetCollection,
		\Xtwo\NavConnector\Logger\Logger $navConnectLogger,
		Publisher $publisher,
		EavConfig $eavConfig,
		EavSetup $eavSetup
	){
        $this->productRepository = $productRepository;
		$this->productModel = $productModel;
		$this->productFactory  = $productFactory;
		$this->categorySetupFactory = $categorySetupFactory;
		$this->attributeSetFactory = $attributeSetFactory;
		$this->productAction = $productAction;
		$this->entityAttribute = $entityAttribute;
		$this->eavSetupFactory = $eavSetupFactory;
		$this->storeManager = $storeManager;
		$this->attributeSetCollection = $attributeSetCollection;
		$this->navConnectLogger = $navConnectLogger;
		$this->publisher = $publisher;
		$this->eavConfig = $eavConfig;
		$this->eavSetup = $eavSetup;
    }

    /**
     * {@inheritdoc}
     */
    public function updateProduct($productSku, $productData)
    {
		
		if (!isset($productSku)) {
            throw new \Magento\Framework\Webapi\Exception(__('Please provide product sku.'));
        }
		$responses = [];
		$this->navConnectLogger->info('Nav connector product data: for SKU=> '.$productSku,$productData);
		// Validate input data
        $this->validateData($productData);
		$productStatus = (!empty($productData['status']) && $productData['status']==1)?\Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED:\Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_DISABLED;
		//default attribute set
		$attributeSetId = 4;
		if(!empty($productData['attribute_set'])) {
			$attribute_set = trim($productData['attribute_set']);
			$attributeSetData = $this->attributeSetCollection->create()
			->addFieldToSelect('attribute_set_id')
			->addFieldToFilter('attribute_set_name', $attribute_set)
			->getFirstItem()
			->toArray();
			
			if(!empty($attributeSetData) && !empty($attributeSetData['attribute_set_id'])){
				$attributeSetId = $attributeSetData['attribute_set_id'];
			}else{
				//adding attribute set
				$categorySetup = $this->categorySetupFactory->create();
				$attributeSet = $this->attributeSetFactory->create();
				$entityTypeId = $categorySetup->getEntityTypeId(\Magento\Catalog\Model\Product::ENTITY);
				$attributeSetId = $categorySetup->getDefaultAttributeSetId($entityTypeId);
				$data = [
				'attribute_set_name' => $attribute_set,
				'entity_type_id' => $entityTypeId,
				'sort_order' => 100,
				];
				$attributeSet->setData($data);
				$attributeSet->validate();
				$attributeSet->save();
				$attributeSet->initFromSkeleton($attributeSetId);
				$attributeSet->save();
				$attributeSetId = $attributeSet->getId();
			}
		}
		
		$productExist =$this->productModel->getIdBySku($productSku);
		if($productExist){
			try {
				$product = $this->productRepository->get($productSku);
				$product->setStoreId(\Magento\Store\Model\Store::DEFAULT_STORE_ID);
				$attributeUpdateArray = array();
				if($product){
					$product->setName($productData['name']);
					if(!empty($productData['status'])){
						$product->setStatus($productStatus);
					}
					if(!empty($productData['attribute_set'])) {
						$product->setAttributeSetId($attributeSetId);
					}
					if(!empty($productData['price'])){
						$product->setPrice($productData['price']);
					}
					if(!empty($productData['order_confirmation'])){
						$orderConfirmation = ($productData['order_confirmation'] &&$productData['order_confirmation']==1)?1:0;
						$product->setOrderConfirmation($orderConfirmation)->save();
					}
					
					if(!empty($productData['shipping_forwarding'])){
						$shippingForwarding = ($productData['shipping_forwarding'] &&$productData['shipping_forwarding']==1)?1:0;					
						$product->setShippingForwarding($shippingForwarding)->save();
					}
					if(!empty($productData['visibility'])){
						$product->setVisibility($productData['visibility']);
					}
					if(!empty($productData['nav_id'])){
						$product->setNavId($productData['nav_id']);
					}
					if(!empty($productData['tax_class_id'])){
						$product->setTaxClassId($productData['tax_class_id']);
					}
					if(!empty($productData['barcode'])){
						$product->setBarcode($productData['barcode']);
					}
					if(!empty($productData['msrp'])){
						$product->setMsrp($productData['msrp']);
					}
					// nav code
					if(!empty($productData['nav_no'])){
						$product->setNavNo($productData['nav_no']);
					}
					// end 
					if(!empty($productData['weight'])){
						$product->setWeight($productData['weight']);
					}
					//delivery time
					if(!empty($productData['delivery_time'])){
						
						$delivery_time = trim($productData['delivery_time']);
						//$this->_logger->debug('exist Sku:'.$delivery_time);
						$deliveryTimeId = $this->getOptionIdByLabel($product,'delivery_time',$delivery_time);
						//dd($productData);
						if(empty($deliveryTimeId)){
							
							$this->addAttributeOptionCust('delivery_time',$delivery_time);
							//dd($productData);
						}
						$deliveryTimeId = $this->getOptionIdByLabel($product,'delivery_time',$delivery_time);
						$product->setCustomAttribute('delivery_time', $deliveryTimeId);
						
					}
					$product->setData('delivery_time', $deliveryTimeId);
					// end delivery time
					// manufacture
					if(!empty($productData['manufacturer'])){
						$manufacturer = trim($productData['manufacturer']);
						$manufacturerOptionId = $this->getOptionIdByLabel($product,'manufacturer',$manufacturer);
						if(empty($manufacturerOptionId)){
							$this->addAttributeOption('manufacturer',$manufacturer);
						}
						$manufacturerOptionId = $this->getOptionIdByLabel($product,'manufacturer',$manufacturer);
						$product->setData('manufacturer', $manufacturerOptionId);
					}
					// manufacture
					//series
					if(!empty($productData['series'])){
						$series = trim($productData['series']);
						$seriesId = $this->getOptionIdByLabel($product,'series',$series);
						if(empty($seriesId)){
							$this->addAttributeOption('series',$series);
						}
						$seriesId = $this->getOptionIdByLabel($product,'series',$series);
						
						$product->setData('series', $seriesId);
					}
					//series
					//special_price_flag
					if(isset($productData['special_price_flag'])){
						
						$special_price_flag = ($productData['special_price_flag'] &&$productData['special_price_flag']==1)?1:2;
						$product->setData('special_price_flag',$special_price_flag);
					}
					$product->save();
					$responses[] = ['success' => true, 'message' => 'Product updated successfully'];
				}
			}catch(\Exception $e){
				 $responses[] = ['success' => false, 'message' => 'Product not found','error'=>$e->getMessage()];			 
			}
		}else{
			$product = $this->productFactory->create();
			$product->setSku($productSku); 
			$product->setName($productData['name'] ); 
			$product->setUrlKey(strtolower(preg_replace('/\s+/', '-', $productData['name'])).'-'.$productSku);
			$product->setAttributeSetId($attributeSetId);
			$product->setStatus($productStatus); 
			$product->setWeight($productData['weight']);
			$product->setVisibility(4); // visibilty of product (catalog / search / catalog, search / Not visible individually)
			$product->setTaxClassId(0); 
			$product->setTypeId('simple'); 
			$product->setPrice($productData['price']);
			// nav code
			if(!empty($productDetail['nav_no'])){
				$product->setNavNo($productData['nav_no']);
			}
			// end 
			$product->setStockData(
				array(
					'use_config_manage_stock' => 0,
					'manage_stock' => 0,
					'is_in_stock' => 0,
					'qty' => 0
				)
			);
			$this->productRepository->save($product);
			$responses[] = ['success' => true, 'message' => 'Product created successfully'];	
		}
		return $responses;
    }
	 /**
     * {@inheritdoc}
     */
	public function updateAllProducts($productData)
    {
		$this->navConnectLogger->info('Nav connector bulk upload');
		$responses = [];
		foreach ($productData as $productDetail) {
			$this->navConnectLogger->info('Nav connector new product data=>',($productDetail));
			 $this->validateData($productDetail);
			try {
			//default attribute set
			$attributeSetId = 4;
			if(!empty($productDetail['attribute_set'])) {
				$attribute_set = trim($productDetail['attribute_set']);
				$attributeSetData = $this->attributeSetCollection->create()
				->addFieldToSelect('attribute_set_id')
				->addFieldToFilter('attribute_set_name', $attribute_set)
				->getFirstItem()
				->toArray();
				
				if(!empty($attributeSetData) && !empty($attributeSetData['attribute_set_id'])){
					$attributeSetId = $attributeSetData['attribute_set_id'];
				}else{
					//adding attribute set
					$categorySetup = $this->categorySetupFactory->create();
					$attributeSet = $this->attributeSetFactory->create();
					$entityTypeId = $categorySetup->getEntityTypeId(\Magento\Catalog\Model\Product::ENTITY);
					$attributeSetId = $categorySetup->getDefaultAttributeSetId($entityTypeId);
					$data = [
					'attribute_set_name' => $attribute_set,
					'entity_type_id' => $entityTypeId,
					'sort_order' => 100,
					];
					$attributeSet->setData($data);
					$attributeSet->validate();
					$attributeSet->save();
					$attributeSet->initFromSkeleton($attributeSetId);
					$attributeSet->save();
					$attributeSetId = $attributeSet->getId();
				}
			}
				$attributeUpdateArray = array();
				$productStatus = (!empty($productDetail['status']) && $productDetail['status']==1)?\Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED:\Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_DISABLED;
				$sku = $productDetail['sku'];
				$product = $this->productRepository->get($sku);
				$product->setStoreId(\Magento\Store\Model\Store::DEFAULT_STORE_ID);
				$price = $productDetail['price'];
				$product->setPrice($price);
				$product->setStatus($productStatus);
				$product->setWeight($productDetail['weight']);
				if(!empty($productDetail['order_confirmation'])){
					$orderConfirmation = ($productDetail['order_confirmation'] &&$productDetail['order_confirmation']==1)?1:0;
					$product->setOrderConfirmation($orderConfirmation);
				}
				if(!empty($productData['attribute_set'])) {
					$product->setAttributeSetId($attributeSetId);
				}
				if(!empty($productDetail['shipping_forwarding'])){
					$shippingForwarding = ($productDetail['shipping_forwarding'] &&$productDetail['shipping_forwarding']==1)?1:0;					
					$product->setShippingForwarding($shippingForwarding);
				}
				if(!empty($productDetail['visibility'])){
					$attributeUpdateArray["visibility"] = $productDetail['visibility'];
				}
				if(!empty($productDetail['nav_id'])){
					//$attributeUpdateArray["nav_id"] = $productDetail['nav_id'];
					$product->setNavId($productDetail['nav_id']);
				}
				if(!empty($productDetail['tax_class_id'])){
					$attributeUpdateArray["tax_class_id"] = $productDetail['tax_class_id'];
				}
				if(!empty($productDetail['barcode'])){
					$product->setBarcode($productDetail['barcode']);
					//$attributeUpdateArray["barcode"] = $productDetail['barcode'];
				}
				if(!empty($productDetail['msrp'])){
					$attributeUpdateArray["msrp"] = $productDetail['msrp'];
					$product->setMsrp($productDetail['msrp']);
				}
				
				// manufacture $product['manufacturer']
				if(!empty($productDetail['manufacturer'])){
					$manufacturer = trim($productDetail['manufacturer']);
					$manufacturerOptionId = $this->getOptionIdByLabel($product,'manufacturer',$manufacturer);
					if(empty($manufacturerOptionId)){
						$this->addAttributeOption('manufacturer',$manufacturer);
					}
					$manufacturerOptionId = $this->getOptionIdByLabel($product,'manufacturer',$manufacturer);
					//$attributeUpdateArray["manufacturer"] = $manufacturerOptionId;
					$product->setData('manufacturer', $manufacturerOptionId);
				}
				// manufacture
				//series
				if(!empty($productDetail['series'])){
					$series = trim($productDetail['series']);
					$seriesId = $this->getOptionIdByLabel($product,'series',$series);
					if(empty($seriesId)){
						$this->addAttributeOption('series',$series);
					}
					$seriesId = $this->getOptionIdByLabel($product,'series',$series);
					
					//$attributeUpdateArray["series"] = $seriesId;
					$product->setData('series', $seriesId);
				}
				//series
				//delivery time
				if(!empty($productDetail['delivery_time'])){
					$delivery_time = $productDetail['delivery_time'];
					$deliveryTimeId = $this->getOptionIdByLabel($product,'delivery_time',$delivery_time);
					if(empty($deliveryTimeId)){
						$this->addAttributeOption('delivery_time',$delivery_time);
					}
					
					$deliveryTimeId = $this->getOptionIdByLabel($product,'delivery_time',$delivery_time);
					//$attributeUpdateArray["delivery_time"] = $deliveryTimeId;
					$product->setData('delivery_time', $deliveryTimeId);
				}
				//delivery time
				//$this->productAction->updateAttributes([$product->getId()], $attributeUpdateArray, 0);
				if(!empty($productDetail['attribute_set'])){
					$product->setAttributeSetId($attributeSetId);
				}
				// nav code
				if(!empty($productDetail['nav_code'])){
					$product->setNavNo($productDetail['nav_code']);
				}
				// end 
				//special_price_flag
				if(isset($productDetail['special_price_flag'])){
					$special_price_flag = ($productDetail['special_price_flag'] &&$productDetail['special_price_flag']==1)?1:2;
					$product->setData('special_price_flag',$special_price_flag);
				}

				try {
					$this->productRepository->save($product);
					 $responses[] = ['success' => true, 'message' => "Product with sku $sku updated successfully","product_id"=>$product->getId()];
				} catch (\Exception $e) {
					$messages[] = $product['sku'].' =>'.$e->getMessage();
					$responses[] = ['success' => false, 'message' => "Product with sku $sku having issue:".$e->getMessage(),"product_id"=>$product->getId()];
				}
			} catch (\Magento\Framework\Exception\LocalizedException $e) {
				$responses[] = ['success' => false, 'message' => "Product with sku $sku having issue". $e->getMessage(),"product_id"=>$product->getId()];
			}
        }
		 return $responses;
	}
	public function addProduct($productData){
		if (!isset($productData['sku'])) {
            throw new \Magento\Framework\Webapi\Exception(__('Please provide product sku.'));
        }
		$response = [];
		$this->navConnectLogger->info('Nav connector new product create data=>',($productData));
		try{
			$this->validateData($productData);
			$attributeSetId = 4;
			if(!empty($productData['attribute_set'])) {
				$attribute_set = trim($productData['attribute_set']);
				$attributeSetData = $this->attributeSetCollection->create()
				->addFieldToSelect('attribute_set_id')
				->addFieldToFilter('attribute_set_name', $attribute_set)
				->getFirstItem()
				->toArray();
				
				if(!empty($attributeSetData) && !empty($attributeSetData['attribute_set_id'])){
					$attributeSetId = $attributeSetData['attribute_set_id'];
				}else{
					//adding attribute set
					$categorySetup = $this->categorySetupFactory->create();
					$attributeSet = $this->attributeSetFactory->create();
					$entityTypeId = $categorySetup->getEntityTypeId(\Magento\Catalog\Model\Product::ENTITY);
					$attributeSetId = $categorySetup->getDefaultAttributeSetId($entityTypeId);
					$data = [
					'attribute_set_name' => $attribute_set,
					'entity_type_id' => $entityTypeId,
					'sort_order' => 100,
					];
					$attributeSet->setData($data);
					$attributeSet->validate();
					$attributeSet->save();
					$attributeSet->initFromSkeleton($attributeSetId);
					$attributeSet->save();
					$attributeSetId = $attributeSet->getId();
				}
			}
			$productStatus = (!empty($productData['status']) && $productData['status']==1)?\Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED:\Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_DISABLED;

			$productWeight = (!empty($productData['weight']))?$productData['weight']:0;
			$product = $this->productFactory->create();
			$product->setSku($productData['sku']); 
			$product->setName($productData['name'] ); 
			$product->setUrlKey(strtolower(preg_replace('/\s+/', '-', $productData['name'])).'-'.$productData['sku']);
			$product->setAttributeSetId($attributeSetId);
			$product->setStatus($productStatus); 
			$product->setWeight($productWeight);
			
			$product->setTypeId('simple'); 
			$product->setPrice($productData['price']);
			if(!empty($productData['order_confirmation'])){
				$orderConfirmation = ($productData['order_confirmation'] &&$productData['order_confirmation']==1)?1:0;
				$product->setOrderConfirmation($orderConfirmation);
			}
			if(!empty($productData['shipping_forwarding'])){
				$shippingForwarding = ($productData['shipping_forwarding'] &&$productData['shipping_forwarding']==1)?1:0;					
				$product->setShippingForwarding($shippingForwarding);
			}
			if(!empty($productData['visibility'])){
				$product->setVisibility($productData['visibility']); // visibilty of product (catalog / search / catalog, search / Not visible individually)
			}
			if(!empty($productData['tax_class_id'])){
				$attributeUpdateArray["tax_class_id"] = $productData['tax_class_id'];
				$product->setTaxClassId($productData['tax_class_id']);
			}else{
				$product->setTaxClassId(0);
			}
			if(!empty($productData['barcode'])){
				$product->setCustomAttribute('barcode', $productData['barcode']);
			}
			if(!empty($productData['msrp'])){
				$product->setCustomAttribute('msrp', $productData['msrp']);
				
			}
			
			// manufacture $productData['manufacturer']
			if(!empty($productData['manufacturer'])){
				$manufacturer = trim($productData['manufacturer']);
				$manufacturerOptionId = $this->getOptionIdByLabel($product,'manufacturer',$manufacturer);
				if(empty($manufacturerOptionId)){
					$this->addAttributeOption('manufacturer',$manufacturer);
				}
				$manufacturerOptionId = $this->getOptionIdByLabel($product,'manufacturer',$manufacturer);
				$product->setCustomAttribute('manufacturer', $manufacturerOptionId);
			}
			// manufacture
			//series
			if(!empty($productData['series'])){
				$series = trim($productData['series']);
				$seriesId = $this->getOptionIdByLabel($product,'series',$series);
				if(empty($seriesId)){
					$this->addAttributeOption('series',$series);
				}
				$seriesId = $this->getOptionIdByLabel($product,'series',$series);
				
				$product->setCustomAttribute('series', $seriesId);
			}
			//series
			//delivery time
			if(!empty($productData['delivery_time'])){
				$delivery_time = trim($productData['delivery_time']);
				$deliveryTimeId = $this->getOptionIdByLabel($product,'delivery_time',$delivery_time);
				if(empty($deliveryTimeId)){
					$this->addAttributeOption('delivery_time',$delivery_time);
				}
				
				$deliveryTimeId = $this->getOptionIdByLabel($product,'delivery_time',$delivery_time);
				$product->setCustomAttribute('delivery_time', $deliveryTimeId);
				
			}
			// nav code
			if(!empty($productData['nav_code'])){
				$product->setNavNo($productData['nav_code']);
			}
			// nav code
			if(!empty($productData['nav_id'])){
				$product->setNavId($productData['nav_id']);
			}
			// end
			//special_price_flag
			if(isset($productData['special_price_flag'])){
				$special_price_flag = ($productData['special_price_flag'] &&$productData['special_price_flag']==1)?1:2;
				$product->setData('special_price_flag',$special_price_flag);
			}
			$product->setStockData(
				array(
					'use_config_manage_stock' => 0,
					'manage_stock' => 0,
					'is_in_stock' => 0,
					'qty' => 0
				)
			);

			$this->productRepository->save($product);
			
			$response[] = ['success' => true, 'message' => 'Product created successfully'];
			return $response;
			
		}catch (CouldNotSaveException | LocalizedException $e) {
			throw new \Magento\Framework\Webapi\Exception(__('Product creation error: %1', $e->getMessage()), 0, 400);
		}
		
	}
	/**
     * Validate input data
     *
     * @param array $data
     * @throws \Magento\Framework\Webapi\Exception
     */
    private function validateData($data)
    {
        // Check if required fields are present
        if (!isset($data['name'])) {
            throw new \Magento\Framework\Webapi\Exception(__('Please provide product name.'));
        }
		if (!isset($data['price'])) {
            throw new \Magento\Framework\Webapi\Exception(__('Please provide price.'));
        }
		
        // Check price numberic
        if (!is_numeric($data['price'])) {
            throw new \Magento\Framework\Webapi\Exception(__('Price must be a number.'));
        }
    }
	/* Get Option id by Option Label */
    private function getOptionIdByLabel($product,$attributeCode,$optionLabel){
        $isAttributeExist = $product->getResource()->getAttribute($attributeCode);
        $optionId = '';
        $isAttributeExist->setStoreId(0);
        if ($isAttributeExist && $isAttributeExist->usesSource()) {
            $optionId = $isAttributeExist->getSource()->getOptionId($optionLabel);
        }
        return $optionId;
    }
    private function addAttributeOption($attirbuteCode,$optionValue){
        $attribute = $this->entityAttribute->loadByCode('catalog_product', $attirbuteCode);
        $alloptions=$attribute->getSource()->getAllOptions();
        $optionExist = false;
        foreach($alloptions as $option) {
            if($option['label']==$optionValue){
                $optionExist = true;
            }
        }

        if($optionExist==false){
            $option = [$optionValue];
            $allStores = $this->storeManager->getStores();
            $option['attribute_id'] = $attribute->getAttributeId();

            foreach($option as $key=>$value){
                $option['value'][$value][0]=$value;
                    foreach($allStores as $store){
                        $option['value'][$value][$store->getId()] = $value;
                    }
                }
                $eavSetup = $this->eavSetupFactory->create();
                $eavSetup->addAttributeOption($option);
        }
    }
    /**
	* {@inheritdoc}
    */
	public function updateProductData( $productData){
		
		if (!isset($productData['sku'])) {
            throw new \Magento\Framework\Webapi\Exception(__('Please provide product sku.'));
        }
		$productSku = $productData['sku'];
		$responses = [];
		$this->navConnectLogger->info('Nav connector product data: for SKU=> '.$productSku,($productData));
		// Validate input data
        $this->validateData($productData);
		$productStatus = (!empty($productData['status']) && $productData['status']==1)?\Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED:\Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_DISABLED;
		//default attribute set
		$attributeSetId = 4;
		if(!empty($productData['attribute_set'])) {
			$attribute_set = trim($productData['attribute_set']);
			$attributeSetData = $this->attributeSetCollection->create()
			->addFieldToSelect('attribute_set_id')
			->addFieldToFilter('attribute_set_name', $attribute_set)
			->getFirstItem()
			->toArray();
			
			if(!empty($attributeSetData) && !empty($attributeSetData['attribute_set_id'])){
				$attributeSetId = $attributeSetData['attribute_set_id'];
			}else{
				//adding attribute set
				$categorySetup = $this->categorySetupFactory->create();
				$attributeSet = $this->attributeSetFactory->create();
				$entityTypeId = $categorySetup->getEntityTypeId(\Magento\Catalog\Model\Product::ENTITY);
				$attributeSetId = $categorySetup->getDefaultAttributeSetId($entityTypeId);
				$data = [
				'attribute_set_name' => $attribute_set,
				'entity_type_id' => $entityTypeId,
				'sort_order' => 100,
				];
				$attributeSet->setData($data);
				$attributeSet->validate();
				$attributeSet->save();
				$attributeSet->initFromSkeleton($attributeSetId);
				$attributeSet->save();
				$attributeSetId = $attributeSet->getId();
			}
		}
		
		$productExist =$this->productModel->getIdBySku($productSku);
		if($productExist){
			try {
				$product = $this->productRepository->get($productSku);
				//dd($product);
				$product->setStoreId(\Magento\Store\Model\Store::DEFAULT_STORE_ID);
				$attributeUpdateArray = array();
				if($product){
					$product->setName($productData['name']);
					if(!empty($productData['status'])){
						$product->setStatus($productStatus);
					}
					if(!empty($productData['attribute_set'])) {
						$product->setAttributeSetId($attributeSetId);
					}
					if(!empty($productData['price'])){
						$product->setPrice($productData['price']);
					}
					if(!empty($productData['order_confirmation'])){
						$orderConfirmation = ($productData['order_confirmation'] &&$productData['order_confirmation']==1)?1:0;
						$product->setOrderConfirmation($orderConfirmation)->save();
					}
					
					if(!empty($productData['shipping_forwarding'])){
						$shippingForwarding = ($productData['shipping_forwarding'] &&$productData['shipping_forwarding']==1)?1:0;					
						$product->setShippingForwarding($shippingForwarding)->save();
					}
					if(!empty($productData['visibility'])){
						$product->setVisibility($productData['visibility']);
					}
					if(!empty($productData['nav_id'])){
						$product->setNavId($productData['nav_id']);
					}
					if(!empty($productData['tax_class_id'])){
						$product->setTaxClassId($productData['tax_class_id']);
					}
					if(!empty($productData['barcode'])){
						$product->setBarcode($productData['barcode']);
					}
					if(!empty($productData['msrp'])){
						$product->setMsrp($productData['msrp']);
					}
					// nav code
					if(!empty($productData['nav_no'])){
						$product->setNavNo($productData['nav_no']);
					}
					// end 
					if(!empty($productData['weight'])){
						$product->setWeight($productData['weight']);
					}
					//delivery time
					if(!empty($productData['delivery_time'])){
						$delivery_time = $productData['delivery_time'];
						$deliveryTimeId = $this->getOptionIdByLabel($product,'delivery_time',$delivery_time);

						if(empty($deliveryTimeId)){
							$this->addAttributeOption('delivery_time',$delivery_time);
						}
						$deliveryTimeId = $this->getOptionIdByLabel($product,'delivery_time',$delivery_time);
					}
					$product->setData('delivery_time', $deliveryTimeId);
					// end delivery time
					// manufacture
					if(!empty($productData['manufacturer'])){
						$manufacturer = trim($productData['manufacturer']);
						$manufacturerOptionId = $this->getOptionIdByLabel($product,'manufacturer',$manufacturer);
						if(empty($manufacturerOptionId)){
							$this->addAttributeOption('manufacturer',$manufacturer);
						}
						$manufacturerOptionId = $this->getOptionIdByLabel($product,'manufacturer',$manufacturer);
						
						$product->setData('manufacturer', $manufacturerOptionId);
					}
					// manufacture
					//series
					if(!empty($productData['series'])){
						$series = trim($productData['series']);
						$seriesId = $this->getOptionIdByLabel($product,'series',$series);
						if(empty($seriesId)){
							$this->addAttributeOption('series',$series);
						}
						$seriesId = $this->getOptionIdByLabel($product,'series',$series);
						
						$product->setData('series', $seriesId);
					}
					//series
					//special_price_flag
					if(isset($productData['special_price_flag'])){
						$special_price_flag = ($productData['special_price_flag'] &&$productData['special_price_flag']==1)?1:2;
						$product->setData('special_price_flag',$special_price_flag);
					}
					//
					$product->save();
					$responses[] = ['success' => true, 'message' => 'Product updated successfully'];
				}
			}catch(\Exception $e){
				 $responses[] = ['success' => false, 'message' => 'Product not found','error'=>$e->getMessage()];			 
			}
		}else{
			$product = $this->productFactory->create();
			$product->setSku($productSku); 
			$product->setName($productData['name'] ); 
			$product->setUrlKey(strtolower(preg_replace('/\s+/', '-', $productData['name'])).'-'.$productSku);
			$product->setAttributeSetId($attributeSetId);
			$product->setStatus($productStatus); 
			$product->setWeight($productData['weight']);
			$product->setVisibility(4); // visibilty of product (catalog / search / catalog, search / Not visible individually)
			$product->setTaxClassId(0); 
			$product->setTypeId('simple'); 
			$product->setPrice($productData['price']);
			// nav code
			if(!empty($productDetail['nav_no'])){
				$product->setNavNo($productData['nav_no']);
			}
			// end 
			$product->setStockData(
				array(
					'use_config_manage_stock' => 0,
					'manage_stock' => 0,
					'is_in_stock' => 0,
					'qty' => 0
				)
			);
			$this->productRepository->save($product);
			$responses[] = ['success' => true, 'message' => 'Product created successfully'];	
		}
		return $responses;
		
	}
	public function updateCreateProducts($product)
    {
        // Your logic to update multiple products goes here
        // $product contains the data sent in the POST request
        // Implement the logic to update products and return a response
		$req = $this->publisher->publish($product);
		return (array)$req;
        //return 'Produ updated successfully!';
    }
	private function addAttributeOptionCust($attributeCode,$optionValue){
		if(!empty($attributeCode)){
			$attribute = $this->eavConfig->getAttribute('catalog_product', $attributeCode);
			$option['attribute_id'] = $attribute->getAttributeId();
			if(!empty($optionValue)){
				$option['value'][$optionValue][0] = $optionValue;
			}
			$this->eavSetup->addAttributeOption($option);
		}
	}
}
