<?php
namespace Xtwo\NavConnector\Model;

use Xtwo\NavConnector\Api\OrderUpdateInterface;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Customer\Api\CustomerRepositoryInterface;


class OrderUpdate implements OrderUpdateInterface
{
    /**
     * @var OrderRepositoryInterface
     */
    private $orderRepository;/**
     * @var OrderFactory
     */
    private $orderFactory;
	/** @var OrderFactory
     */
    private $logger;
	 /** @var CustomerRepositoryInterface
     */
	private $customerRepositoryInterface;
    public function __construct(
        OrderRepositoryInterface $orderRepository,
		\Magento\Sales\Model\OrderFactory $orderFactory,
		CustomerRepositoryInterface $customerRepositoryInterface,
		\Xtwo\NavConnector\Logger\Logger $navConnectLogger,
    ) {
        $this->orderRepository = $orderRepository;
		$this->orderFactory = $orderFactory;
		$this->customerRepositoryInterface = $customerRepositoryInterface;
		$this->navConnectLogger = $navConnectLogger;
    }

    /**
     * {@inheritdoc}
     */
    public function update($incrementId, $data)
    {
		$this->navConnectLogger->info('Nav connector Order update ID => '.$incrementId,$data);
		$response = [];
		try {
			
			$orderModel = $this->orderFactory->create();
			$order = $orderModel->loadByIncrementId($incrementId);
			$documentListArray = [];
			$documentList = $order->getDocumentList();
			if(!empty($documentList)){
				$documentListArray = explode(',',$documentList);
			}
			if ($order->getEntityId() && ! in_array($order->getStatus(),[\Magento\Sales\Model\Order::STATE_COMPLETE,
				\Magento\Sales\Model\Order::STATE_CANCELED,
				\Magento\Sales\Model\Order::STATE_CLOSED])) {
				
				// Update order data
				if(!empty($data['status']) && $data['status']=='complete'){
					$order->setState(\Magento\Sales\Model\Order::STATE_COMPLETE);
					$order->setStatus(\Magento\Sales\Model\Order::STATE_COMPLETE);
				}else if(!empty($data['status']) &&$data['status']=='processing'){
					$order->setState(\Magento\Sales\Model\Order::STATE_PROCESSING);
					$order->setStatus(\Magento\Sales\Model\Order::STATE_PROCESSING);
				}else if(!empty($data['status']) &&$data['status']=='canceled'){
					$order->setState(\Magento\Sales\Model\Order::STATE_CANCELED);
					$order->setStatus(\Magento\Sales\Model\Order::STATE_CANCELED);
				}
				if(!empty($data['nav_no'])){
					$order->setNavNo($data['nav_no']);
				}
				
				if(!empty($order->getData('customer_id')) && !empty($data['customer_nav_no'])){
					$customerId = $order->getData('customer_id');
					$customer = $this->customerRepositoryInterface->getById($customerId);
					$customer->setNavNo($data['customer_nav_no']); // set nav no
					$this->customerRepositoryInterface->save($customer);
				}
				if(!empty($data['document_file_name'])) {
					$newDocument=[];
					if(strpos($data['document_file_name'], ',') !== false ){
						$newDocument = explode(",",$data['document_file_name']);
					}else{
						$newDocument[] = $data['document_file_name'];
					}
					$documents = array_merge($documentListArray,$newDocument);
					
					$order->setDocumentList(implode($documents));
				}
				
				$this->orderRepository->save($order);

				$response[] = ["success"=> true,"message"=> "Order updated successfully."];
			}else{
				$response[] = ["success"=> false,"message"=> "unable to update order"];
			}
		} catch (\Exception $e) {
			$this->navConnectLogger->info('Nav connector Order update ID => '.$incrementId,array("data"=>$data,"error"=>$e->getMessage()));
			$response[] = ["success"=> false,"message"=> $e->getMessage()];
		}
		return $response;

    }
}
