<?php
namespace Xtwo\NavConnector\Model;

use Xtwo\NavConnector\Api\OrderCreditMemoInterface;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Sales\Model\RefundOrder;
class OrderCreditMemo implements OrderCreditMemoInterface
{
    /**
     * @var OrderRepositoryInterface
     */
    private $orderRepository;/**
     * @var OrderFactory
     */
    private $orderFactory;
	/** @var OrderFactory
     */
    private $logger;
	 /** @var CustomerRepositoryInterface
     */
	private $customerRepositoryInterface;
    public function __construct(
        OrderRepositoryInterface $orderRepository,
		\Magento\Sales\Model\OrderFactory $orderFactory,
		CustomerRepositoryInterface $customerRepositoryInterface,
		\Xtwo\NavConnector\Logger\Logger $navConnectLogger,
		\Magento\Framework\ObjectManagerInterface $objectManager,
		\Magento\Sales\Model\Order\Email\Sender\CreditmemoSender $creditmemoSender,
	    \Magento\Sales\Controller\Adminhtml\Order\CreditmemoLoader $creditmemoLoader,
		RefundOrder $refundOrder
    ) {
        $this->orderRepository = $orderRepository;
		$this->orderFactory = $orderFactory;
		$this->customerRepositoryInterface = $customerRepositoryInterface;
		$this->navConnectLogger = $navConnectLogger;
		$this->_objectManager = $objectManager;
		$this->creditmemoSender = $creditmemoSender;
        $this->creditmemoLoader = $creditmemoLoader;
		$this->refundOrder = $refundOrder;
    }

    /**
     * {@inheritdoc}
     */
    public function updateOrderCreditMemo($incrementId, $data)
    {
		
		//dd($incrementId);
		$this->navConnectLogger->info('Nav connector Order credit memo update ID => '.$incrementId,$data);
		$response = [];
		try {
			
			$orderModel = $this->orderFactory->create();
			$order = $orderModel->loadByIncrementId($incrementId);
			if(!$order->getData()){
				throw new NoSuchEntityException();
			}
			
			$orderId = $order->getEntityId(); // order entity_id
			$creditMemoData = [];
			$creditMemoData['do_offline'] = 1;
			$creditMemoData['shipping_amount'] = 0;
			$creditMemoData['adjustment_positive'] = 0;
			$creditMemoData['adjustment_negative'] = 0;
			$creditMemoData['comment_text'] = $data['comment_text'] ;
			$creditMemoData['send_email'] = 0;
			//$orderItemId= 379729;
			//$creditMemoData['refund_customerbalance_return_enable'] = 0; // for Magento commerce
			$orderItemId = 10; // pass order item id
			//$orderItems = $data['refund_order_item'];
			$itemToCredit[$orderItemId] = ['qty'=>($data['qty']?$data['qty']:1)];
			$creditMemoData['items'] = $itemToCredit;
			if(!isset($data['sku'] )){
				throw new \Magento\Framework\Exception\LocalizedException(
					__('Item Sku not provided.')
				);
				
			}
			if (!$order->canCreditmemo()) {
				//return $response[] =['success' => "false", 'message' => 'Cannot create credit memo for order : ' . $orderId];
			}
			foreach ($order->getAllItems() as $orderItem) {
				($orderItem->getItemId());
				if($orderItem->getSku() == $data['sku'] ){
					$orderItemId = $orderItem->getItemId();
				}
			}
			if ($order->getEntityId() && ! in_array($order->getStatus(),[\Magento\Sales\Model\Order::STATE_CANCELED,
				\Magento\Sales\Model\Order::STATE_CLOSED])) {
				
					try {

						$this->creditmemoLoader->setOrderId($orderId); //pass order id
						$this->creditmemoLoader->setCreditmemo($creditMemoData);
			
						$creditmemo = $this->creditmemoLoader->load();
						if ($creditmemo) {
							if (!$creditmemo->isValidGrandTotal()) {
								throw new \Magento\Framework\Exception\LocalizedException(
									__('The credit memo\'s total must be positive.')
								);
							}
			
							if (!empty($creditMemoData['comment_text'])) {
								$creditmemo->addComment(
									$creditMemoData['comment_text'],
									isset($creditMemoData['comment_customer_notify']),
									isset($creditMemoData['is_visible_on_front'])
								);
			
								$creditmemo->setCustomerNote($creditMemoData['comment_text']);
								//$creditmemo->setCustomerNoteNotify(isset($creditMemoData['comment_customer_notify']));
							}
			
							$creditmemoManagement = $this->_objectManager->create(
								\Magento\Sales\Api\CreditmemoManagementInterface::class
							);
							$creditmemo->getOrder()->setCustomerNoteNotify(!empty($creditMemoData['send_email']));
							$creditmemoManagement->refund($creditmemo, (bool)$creditMemoData['do_offline']);
			
							if (!empty($creditMemoData['send_email'])) {
								$this->creditmemoSender->send($creditmemo);
							}


							$itemIdsToRefund = [];
							/*foreach ($order->getAllItems() as $orderItem) {
								$creditMemoItem = $this->itemCreationFactory->create();
								$creditMemoItem->setQty($orderItem->getQtyOrdered())->setOrderItemId($orderItem->getId());
								$itemIdsToRefund[] = $creditMemoItem;
							}*/


							$this->refundOrder->execute($orderId, $orderItemId);
							//$this->messageManager->addSuccess(__('You created the credit memo.'));
							//$this->_getSession()->getCommentText(true);
							
							$response[] = ["success"=> true,"message"=> "the credit memo has been created successfully."];
						}
					} catch (\Magento\Framework\Exception\LocalizedException $e) {
						//echo $e->getMessage();
						$this->messageManager->addError($e->getMessage());
					} catch (\Exception $e) {
						$this->_objectManager->get(\Psr\Log\LoggerInterface::class)->critical($e);
						//$this->messageManager->addError(__('We can\'t save the credit memo right now.'));
						//echo($e->getMessage());
						echo __('We can\'t save the credit memo right now.');
					}

			}else{
				$response[] = ["success"=> false,"message"=> "unable to update order"];
			}
		} catch (\Exception $e) {
			$this->navConnectLogger->info('Nav connector Order update ID => '.$incrementId,array("data"=>$data,"error"=>$e->getMessage()));
			$response[] = ["success"=> false,"message"=> $e->getMessage()];
		}
		return $response;

    }
}
