<?php
namespace Xtwo\NavConnector\Model;

use Xtwo\NavConnector\Api\OrderInterface;
use Magento\Sales\Model\ResourceModel\Order\CollectionFactory as OrderCollectionFactory;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Payone\Core\Model\Source\CreditcardTypes;
class Order implements OrderInterface
{
    /**
     * @var OrderCollectionFactory
     */
    private $orderCollectionFactory;
    /**
	* @var \Fooman\Totals\Model\ResourceModel\OrderTotal\CollectionFactory
     */
    private $orderTotalCollectionFactory;
    /**
	* @var ProductRepositoryInterface
    */
    private $ProductRepositoryInterface;

    public function __construct(
        OrderCollectionFactory $orderCollectionFactory,
		\Magento\Sales\Api\Data\OrderInterface $order,
		ProductRepositoryInterface $productRepository,
		\Fooman\Totals\Model\ResourceModel\OrderTotal\CollectionFactory $orderTotalCollectionFactory,
        \Fooman\Surcharge\Helper\Surcharge $surchargeHelper,
		\Magento\Customer\Api\GroupRepositoryInterface $groupRepository,
    ) {
        $this->orderCollectionFactory = $orderCollectionFactory;
		$this->order = $order;
		$this->productRepository = $productRepository;
		$this->orderTotalCollectionFactory = $orderTotalCollectionFactory;
		$this->groupRepository = $groupRepository;
    }

    /**
     * {@inheritdoc}
     */
    public function getList()
    {
    	$restrictCountryArray =array(
			"AT" =>"Austria",
			"BE" =>"Belgium",
			"BG" =>"Bulgaria",
			"HR" =>"Croatia",
			"CY" =>"Cyprus",
			"CZ" =>"Czechia",
			"DK" =>"Denmark",
			"EE" =>"Estonia",
			"FI" =>"Finland",
			"FR" =>"France",
			"GR" =>"Greece",
			"HU" =>"Hungary",
			"IE" =>"Ireland",
			"IT" =>"Italy",
			"LV" =>"Latvia",
			"LT" =>"Lithuania",
			"LU" =>"Luxembourg",
			"MT" =>"Malta",
			"PL" =>"Poland",
			"PT" =>"Portugal",
			"RO" =>"Romania",
			"SK"=>"Slovakia",
			"SI" =>"Slovenia",
			"ES" =>"Spain",
			"SE" =>"Sweden",
			"NL" =>"Netherlands"
		);
		
        $orders = $this->orderCollectionFactory->create()
		->addFieldToFilter('created_at',['gteq' => date('Y-m-d',strtotime("-4 days"))])
		->addFieldToFilter('nav_no',array('null' => true))
		->addFieldToFilter('status',array('in' => array('pending','processing')))
		->addFieldToFilter('increment_id',array('nin' => array('200000505')))
		//->addFieldToFilter('increment_id',array('in' => array('10000001232','1000062986','1000062987','1000062993','11000002142','11000002143','11000002144','3000047322','6000012412','8000004251')))
		->addAttributeToSort('created_at', 'DESC')
		->setPageSize(10)
		->getData();
		
        $result = [];
		$orderNavSync = true;
		//echo '<pre>';
	//print_r($orders);
        foreach ($orders as $key=>$order) {
			//dd($order);
			// loading order
			$orderTotals = $this->orderTotalCollectionFactory->create()->addFieldToFilter('order_id', $order['entity_id'])->getItems();
																															  
			$order= $this->order->load($order['entity_id']);
			//checking and processing order with status
			//$order = $this->orderFactory->create()->load($order['entity_id']);
			
			//$invoiceCollection = $order->getInvoiceCollection();
			$orderInvoiceState = 0;
			if($order['status']==='processing'){
				$orderInvoices = $order->getInvoiceCollection();
				
				foreach($orderInvoices as $iK=> $orderInvoice){
					if($orderInvoice['state'] == 2){
						$orderInvoiceState = 1;
					}
				}
				if(!$orderInvoiceState){
					$orderNavSync =false;
				}
			}
			if($orderNavSync){
				$payment = $this->order->getPayment();
				$shippingAddress = !$this->order->getIsVirtual() ? $this->order->getShippingAddress() : null;
				$billingAddress = $this->order->getBillingAddress();
				// Customizing the order data as needed
				$additional_information = $payment->getAdditionalInformation();
				$customer_posting_group = $this->getGroupName($order['customer_group_id']);
				$cusGroupArray = array(
					'Amazon' => 'AMAZON',
					'B2B Confirm' => 'B2B CONFIR',
					'B2B-RE-NOVAT' => 'B2B-RE-NOV',
					'B2B-RE-VAT' => 'B2B-RE-VAT',
					'B2B-VK-NOVAT' => 'B2B-VK-NOV',
					'B2B-VK-VAT' => 'B2B-VK-VAT',
					'General' => 'GENERAL',
					'NOT LOGGED IN' => 'NOT LOGGED',
					'Retailer' => 'RETAILER',
					'Wholesale EU' => 'WHOLESALER',
				);
					
				if (isset($cusGroupArray[$customer_posting_group])) {
					$customer_posting_group = $cusGroupArray[$customer_posting_group];
					
				}
				$result[$key] = [
					'entity_id' => $order['entity_id'],
					'order_id' => $order['increment_id'],
					'customer_active' => ($this->order->getData('is_active'))?1:0,
					'email' => $this->order->getData('customer_email'),
					'firstname' => $this->order->getData('customer_firstname') ?? $this->order->getBillingAddress()->getData('firstname'),
					'lastname' => $this->order->getData('lastname') ?? $this->order->getBillingAddress()->getData('lastname'),
					'customer_posting_group' => $customer_posting_group,
					//'vat_order' => (!empty($this->order->getData('customer_taxvat'))?1:0),
					'customer_nav_no' => ($this->order->getData('customer_nav_no')?$this->order->getData('customer_nav_no'):NULL),
					'created_date' => date('m/d/Y',strtotime($order['created_at'])),
					'created_time' => date('H:i:s A',strtotime($order['created_at'])),
					'shipment_created_at' => (!empty($this->getShipmentDate($this->order))?date('Y-m-d',strtotime($this->getShipmentDate($this->order))):NULL),
					'shipping_method' => $this->getShippingMethod($this->order),
					"order_currency_code" => $this->order->getData('order_currency_code'),
					"payment_method"  => $payment->getMethod(),
					"discount_amount" => $this->order->getData('discount_amount'),
					"shipping_amount"  => $this->order->getData('shipping_amount'),
					"subtotal" => $this->order->getData('subtotal'),
					//"base_subtotal_incl_tax" => $this->order->getData('base_subtotal_incl_tax'),
					"subtotal_incl_tax" => $this->order->getData('subtotal_incl_tax'),
					'tax_amount' => $this->order->getData('tax_amount'),
					'base_tax_amount' => $this->order->getData('base_tax_amount'),
					'grand_total_excl_tax' => $this->order->getData('grand_total')-$this->order->getData('base_tax_amount'),
					"grand_total" => $this->order->getData('grand_total'),
					"base_shipping_incl_tax" => $this->order->getData('base_shipping_incl_tax'),
					"shipping_incl_tax" => $this->order->getData('shipping_incl_tax'),
					"billing_name" => $this->order->getBillingAddress()->getData('firstname').($this->order->getBillingAddress()->getData('middlename')?' '.$this->order->getBillingAddress()->getData('middlename'):'').' '.$this->order->getBillingAddress()->getData('lastname'),
					"billing_company" => $this->order->getBillingAddress()->getData('company'),
					"billing_street_full" => $this->order->getBillingAddress()->getData('street'),
					"billing_city" => $this->order->getBillingAddress()->getData('city'),
					"billing_region" => $this->order->getBillingAddress()->getData('region'),
					"billing_country" => $this->order->getBillingAddress()->getData('country_id'),
					"billing_postcode" => $this->order->getBillingAddress()->getData('postcode'),
					"billing_telephone" => $this->order->getBillingAddress()->getData('telephone'),
					"billing_vat" => $this->order->getBillingAddress()->getData('vat_id'),
					"shipping_name" => ($shippingAddress ? $shippingAddress->getData('firstname') : '').($shippingAddress ? $shippingAddress->getData('middlename') : '').' '.($shippingAddress ? $shippingAddress->getData('lastname') : ''),
					"shipping_company" => $shippingAddress->getData('company'),
					"shipping_street_full" => $shippingAddress ? $shippingAddress->getData('street') : '',
					"shipping_city" => $shippingAddress ? $shippingAddress->getData('city') : '',
					"shipping_region" => $shippingAddress ? $shippingAddress->getData('region') : '',
					"shipping_country" => $shippingAddress ? $shippingAddress->getData('country_id') : '',
					"shipping_postcode" => $shippingAddress ? $shippingAddress->getData('postcode') : '',
					"shipping_telephone" => $shippingAddress ? $shippingAddress->getData('telephone') : '',
					"shipping_vat" => $shippingAddress ? $shippingAddress->getData('vat_id') : ''
				];
				if(!empty($this->order->getBillingAddress()->getData('country_id')) && 
					array_key_exists($this->order->getBillingAddress()->getData('country_id'),$restrictCountryArray)){
					 if(!empty($this->order->getBillingAddress()->getData('vat_id')) && $this->order->getData('tax_amount')==0){
						 $result[$key]["approval_status"] = "4";
					 }else if(!empty($this->order->getBillingAddress()->getData('vat_id')) && $this->order->getData('tax_amount')!=0){
						// $result[$key]["approval_status"] = "4";
					 }else if(empty($this->order->getBillingAddress()->getData('vat_id')) && $this->order->getData('tax_amount')==0){
						 $result[$key]["approval_status"] = "4";
					 }else if(empty($this->order->getBillingAddress()->getData('vat_id')) && $this->order->getData('tax_amount')!=0){
						 //$result[$key]["approval_status"] = "4";
					 }
				}
				if(!empty($additional_information)){
					if($payment->getMethod() == 'payone_creditcard'){
						
						//$result[$key]['payment_details']['truncatedcardpan'] = $additional_information['truncatedcardpan'];
						//$result[$key]['payment_details']['cardtype'] = $this->getCreditcardType($additional_information['cardtype']);
						//$result[$key]['payment_details']['cardexpireyear'] = substr($additional_information['cardexpiredate'],0,2);
						//$result[$key]['payment_details']['cardexpiremonth'] = substr($additional_information['cardexpiredate'],2,2);
						//$result[$key]['payment_details']['cardholder'] = $additional_information['cardholder'];
						$result[$key]['payment_details']['payment_ref_id'] = (!empty($payment->getLastTransId())?$payment->getLastTransId():NULL);
						$result[$key]['payment_details']['method_title'] = $additional_information['method_title'];
					}else if($payment->getMethod() == 'paypal_express'){
						$result[$key]['payment_details']['method_title'] = $additional_information['method_title'];
						$result[$key]['payment_details']['paypal_payer_id'] = $additional_information['paypal_payer_id'];
						$result[$key]['payment_details']['paypal_payer_email'] = $additional_information['paypal_payer_email'];
						$result[$key]['payment_details']['paypal_payer_status'] = $additional_information['paypal_payer_status'];
						$result[$key]['payment_details']['paypal_address_status'] = $additional_information['paypal_address_status'];
						$result[$key]['payment_details']['paypal_correlation_id'] = $additional_information['paypal_correlation_id'];
						$result[$key]['payment_details']['paypal_express_checkout_payer_id'] = $additional_information['paypal_express_checkout_payer_id'];
						$result[$key]['payment_details']['paypal_express_checkout_token'] = $additional_information['paypal_express_checkout_token'];
						$result[$key]['payment_details']['paypal_protection_eligibility'] = $additional_information['paypal_protection_eligibility'];
						$result[$key]['payment_details']['paypal_payment_status'] = $additional_information['paypal_payment_status'];
						$result[$key]['payment_details']['paypal_pending_reason'] = $additional_information['paypal_pending_reason'];				
					}else if($payment->getMethod() == 'wirecard_checkout_page_cc'){
						$result[$key]['payment_details']['payment_type'] = $additional_information['paymentType'];
						//$result[$key]['payment_details']['truncatedcardpan'] = (!empty($additional_information['maskedPan']))?$additional_information['maskedPan']:NULL;
						//$result[$key]['payment_details']['cardtype'] = $additional_information['paymentType'];
						//$result[$key]['payment_details']['cardexpireyear'] = substr($additional_information['expiry'],0,2);
						//$result[$key]['payment_details']['cardexpiremonth'] = substr($additional_information['expiry'],4,2);
						$result[$key]['payment_details']['method_title'] = NULL;
						$result[$key]['payment_details']['gateway_reference_number'] = (!empty($additional_information['gatewayReferenceNumber']))?$additional_information['gatewayReferenceNumber']:NULL;
						$result[$key]['payment_details']['gateway_contract_number'] = (!empty($additional_information['gatewayContractNumber']))?$additional_information['gatewayContractNumber']:NULL;
						
					}
					
				}else{
					if($payment->getMethod() == 'payone_creditcard'){
						
						//$result[$key]['payment_details']['truncatedcardpan'] = $additional_information['truncatedcardpan'];
						//$result[$key]['payment_details']['cardtype'] = $this->getCreditcardType($additional_information['cardtype']);
						//$result[$key]['payment_details']['cardexpireyear'] = substr($additional_information['cardexpiredate'],0,2);
						//$result[$key]['payment_details']['cardexpiremonth'] = substr($additional_information['cardexpiredate'],2,2);
						//$result[$key]['payment_details']['cardholder'] = $additional_information['cardholder'];
						$result[$key]['payment_details']['payment_ref_id'] = (!empty($payment->getLastTransId())?$payment->getLastTransId():NULL);
						$result[$key]['payment_details']['method_title'] = 'Credit Card';
					}

				}						   
				$orderItems = $this->order->getAllVisibleItems();
				
				$itemInc = 0;
				$item = "";
				$count = 0;
				$orderItemsArray = [];
				$orderItemsTaxArray = [];
				foreach ($orderItems as $item){
					if ($count == 0)  {
						$record = $this->getOrderItemValues($item, $order, ++$itemInc);
						$orderTaxItems = $this->getOrderTaxValues($item, $order, ++$itemInc);
					}else {
						$record = $this->getOrderItemValues($item, $order, ++$itemInc);
						$orderTaxItems = $this->getOrderTaxValues($item, $order, ++$itemInc);
					}
					
					$orderItemsArray[]=$record;
					$orderItemsTaxArray[]=$orderTaxItems;
					$count++;
				}
				if(!empty($this->order->getData('discount_amount'))  && $this->order->getData('discount_amount')!=0.0000){
					 
					$orderItemsArray[] = [
						"type" => "G/L Account",
						"sku" => 8770,
						"name" => "Discount",
						"nav_no" => "8770",
						"location" => "DH1",
						"qty_ordered" => 1,
						"price" => $this->order->getData('discount_amount'), 
					];
				}
				//adding shipping amount to order line store de and subtotal is less then 2000 adding shipping to order line
				/*if(!empty($order['shipping_amount']) && $order['shipping_amount']>0 
					//&& $order['grand_total'] <2000 
					// && $order['store_id']==1
					){
					
					$orderItemsArray[] = [
						"type" => "G/L Account",
						"sku" => 8450,
						"name" => "Shipping",
						"nav_no" => "8450",
						"location" => "DH1",
						"qty_ordered" => 1,
						"price" => $order['shipping_amount'], 
					];
				}*/
				//
				// adding fooman surchange amount
				if(!empty($orderTotals)){
					foreach ($orderTotals as $k=>$orderTotal) {
						//dd($order['store_id']);
						if(!empty($orderTotal['amount']) && $orderTotal['amount']>0){
							$orderItemsArray[]=[
								"type" => "G/L Account",
								"sku" => 8451,
								"name" => $orderTotal['label'],
								"nav_no" => "8451",
								"location" => "DH1",
								"qty_ordered" => 1,
								"price" => (($order['store_id']==1)?$orderTotal['base_amount']: $orderTotal['amount'])
							];
						}
					}
				}
				$result[$key]['order_items']=$orderItemsArray;
				$result[$key]['order_item_taxes']=$orderItemsTaxArray;
			}
        }
        return $result;
    }
	protected function getOrderItemValues($item, $order, $itemInc=1)
    {
		$custom_option = "";
		if($item->hasProductOptions()){
			if (array_key_exists("options",$item->getData('product_options'))){
				$option_coll = $item->getData('product_options')['options'];
				foreach ($option_coll as $cptions) {
					$custom_option .= strip_tags($cptions['label']).";";
				}
			}
		}
		if($item->getProductType() == 'buyerprotect'){
			$tSProduct =$product = $this->productRepository->get($item->getSku());
																		 
			return array(
				//"entity_id" => $item->getProduct()->getEntityId(),
				"type" => "Resource",
				"sku" =>  $tSProduct->getNavNo(),
				"name" => $item->getName(),
				"nav_no" =>  $tSProduct->getNavNo(),
				"location" => "",
				"qty_ordered" => (int)$item->getQtyOrdered(),
				"price" => $item->getPriceInclTax(), 
			);
			
		}else{
			return array(
				//"entity_id" => $item->getProduct()->getEntityId(),
				"type" => "Item",
				"sku" => $item->getSku(),
				"name" => $item->getName(),
				"nav_no" => $item->getProduct()->getNavNo(),
				"location" => "DH1",
				"qty_ordered" => (int)$item->getQtyOrdered(),
				"price" => $item->getPriceInclTax(), 
			);
			
		}
        
    }
	protected function getOrderTaxValues($item, $order, $itemInc=1)
    {
		$custom_option = "";
		if($item->hasProductOptions()){
			if (array_key_exists("options",$item->getData('product_options'))){
				$option_coll = $item->getData('product_options')['options'];
				foreach ($option_coll as $cptions) {
					$custom_option .= strip_tags($cptions['label']).";";
				}
			}
		}
		if($item->getProductType() == 'buyerprotect'){
			$tSProduct =$product = $this->productRepository->get($item->getSku());;
			return array(
				//"entity_id" => $item->getProduct()->getEntityId(),
				//"type" => "Resource",
				"sku" => $tSProduct->getNavNo(),
				"nav_no" => $tSProduct->getNavNo(),
				"tax_amount" => 0,
				"tax_percent" => 0,
			);
			
		}else{
			return array(
				//"entity_id" => $item->getProduct()->getEntityId(),
				"sku" => $item->getSku(),
				"nav_no" => $item->getProduct()->getNavNo(),
				"tax_amount" => $item->getTaxAmount(),
				"tax_percent" => $item->getTaxPercent(), 
			);
		}

    }
	public function getShipmentDate($order)
    {
	    $date = '';
        $collection = $order->getShipmentsCollection();
		if(count($collection))
		{
		 foreach($collection as $data)
		 $date = $data->getData('created_at');
		}
		
		return $date;
    }
	public function getShippingMethod($order)
    {
		
        if (!$order->getIsVirtual() && $order->getShippingMethod()) {
			if($order->getShippingMethod() === 'simpleshipping_simpleshipping'){
				return "freight_freight";
			}else if($order->getShippingMethod() === 'freeshipping_freeshipping'){
				return "free shipping - free";
			}
            return $order->getShippingMethod();
			//return $order->getShippingDescription();										
        }
        else if (!$order->getIsVirtual() && $order->getShippingMethod()) {
        	return $order->getShippingMethod();
        }
        return '';
    }
	protected function getCreditcardType($sShortType)
    {
        $aTypes = CreditcardTypes::getCreditcardTypes();
        foreach ($aTypes as $aTypeEntry) {
            if ($aTypeEntry['cardtype'] === $sShortType) {
                return $aTypeEntry['name'];
            }
        }
        return '';
    }
	public function getGroupName($groupId){
		$group = $this->groupRepository->getById($groupId);
		return $group->getCode();
	}
}