<?php
namespace Xtwo\NavConnector\Model;

use Xtwo\NavConnector\Api\CustomerInterface;
use Magento\Customer\Model\CustomerFactory;
use Magento\Framework\App\ResourceConnection;
class Customer implements CustomerInterface
{
	/**
     * @var CustomerFactory
     */
	protected $customerFactory;
	protected $_customer;

    public function __construct(
		CustomerFactory $customerFactory,
		\Magento\Customer\Model\Customer $customer,
		\Magento\Customer\Api\GroupRepositoryInterface $groupRepository,
		\Magento\Customer\Api\CustomerRepositoryInterface $customerRepository,
		 ResourceConnection $resourceConnection,
		\Xtwo\NavConnector\Logger\Logger $navConnectLogger,
	){
        $this->customerFactory = $customerFactory;
		$this->_customer = $customer;
		$this->groupRepository = $groupRepository;
		$this->customerRepository = $customerRepository;
		$this->resourceConnection = $resourceConnection;
		$this->navConnectLogger = $navConnectLogger;
    }

	 /**
     * {@inheritdoc}
     */
    public function getCustomers()
    {
		/*$customers= $this->_customer->getCollection()
               ->addAttributeToSelect("*")
			   ->addAttributeToFilter("created_at", array("eq" => date('Y-m-d',strtotime("1 days"))))
			   //->addFieldToFilter('nav_no',array("eq" => true))
			   ->addAttributeToSort('created_at', 'DESC')
               ->load();*/
	  $connection = $this->resourceConnection->getConnection();
	  $table = $connection->getTableName('customer_entity');
		//For Select customer
		$query = "Select * FROM " . $table. " WHERE nav_no IS NULL and created_at >='".date('Y-m-d',strtotime("-1 days"))."'";
	
		$customers = $connection->fetchAll($query);
	
		$customerArray =[];
		foreach($customers as $k => $customer){
			$customerGroup = $this->getGroupName($customer['group_id']);
			$customerDetail= $this->_customer->load($customer['entity_id']);
			$customerArray[]=[
				'email' => $customer['email'],
				'firstname' => $customer['firstname'],
				'middlename' => $customer['middlename'],
				'lastname' => $customer['lastname'],
				'created_in' => $customer['created_in'],
				'created_at' => $customer['created_at'],
				'store_id' => $customer['store_id'],
				'is_active' => $customer['is_active'],
				'customer_posting_group' => $customerGroup,
				//'nav_no' => $customerDetail->getNavNo()
			];
		}
	 $connection->closeConnection();
		return $customerArray;
	}
	/**
     * {@inheritdoc}
     */
	public function updateCustomer($customerData){

		$responses= [];
		$this->navConnectLogger->info('Nav connector customer data => ',$customerData);
		try {
			$connection = $this->resourceConnection->getConnection();
			$table = $connection->getTableName('customer_entity');
			//For Select customer
			$query = "Select * FROM " . $table. " WHERE email='".$customerData['email']."'";
			$result = $connection->fetchRow($query);
			if (!empty($result)) {
			
				$query = "UPDATE " . $table . " SET nav_no='".$customerData['nav_no']."' WHERE entity_id = ".$result['entity_id'];
				$connection->query($query);
				$connection->closeConnection();
				$responses[] = ['success' => true, 'message' => 'customer nav no updated'];
			}
		} catch (\Exception $e) {
			$this->navConnectLogger->info('Nav connector customer data => ',array("data"=>$customerData,"error"=>$e->getMessage()));
            $responses[] = ['success' => false, 'message' => 'customer not updated','error'=>$e->getMessage()];	
        }
		return $responses;
		
	}
	public function getGroupName($groupId){
		$group = $this->groupRepository->getById($groupId);
		return $group->getCode();
	}

}