<?php
namespace Xtwo\NavConnector\Model;

use Xtwo\NavConnector\Api\AttributeSetInterface;
use Magento\Catalog\Setup\CategorySetupFactory;
use Magento\Eav\Model\Entity\Attribute\SetFactory as AttributeSetFactory;
use Magento\Eav\Model\Entity\Attribute as EntityAttribute;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Eav\Model\ResourceModel\Entity\Attribute\Set\CollectionFactory as AttributeCollection;

class AttributeSet implements AttributeSetInterface
{
	/**
     * @var categorySetupFactory
     */
	private $categorySetupFactory;
	/**
     * @var entityAttribute
     */
	private $entityAttribute;
	/**
     * @var eavSetupFactory
     */
	private $eavSetupFactory;
	/**
     * @var attributeSetFactory
     */
	private $attributeSetFactory;
	/**
     * @var attributeSetCollection
     */
	private $attributeSetCollection;
	
	public function __construct(
		CategorySetupFactory $categorySetupFactory,
		AttributeSetFactory $attributeSetFactory,
		EntityAttribute $entityAttribute,
		EavSetupFactory $eavSetupFactory,
		AttributeCollection $attributeSetCollection,
	)
	{
		$this->categorySetupFactory = $categorySetupFactory;
		$this->attributeSetFactory = $attributeSetFactory;
		$this->entityAttribute = $entityAttribute;
		$this->eavSetupFactory = $eavSetupFactory;
		$this->attributeSetCollection = $attributeSetCollection;
		
	}
	public function create($attributeSetData)
	{

		$response = [];
		try{
			$this->validateData($attributeSetData);
			if(!empty($attributeSetData['attribute_set'])) {
				$attribute_set = trim($attributeSetData['attribute_set']);
				$attribute_nav_no = trim($attributeSetData['nav_no']);
				$attributeSetData = $this->attributeSetCollection->create()
				->addFieldToSelect('attribute_set_id')
				->addFieldToFilter('attribute_set_name', $attribute_set)
				->getFirstItem()
				->toArray();
				
				if(!empty($attributeSetData) && !empty($attributeSetData['attribute_set_id'])){
					$attributeSetId = $attributeSetData['attribute_set_id'];
					$message = "Attribute set already exists.";
					$success = false;
				}else{
					//adding attribute set
					$categorySetup = $this->categorySetupFactory->create();
					$attributeSet = $this->attributeSetFactory->create();
					$entityTypeId = $categorySetup->getEntityTypeId(\Magento\Catalog\Model\Product::ENTITY);
					$attributeSetId = $categorySetup->getDefaultAttributeSetId($entityTypeId);
					$data = [
					'attribute_set_name' => $attribute_set,
					'entity_type_id' => $entityTypeId,
					'sort_order' => 100,
					'nav_no' => $attribute_nav_no
					];
					$attributeSet->setData($data);
					//$attributeSet->setNavNo($attributeSetData['nav_no']);
					$attributeSet->validate();
					$attributeSet->save();
					$attributeSet->initFromSkeleton($attributeSetId);
					$attributeSet->save();
					$attributeSetId = $attributeSet->getId();
					$message = "Attribute set created successfully.";
					$success = true;
				}
				
				return [ ["success"=> $success,"message"=>__($message)]];
			}
		}catch (CouldNotSaveException | LocalizedException $e) {
			throw new \Magento\Framework\Webapi\Exception(__('Attributeset creation error: %1', $e->getMessage()), 0, 400);
		}
	}
	/**
     * Validate input data
     *
     * @param array $data
     * @throws \Magento\Framework\Webapi\Exception
     */
    private function validateData($data)
    {
        // Check if required fields are present
        if (!isset($data['attribute_set'])) {
            throw new \Magento\Framework\Webapi\Exception(__('Please provide attribute set title.'));
        }
    }
}