<?php
declare(strict_types=1);
namespace Xtwo\NavConnector\Consumer;

use Xtwo\NavConnector\Api\ProductUpdateInterface;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Catalog\Api\Data\ProductInterfaceFactory;
use Magento\Catalog\Setup\CategorySetupFactory;
use Magento\Eav\Model\Entity\Attribute\SetFactory as AttributeSetFactory;
use Magento\Catalog\Model\ResourceModel\Product\Action as ProductAction;
use Magento\Catalog\Model\Product;
use Magento\Eav\Model\Entity\Attribute as EntityAttribute;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Eav\Model\Config as EavConfig;
use Magento\Eav\Setup\EavSetup;										  
use Magento\Eav\Model\ResourceModel\Entity\Attribute\Set\CollectionFactory as AttributeCollection;
use Magento\Framework\App\ResourceConnection;

class ProductImport 
{
	
	protected $_logger;
	
	/**
     * @var ProductRepositoryInterface
     */
    private $productRepository;
	/**
     * @var productModel
     */
    private $productModel;
	/**
     * @var ProductInterfaceFactory
     */
	private $productFactory;
	/**
     * @var CategorySetupFactory
     */
	private $categorySetupFactory;
	/**
     * @var productAction
     */
	private $productAction;
	/**
     * @var entityAttribute
     */
	private $entityAttribute;
	/**
     * @var eavSetupFactory
     */
	private $eavSetupFactory;
	/**
     * @var attributeSetFactory
     */
	private $attributeSetFactory;
	/**
     * @var storeManager
     */
	private $storeManager;
	/**
     * @var attributeSetCollection
     */
	private $attributeSetCollection;
    /**
     * ProductUpdater constructor.
     * @param ProductRepositoryInterface $productRepository
     */
	 /**
     * @var \Magento\Framework\Serialize\SerializerInterface
     */
    private $serializer;
	private $eavConfig;
	private $eavSetup;
	
	public function __construct(
        \Psr\Log\LoggerInterface $logger,
		ProductRepositoryInterface $productRepository,
		Product $productModel,
		ProductInterfaceFactory $productFactory,
		CategorySetupFactory $categorySetupFactory,
		AttributeSetFactory $attributeSetFactory,
		ProductAction $productAction,
		EntityAttribute $entityAttribute,
		EavSetupFactory $eavSetupFactory,
		StoreManagerInterface $storeManager,
		AttributeCollection $attributeSetCollection,
		\Magento\Framework\Serialize\SerializerInterface $serializer,
		\Xtwo\NavConnector\Logger\Logger $navConnectLogger,
		EavConfig $eavConfig,
		EavSetup $eavSetup,
		ResourceConnection $resourceConnection
    ){        
        $this->_logger = $logger;
		$this->productRepository = $productRepository;
		$this->productModel = $productModel;
		$this->productFactory  = $productFactory;
		$this->categorySetupFactory = $categorySetupFactory;
		$this->attributeSetFactory = $attributeSetFactory;
		$this->productAction = $productAction;
		$this->entityAttribute = $entityAttribute;
		$this->eavSetupFactory = $eavSetupFactory;
		$this->storeManager = $storeManager;
		$this->attributeSetCollection = $attributeSetCollection;
		$this->serializer = $serializer;
		$this->navConnectLogger = $navConnectLogger;
		$this->eavConfig = $eavConfig;
		$this->eavSetup = $eavSetup;
		$this->resourceConnection = $resourceConnection;
		

    }
	
	/**
     * consumer process start
     * @param string $operation
     * @return string
     */
	 
	public function consumerProcess($operation)
	{		
		$sh = json_decode($operation,true);
		$this->navConnectLogger->info('Nav connector bulk product => ',$sh);
		$this->_logger->debug(print_r($sh,true));
		$responses = [];
		foreach ($sh as $k =>$productDetail) {
			$this->_logger->debug(print_r($productDetail,true));
			$this->navConnectLogger->info('Nav connector bulk product update => ',$productDetail);
			
			try {
			//default attribute set
			$attributeSetId = 4;
			if(!empty($productDetail['attribute_set'])) {
				$attribute_set = trim($productDetail['attribute_set']);
				$attributeSetData = $this->attributeSetCollection->create()
				->addFieldToSelect('attribute_set_id')
				->addFieldToFilter('attribute_set_name', $attribute_set)
				->getFirstItem()
				->toArray();
				
				if(!empty($attributeSetData) && !empty($attributeSetData['attribute_set_id'])){
					$attributeSetId = $attributeSetData['attribute_set_id'];
				}else{
					//adding attribute set
					$categorySetup = $this->categorySetupFactory->create();
					$attributeSet = $this->attributeSetFactory->create();
					$entityTypeId = $categorySetup->getEntityTypeId(\Magento\Catalog\Model\Product::ENTITY);
					$attributeSetId = $categorySetup->getDefaultAttributeSetId($entityTypeId);
					$data = [
					'attribute_set_name' => $attribute_set,
					'entity_type_id' => $entityTypeId,
					'sort_order' => 100,
					];
					$attributeSet->setData($data);
					$attributeSet->validate();
					$attributeSet->save();
					$attributeSet->initFromSkeleton($attributeSetId);
					$attributeSet->save();
					$attributeSetId = $attributeSet->getId();
				}
			}
			$productStatus = (!empty($productDetail['status']) && $productDetail['status']==1)?\Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED:\Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_DISABLED;

			$productWeight = (!empty($productDetail['weight']))?$productDetail['weight']:0;
			$productPrice = (!empty($productDetail['price']))?$productDetail['price']:0;
			$sku = $productDetail['sku'];
			$productExist =$this->productModel->getIdBySku($sku);
			//here checking sku existing or not
			if($productExist){
				$this->_logger->debug('exist Sku:'.$sku);
				$this->navConnectLogger->info('exist Sku:'.$sku);
				$product = $this->productRepository->getById($productExist);
			}else{
				$this->_logger->debug('creating new Sku:'.$sku);
				$this->navConnectLogger->info('creating Sku:'.$sku);
				$product = $this->productFactory->create();
				$product->setTypeId('simple');
				$product->setVisibility(4);
				$product->setSku($productDetail['sku']);
				$product->setUrlKey(strtolower(preg_replace('#[^0-9a-z]+#i', '-', $productDetail['name'])).'-'.$productDetail['sku']);
				$product->setData('url_key', strtolower(preg_replace('#[^0-9a-z]+#i', '-', $productDetail['name'])).'-'.$productDetail['sku']);
				
				$this->navConnectLogger->info(strtolower(preg_replace('#[^0-9a-z]+#i', '-', $productDetail['name'])).'-'.$productDetail['sku']);
			}
			$product->setStoreId(\Magento\Store\Model\Store::DEFAULT_STORE_ID);
			
			//$product->setName($productDetail['name']);
			 if(isset($productDetail['name']) && !empty($productDetail['name'])){
                $product->setName($productDetail['name']);
            }else{
                $product->setName("NAV imported product-".time());
            }
			if(isset($productDetail['attribute_set'])){
				$product->setAttributeSetId($attributeSetId);
			}else{
				$product->setAttributeSetId(4);
			}
			//$product->setAttributeSetId($attributeSetId);
			$product->setStatus($productStatus); 
			$product->setWeight($productWeight);
			$product->setPrice($productPrice);
			
			if(isset($productDetail['order_confirmation'])){
				$orderConfirmation = ($productDetail['order_confirmation'] &&$productDetail['order_confirmation']==1)?1:2;
				$product->setOrderConfirmation($orderConfirmation);
			}
			
			if(isset($productDetail['shipping_forwarding'])){
				$shippingForwarding = ($productDetail['shipping_forwarding'] &&$productDetail['shipping_forwarding']==1)?1:2;					
				$product->setShippingForwarding($shippingForwarding);
			}
			if(isset($productDetail['visibility'])){
				$product->setVisibility($productDetail['visibility']);
			}
			if(!empty($productDetail['nav_id'])){
				$product->setNavId($productDetail['nav_id']);
			}
			if(!empty($productDetail['tax_class_id'])){
				$query = "select * from tax_class where nav_no='".$productDetail['tax_class_id']."';";
				$this->navConnectLogger->info($query);
				$connection = $this->resourceConnection->getConnection();
				$result = $connection->fetchRow($query);
				if(!empty($result)){
					$result['class_id'];
					$product->setTaxClassId($result['class_id']);
				}
				$connection->closeConnection();
			}
			if(!empty($productDetail['barcode'])){
				$product->setBarcode($productDetail['barcode']);
			}
			if(!empty($productDetail['msrp'])){
				$product->setMsrp($productDetail['msrp']);
			}
			// manufacture $productData['manufacturer']
			if(!empty($productDetail['manufacturer'])){
				
				$manufacturer = ($productDetail['manufacturer']);
				$manufacturerOptionId = $this->getOptionIdByLabel($product,'manufacturer',$manufacturer);
				if(empty($manufacturerOptionId)){
					$manufacturerOptionId = $this->addAttributeOption('manufacturer',$manufacturer);
				}
				//$manufacturerOptionId = $this->getOptionIdByLabel($product,'manufacturer',$manufacturer);
				$product->setData('manufacturer', $manufacturerOptionId);
			}
			
			// manufacture
			//series
			if(!empty($productDetail['series'])){
				
				$series = trim($productDetail['series']);
				$seriesId = $this->getOptionIdByLabel($product,'series',$series);
				if(empty($seriesId)){
					$seriesId = $this->addAttributeOption('series',$series);
				}
				//$seriesId = $this->getOptionIdByLabel($product,'series',$series);
				
				$product->setData('series', $seriesId);
			} 
			
			//delivery time
			if(!empty($productDetail['delivery_time'])){
				$delivery_time = ($productDetail['delivery_time']);
				$this->_logger->debug('exist Sku delivery_time:'.$delivery_time);
				$deliveryTimeId = $this->getOptionIdByLabel($product,'delivery_time',$delivery_time);
				if(empty($deliveryTimeId)){
					//$this->addAttributeOptionCust('delivery_time',$delivery_time);
					$deliveryTimeId = $this->addAttributeOption('delivery_time',$delivery_time);
				}
				//$deliveryTimeId = $this->getOptionIdByLabel($product,'delivery_time',$delivery_time);
				
				$product->setData('delivery_time', $deliveryTimeId);
				
			}
			if(!empty($productDetail['attribute_set'])){
				$product->setAttributeSetId($attributeSetId);
			}else if(!isset($productDetail['attribute_set'])){
				$product->setAttributeSetId(4);
			}
			// nav code
			if(!empty($productDetail['nav_code'])){
				$product->setNavNo($productDetail['nav_code']);
			}
			// end 
			//special_price_flag
			if(isset($productDetail['special_price_flag'])){
				$special_price_flag = ($productDetail['special_price_flag'] &&$productDetail['special_price_flag']==1)?1:2;
				$product->setData('special_price_flag',$special_price_flag);
			}
			try {
				$this->productRepository->save($product);
				$this->navConnectLogger->info("Product with sku $sku updated successfully",["product_id"=>$product->getId()]);
				//return ['success' => true, 'message' => "Product with sku $sku updated successfully","product_id"=>$product->getId()];
			} catch (\Exception $e) {
				$this->_logger->debug($e->getMessage());
				$this->navConnectLogger->info($e->getMessage());
			}
			
			}catch (\Exception $e) {
				$this->_logger->debug($e->getMessage());
				$this->navConnectLogger->info($e->getMessage());
			}
			continue;

		}

	}
	/* Get Option id by Option Label */
    private function getOptionIdByLabel($product,$attributeCode,$optionLabel){
        $isAttributeExist = $product->getResource()->getAttribute($attributeCode);
        $optionId = '';
        $isAttributeExist->setStoreId(0);
        if ($isAttributeExist && $isAttributeExist->usesSource()) {
            $optionId = $isAttributeExist->getSource()->getOptionId($optionLabel);
        }
        return $optionId;
    }
	private function addAttributeOptionCust($attributeCode,$optionValue){
		if(!empty($attributeCode)){
			$attribute = $this->eavConfig->getAttribute('catalog_product', $attributeCode);
			$option['attribute_id'] = $attribute->getAttributeId();
			if(!empty($optionValue)){
				$option['value'][$optionValue][0] = $optionValue;
			}
			$this->eavSetup->addAttributeOption($option);
		}
	}
	private function addAttributeOption($attirbuteCode,$optionValue){
		
		$option_id = "";
        $attribute = $this->entityAttribute->loadByCode('catalog_product', $attirbuteCode);
        $alloptions=$attribute->getSource()->getAllOptions();
        $optionExist = false;
        foreach($alloptions as $option) {
            if($option['label']==$optionValue){
                $optionExist = true;
            }
        }

        if($optionExist==false){
            $option = [$optionValue];
            $allStores = $this->storeManager->getStores();
            $option['attribute_id'] = $attribute->getAttributeId();

            foreach($option as $key=>$value){
			$option['value'][$value][0]=$value;
				foreach($allStores as $store){
					$option['value'][$value][$store->getId()] = $value;
				}
			}
			$eavSetup = $this->eavSetupFactory->create();
			$eavSetup->addAttributeOption($option);
        }
		// write query to get recent added attribute
		$query = "select * from eav_attribute_option_value as eav inner join 
		eav_attribute_option as eao on eav.option_id=eao.option_id 
		where eav.store_id=0 and eao.attribute_id='".$attribute->getAttributeId()."' and 
		eav.value='".$optionValue."' ;";
		$this->navConnectLogger->info($query);
		$connection = $this->resourceConnection->getConnection();
		$result = $connection->fetchRow($query);
		$connection->closeConnection();
		if(!empty($result)){
			$option_id = $result['option_id'];
		}
		return $option_id;
		
    }																  
}