<?php
namespace Xtwo\NavConnector\Console;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Input\InputArgument;
use Magento\Framework\File\Csv;
use Magento\Framework\App\State;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Exception\FileSystemException;
use Magento\Catalog\Api\Data\ProductInterfaceFactory;
class ProductSync extends Command{
	public function __construct(
        \Magento\Framework\App\Response\Http\FileFactory $fileFactory,
        \Magento\Framework\App\Filesystem\DirectoryList $directoryList,
        \Magento\Framework\Filesystem\Driver\File $file,
		Csv $csv,
        \Psr\Log\LoggerInterface $logger,
		\Magento\Framework\Filesystem $filesystem,
        \Magento\Catalog\Api\Data\ProductInterfaceFactory $mageProductFactory,
        \Magento\Catalog\Api\ProductRepositoryInterface $productRepository,
        \Magento\Catalog\Model\ResourceModel\Product\Action $action,
        \Magento\Eav\Model\Entity\Attribute $entityAttribute,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Eav\Setup\EavSetupFactory $eavSetupFactory,
        \Magento\Catalog\Model\Product $productModel,
        \Magento\Framework\App\ResourceConnection $resourceConnection,
        \Magento\Eav\Model\Entity\Attribute\SetFactory $attributeSetFactory,
        \Magento\Eav\Model\ResourceModel\Entity\Attribute\Set\CollectionFactory $attributeSetCollection,
        \Magento\Catalog\Model\ResourceModel\Product $productResourceModel,
        \Magento\Catalog\Setup\CategorySetupFactory $categorySetupFactory,
        \Xtwo\Navsync\Logger\Logger $navSyncLogger,
        ProductInterfaceFactory $productFactory
    ) {
        $this->_fileFactory = $fileFactory;
        $this->directoryList = $directoryList;
        $this->csv = $csv;
        $this->file = $file;
        $this->logger = $logger;
		//$this->directory = $filesystem->getDirectoryWrite(DirectoryList::MEDIA);
        $this->productRepository = $productRepository;
        $this->mageProductFactory = $mageProductFactory;
        $this->productAction = $action;
        $this->entityAttribute = $entityAttribute;
        $this->_storeManager = $storeManager;
        $this->_eavSetupFactory = $eavSetupFactory;
        $this->productModel = $productModel;
        $this->resourceConnection = $resourceConnection;
        $this->attributeSetFactory = $attributeSetFactory;
        $this->attributeSetCollection = $attributeSetCollection;
        $this->productResourceModel = $productResourceModel;
        $this->categorySetupFactory = $categorySetupFactory;
        $this->_navSyncLogger = $navSyncLogger;
        $this->productFactory  = $productFactory;
        parent::__construct();
    }
   protected function configure(){
	   $options = [
        new InputOption(
            'startdate',
            null,
            InputOption::VALUE_REQUIRED,
            'start date'
        ),
        new InputOption(
            'enddate',
            null,
            InputOption::VALUE_REQUIRED,
            'end date'
        ),
        new InputOption(
            'exportfield',
            null,
            InputOption::VALUE_REQUIRED,
            'export field'
        ),
        new InputOption(
            'limit',
            null,
            InputOption::VALUE_REQUIRED,
            'limit'
        )
		];
		
       $this->setName('navconnector:productimport');
       $this->setDescription('Import product');
	   $this->setDefinition($options);
       
       parent::configure();
   }

   protected function execute(InputInterface $input, OutputInterface $output){
    $startdate = $input->getOption('startdate');
	  $enddate = $input->getOption('enddate');
      $exportfield = $input->getOption('exportfield');
	  $limit = $input->getOption('limit');
      $dbConnection = $this->m1DbConnection();
    if(isset($startdate) && !empty($startdate)){
        $startdate= $startdate.' 00:00:00';
    }
    if(isset($enddate) && !empty($enddate)){
        $enddate= $enddate.' 00:00:00';
    }
    if(isset($limit) && !empty($limit)){
        $limit= "LIMIT ".$limit;
    }
    $dbSelect = "SELECT * from catalog_product_entity ";
    if(isset($startdate) && isset($enddate)){
        $dbSelect.= " WHERE type_id ='simple' and updated_at >= '" . $startdate . "' and updated_at <= '".$enddate."'";
    }
    $dbSelect.= " ".$limit;
    
    if ($results = $dbConnection->fetchAll($dbSelect)) {
        foreach($results as $pKey=> $product){
            $nav_no = $product['nav_no'] ;
            if(!empty($nav_no)){
				$connection = $this->resourceConnection->getConnection();
				$table = $connection->getTableName('catalog_product_entity');
				$query = "UPDATE " . $table . " SET nav_no='".$nav_no."' WHERE entity_id ='".$product['entity_id']."' 
                and sku='".$product['sku']."' ";
				$connection->query($query);
				$connection->closeConnection();
                $output->writeln('<comment>SKU:</comment> <info>'.$product['sku'].'</info> NAV NO <comment>'.$nav_no.'</comment> has been updated.');
			}
            
        }
        
    }else{
        return 0;
    }
      
   }
   private function exportCsvFile($startdate='',$enddate='',$limit='',$exportfield=""){
    $exportData = [];
    $content[] = $this->getColumnHeader();
    
  } 
   public function getColumnHeader() {
        $headers = [
            'entity_id',
            'sku',
           // 'attribute_set',
           // 'nav_id',
           // 'name',
           // 'manufacturer',
           // 'series',
           // 'shipping_forwarding',
          //  'weight',
         //   'price',
          //  'visibility',
          //  'status',
          //  'order_confirmation',
          //  'tax_class_id',
         //   'msrp',
          //  'barcode',
         //   'delivery_time',
            'nav_no'
        ];;
        return $headers;
    }
    public function m1DbConnection(){
        $objMgr = \Magento\Framework\App\ObjectManager::getInstance();
        $connectionFactory = $objMgr->get('Magento\Framework\App\ResourceConnection\ConnectionFactory');
        $dbConnection= $connectionFactory->create([
            //'host'     => 'uat-db.xtwodev.store',
            'host'     => '94.130.217.28',
            'dbname'   => 'c19655655',
            'username' => 'c19655655',
            'password' => 'NbshGshg3#93873j',
            'active' => '1',
        ]);
        return $dbConnection;
    }
	public function GetAttributeByCode($dbConnection,$code){
        if($code){
            $dbSelect = 'SELECT attribute_id FROM eav_attribute WHERE entity_type_id=4 and attribute_code="'.$code.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductWeight($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_decimal  WHERE attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductPrice($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_decimal  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductVisibility($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_int  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductStatus($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_int  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductOrderConfirm($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_int  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductTaxClass($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_int  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductMsrp($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_decimal  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductBarcode($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_varchar  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductShippingForward($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_int  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }

    public function getProductManufacturer($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = "select ao.value from catalog_product_entity p 
            left join catalog_product_entity_int av on p.entity_id = av.entity_id 
            left join eav_attribute a on av.attribute_id = a.attribute_id 
            left join eav_attribute_option_value ao on av.value = ao.option_id 
            where p.entity_id = '" . $entityId . "' and a.attribute_id='" . $attributeId . "'";
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductSeries($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = "select ao.value from catalog_product_entity p 
            left join catalog_product_entity_int av on p.entity_id = av.entity_id 
            left join eav_attribute a on av.attribute_id = a.attribute_id 
            left join eav_attribute_option_value ao on av.value = ao.option_id 
            where p.entity_id = '" . $entityId . "' and a.attribute_id='" . $attributeId . "'";
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
    public function getProductDeliveryTime($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect =  "select ao.value from catalog_product_entity p 
            left join catalog_product_entity_int av on p.entity_id = av.entity_id 
            left join eav_attribute a on av.attribute_id = a.attribute_id 
            left join eav_attribute_option_value ao on av.value = ao.option_id 
            where ao.store_id=0 and p.entity_id = '" . $entityId . "' and a.attribute_id='" . $attributeId . "'";
            $results= $dbConnection->fetchone($dbSelect);
            if($results){
                return $results;
            }
        }
    }
    public function getProductNavId($dbConnection,$entityId,$navId){
        $dbSelect = 'SELECT value FROM catalog_product_entity_varchar  WHERE 
        store_id="0" and attribute_id="'.$navId.'" and entity_id="'.$entityId.'"';
        $result= $dbConnection->fetchOne($dbSelect);
        
        if($result){
            return $result;
        }else{
            return NULL;
        }
    } 

    public function getProductName($dbConnection,$entityId,$attributeId){
        if($entityId && $attributeId){
            $dbSelect = 'SELECT value FROM catalog_product_entity_varchar  WHERE 
            store_id="0" and attribute_id="'.$attributeId.'" and entity_id="'.$entityId.'"';
            $result= $dbConnection->fetchOne($dbSelect);
            if($result){
                return $result;
            }
        }
    }
	  public function getProductAttributeSetName($dbConnection,$entityId,$attributeSetId){
        if($entityId && $attributeSetId){
            $dbSelect = "SELECT attribute_set_name FROM eav_attribute_set eas 
            INNER JOIN catalog_product_entity cpn ON 
            cpn.attribute_set_id= eas.attribute_set_id 
            WHERE eas.attribute_set_id='".$attributeSetId."' AND cpn.entity_id = '" . $entityId . "'";
            $results= $dbConnection->fetchone($dbSelect);
            if($results){
                return $results;
            }
        }
    }
	public function getAttributes(){
        $attributeList=[
           // 'sku',
            //'name',
			//'nav_id',		 
           // 'attribute_set',
           // 'weight',
           // 'price',
           // 'manufacturer',
            //'series',
            //'shipping_forwarding',
            //'visibility',
            //'status',
            //'order_confirmation',
            //'tax_class_id',
            //'msrp',
            //'barcode',
            //'delivery_time',
			'nav_no'
        ];
        return $attributeList; 
    }
}