<?php
namespace Xtwo\NavConnector\Api;

interface ProductUpdateInterface
{
    /**
     * Update product information
     *
     * @param mixed $productSku
     * @param string[] $productData
     * @return array
     */
    public function updateProduct($productSku, $productData);
	/**
     * Update product information
     * @param mixed $productData Array of product updates
     * @return array
	 * @throws \Magento\Framework\Webapi\Exception
     */
    public function updateAllProducts($productData);
	/**
     * Add product information
     * @param string[] $productData
     * @return array
     */
    public function addProduct($productData);
	/**
     * Update product information
     * @param mixed $productData Array of product updates
     * @return array
	 * @throws \Magento\Framework\Webapi\Exception
     */
	public function updateProductData($productData);
    /**
	 * @param mixed $product
     * @return string
     */
    public function updateCreateProducts($product);  
}
