<?php

namespace Xtwo\MultimpleItemUpdateCartApi\Model;

use Xtwo\MultimpleItemUpdateCartApi\Api\CartUpdateInterface;
use Xtwo\MultimpleItemUpdateCartApi\Api\Data\CartItem;
use Magento\Quote\Api\CartRepositoryInterface;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\Exception\LocalizedException;

class CartUpdate implements CartUpdateInterface
{
    private $cartRepository;
    private $productRepository;

    public function __construct(
        CartRepositoryInterface $cartRepository,
        ProductRepositoryInterface $productRepository
    ) {
        $this->cartRepository = $cartRepository;
        $this->productRepository = $productRepository;
    }

    public function updateCartItems($cartId, array $cartItems)
    {
        try {
            $cart = $this->cartRepository->get($cartId);
        } catch (\Exception $e) {
            return false; // Handle the error if the cart does not exist
        }

        foreach ($cartItems as $cartItem) {
            $itemId = $cartItem->getItemId();
            $qty = $cartItem->getQty();

            // Get the product from the cart item
            try {
                $cartItemModel = $cart->getItemById($itemId);
                if ($cartItemModel) {
                    $product = $this->productRepository->getById($cartItemModel->getProduct()->getId());
                }
            } catch (\Exception $e) {
                // Handle the error if the item does not exist or the product is not found
                continue;
            }

            // Check if the requested quantity exceeds the maximum quantity allowed
            $maxAllowedQty = $product->getExtensionAttributes()->getStockItem()->getMaxSaleQty();
            if ($qty > $maxAllowedQty) {
                throw new LocalizedException(
                    __("The requested quantity exceeds the maximum quantity allowed for the product.")
                );
            }

            // Update the cart item quantity
            try {
                $cartItemModel->setQty($qty);
                $cartItemModel->save();
            } catch (\Exception $e) {
                // Handle the error if the item quantity cannot be updated
            }
        }
		$cart->collectTotals();
        $this->cartRepository->save($cart);
        return true;
    }
}
