<?php
namespace Xtwo\Minicart\Plugin\Checkout\Model;

use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;

class DefaultConfigProvider
{
    /**
     * @var CheckoutSession
     */
    protected $checkoutSession;

    /**
     * Constructor
     *
     * @param CheckoutSession $checkoutSession
     */

    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    /**
     * @param ScopeConfigInterface $scopeConfig
     */

    public function __construct(
        CheckoutSession $checkoutSession,
        ScopeConfigInterface $scopeConfig
    ) {
        $this->checkoutSession = $checkoutSession;
        $this->scopeConfig = $scopeConfig;
    }

    public function afterGetConfig(
        \Magento\Checkout\Model\DefaultConfigProvider $subject,
        array $result
    ) {
        $weightUnit = $this->scopeConfig->getValue(
            'general/locale/weight_unit',
            ScopeInterface::SCOPE_STORE
        );
        $productWeight='';
        $items = $result['totalsData']['items'];
        foreach ($items as $index => $item) {
            $quoteItem = $this->checkoutSession->getQuote()->getItemById($item['item_id']);
            $delivery_time = $quoteItem->getProduct()->getAttributeText('delivery_time');
            if($delivery_time){
                $deliveryTime= $delivery_time;
            }else{
                $deliveryTime='';
            }
            if($quoteItem->getProduct()->getWeight()){
                $productWeight = number_format((float) $quoteItem->getProduct()->getWeight(),2) . ' ' . $weightUnit;
            }
            $result['quoteItemData'][$index]['sku'] = $quoteItem->getProduct()->getSku();
            $result['quoteItemData'][$index]['delivery_time'] = $deliveryTime;
            $result['quoteItemData'][$index]['weight'] = $productWeight;
            //$result['totalsData']['items'][$index]['sku'] = $quoteItem->getProduct()->getSku();
            //$result['totalsData']['items'][$index]['delivery_time'] = $deliveryTime;
            //$result['totalsData']['items'][$index]['weight'] = $productWeight;
        }
        //dd($result);
        return $result;
    }
}