<?php
declare(strict_types=1);

namespace Xtwo\Minicart\Plugin\Checkout\CustomerData;

use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Checkout\CustomerData\DefaultItem;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;

class DefaultItemPlugin
{
    /**
     * @var \Magento\Catalog\Api\ProductRepositoryInterface
     */
    private $productRepository;

    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    /**
     * @param ScopeConfigInterface $scopeConfig
     */

    public function __construct(
        ProductRepositoryInterface $productRepository,
        ScopeConfigInterface $scopeConfig
    ) {
        $this->productRepository = $productRepository;
        $this->scopeConfig = $scopeConfig;
    }

    public function afterGetItemData(
        DefaultItem $subject,
        $result
    ) {
        $product = $this->productRepository->get($result['product_sku']);
        $weightUnit = $this->scopeConfig->getValue(
            'general/locale/weight_unit',
            ScopeInterface::SCOPE_STORE
        );
        $productWeight = number_format((float) $product->getData('weight'),2) . ' ' . $weightUnit;

        return \array_merge(
            ['delivery_time' => $product->getAttributeText('delivery_time')],
            ['weight' => $productWeight],
            ['weight_type' => $product->getAttributeText('weight_type')],
            $result
        );
    }
}